/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.graphics.GLDebugBinding;
import com.yandex.runtime.view.PlatformView;
import com.yandex.runtime.view.internal.EGLConfigChooserImpl;
import com.yandex.runtime.view.internal.GLContextFactory;
import com.yandex.runtime.view.internal.MemoryPressureListener;
import com.yandex.runtime.view.internal.PlatformGLRenderer;
import com.yandex.runtime.view.internal.PlatformViewBinding;
import com.yandex.runtime.view.internal.RenderDelegate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PlatformGLSurfaceView
extends GLSurfaceView
implements RenderDelegate,
PlatformView,
PlatformGLRenderer.GLContextListener {
    private static final String LOG_TAG = "PlatformGLSurfaceView";
    private boolean glDebugEnabled;
    private PlatformViewBinding platformViewBinding;
    private MemoryPressureListener memoryPressureListener;
    private int width;
    private int height;

    public PlatformGLSurfaceView(Context context) {
        this(context, null, 0, false);
    }

    public PlatformGLSurfaceView(Context context, boolean glDebugEnabled) {
        this(context, null, 0, glDebugEnabled);
    }

    public PlatformGLSurfaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0, false);
    }

    public PlatformGLSurfaceView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, false);
    }

    public PlatformGLSurfaceView(Context context, AttributeSet attrs, int defStyle, boolean glDebugEnabled) {
        super(context, attrs);
        this.glDebugEnabled = glDebugEnabled;
        DisplayMetrics metrics = new DisplayMetrics();
        Context applicationContext = this.getContext().getApplicationContext();
        WindowManager manager = (WindowManager)applicationContext.getSystemService("window");
        manager.getDefaultDisplay().getMetrics(metrics);
        this.width = metrics.widthPixels;
        this.height = metrics.heightPixels;
        EGLConfigChooserImpl configChooser = new EGLConfigChooserImpl();
        this.setEGLConfigChooser(configChooser);
        this.setEGLContextFactory(new GLContextFactory(glDebugEnabled, configChooser));
        PlatformGLRenderer renderer = new PlatformGLRenderer(this, this);
        this.platformViewBinding = new PlatformViewBinding(renderer, this.width, this.height);
        this.setRenderer(renderer);
        this.setRenderMode(0);
    }

    @Override
    public NativeObject getNativePlatformView() {
        return this.platformViewBinding.getNative();
    }

    @Override
    public void destroyNativePlatformView() {
        this.platformViewBinding.destroyNative();
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void pause() {
        this.platformViewBinding.onPause();
    }

    @Override
    public void resume() {
        this.platformViewBinding.onResume();
    }

    @Override
    public void stop() {
        if (this.memoryPressureListener != null) {
            this.getContext().unregisterComponentCallbacks((ComponentCallbacks)this.memoryPressureListener);
            this.memoryPressureListener = null;
        }
        this.platformViewBinding.onStop();
        this.onPause();
    }

    @Override
    public void start() {
        if (this.memoryPressureListener == null) {
            this.memoryPressureListener = new MemoryPressureListener(this);
            this.getContext().registerComponentCallbacks((ComponentCallbacks)this.memoryPressureListener);
        }
        this.onResume();
        this.platformViewBinding.onStart(this.width, this.height);
    }

    @Override
    public void onMemoryWarning() {
        this.platformViewBinding.onMemoryWarning();
    }

    @Override
    public void setNoninteractive(boolean is) {
        this.platformViewBinding.setNoninteractive(is);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.platformViewBinding.onTouchEvent(event)) {
            return true;
        }
        return super.dispatchTouchEvent(event);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.width = w;
        this.height = h;
        super.onSizeChanged(w, h, oldw, oldh);
        this.platformViewBinding.onSizeChanged(this.width, this.height);
    }

    @Override
    public void onContextCreated() {
        this.handlePreserveEGLContextOnPause();
        if (this.glDebugEnabled) {
            GLDebugBinding.enable();
        }
    }

    private void handlePreserveEGLContextOnPause() {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        String vendor = GLES20.glGetString((int)7936);
        if (vendor != null && vendor.toUpperCase().contains("NVIDIA")) {
            return;
        }
        try {
            Method m = GLSurfaceView.class.getMethod("setPreserveEGLContextOnPause", Boolean.TYPE);
            m.invoke((Object)this, true);
        }
        catch (SecurityException e) {
            Log.e((String)LOG_TAG, (String)"error of calling setPreserveEGLContextOnPause", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)LOG_TAG, (String)"error of calling setPreserveEGLContextOnPause", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)LOG_TAG, (String)"error of calling setPreserveEGLContextOnPause", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)LOG_TAG, (String)"error of calling setPreserveEGLContextOnPause", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)LOG_TAG, (String)"error of calling setPreserveEGLContextOnPause", (Throwable)e);
        }
    }
}

