/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import com.yandex.maps.mobile.R;
import com.yandex.runtime.logging.Logger;
import com.yandex.runtime.view.PlatformGLSurfaceView;
import com.yandex.runtime.view.PlatformGLTextureView;
import com.yandex.runtime.view.PlatformView;
import com.yandex.runtime.view.PlatformVulkanSurfaceView;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PlatformViewFactory {
    private static final Set<String> VULKAN_WHITE_LIST = new HashSet<String>(Arrays.asList("Nexus 5X"));

    public static PlatformView getPlatformView(Context context, Set<Attribute> attrs) {
        boolean vulkanAvailable;
        HashSet notNullAttrs = attrs != null ? attrs : new HashSet();
        PlatformView result = null;
        boolean debugModeEnabled = notNullAttrs.contains((Object)Attribute.RENDER_DEBUG);
        boolean bl = vulkanAvailable = Build.VERSION.SDK_INT >= 26 || Build.VERSION.SDK_INT >= 24 && VULKAN_WHITE_LIST.contains(Build.MODEL);
        if (notNullAttrs.contains((Object)Attribute.MOVABLE)) {
            result = new PlatformGLTextureView(context, debugModeEnabled);
        } else if (vulkanAvailable && notNullAttrs.contains((Object)Attribute.VULKAN_ENABLED)) {
            try {
                result = new PlatformVulkanSurfaceView(context, debugModeEnabled);
            }
            catch (RuntimeException e) {
                Logger.error("Failed to create Vulkan view: " + e.getMessage());
                Logger.error("Falling back to OpenGL view");
            }
        }
        if (result == null) {
            result = new PlatformGLSurfaceView(context, debugModeEnabled);
        }
        if (notNullAttrs.contains((Object)Attribute.NONINTERACTIVE)) {
            result.setNoninteractive(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set<Attribute> convertAttributeSet(Context context, AttributeSet attrs) {
        HashSet<Attribute> result = new HashSet<Attribute>();
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PlatformView, 0, 0);
        try {
            if (a.getBoolean(R.styleable.PlatformView_movable, false)) {
                result.add(Attribute.MOVABLE);
            }
            if (a.getBoolean(R.styleable.PlatformView_noninteractive, false)) {
                result.add(Attribute.NONINTERACTIVE);
            }
            if (a.getBoolean(R.styleable.PlatformView_renderDebug, false)) {
                result.add(Attribute.RENDER_DEBUG);
            }
            if (a.getBoolean(R.styleable.PlatformView_vulkanPreferred, false)) {
                result.add(Attribute.VULKAN_ENABLED);
            }
        }
        finally {
            a.recycle();
        }
        return result;
    }

    public static enum Attribute {
        MOVABLE,
        NONINTERACTIVE,
        RENDER_DEBUG,
        VULKAN_ENABLED;

    }
}

