/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.view.PlatformView;
import com.yandex.runtime.view.internal.MemoryPressureListener;
import com.yandex.runtime.view.internal.PlatformViewBinding;
import com.yandex.runtime.view.internal.VulkanSurfaceView;

public class PlatformVulkanSurfaceView
extends VulkanSurfaceView
implements PlatformView {
    private PlatformViewBinding platformViewBinding;
    private MemoryPressureListener memoryPressureListener;
    private int width;
    private int height;

    public PlatformVulkanSurfaceView(Context context, boolean debugModeEnabled) {
        super(context, debugModeEnabled);
        DisplayMetrics metrics = new DisplayMetrics();
        Context applicationContext = this.getContext().getApplicationContext();
        WindowManager manager = (WindowManager)applicationContext.getSystemService("window");
        manager.getDefaultDisplay().getMetrics(metrics);
        this.width = metrics.widthPixels;
        this.height = metrics.heightPixels;
        this.platformViewBinding = new PlatformViewBinding(this.renderer, this.width, this.height);
    }

    @Override
    public NativeObject getNativePlatformView() {
        return this.platformViewBinding.getNative();
    }

    @Override
    public void destroyNativePlatformView() {
        this.platformViewBinding.destroyNative();
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void pause() {
        this.platformViewBinding.onPause();
    }

    @Override
    public void resume() {
        this.platformViewBinding.onResume();
    }

    @Override
    public void stop() {
        if (this.memoryPressureListener != null) {
            this.getContext().unregisterComponentCallbacks((ComponentCallbacks)this.memoryPressureListener);
            this.memoryPressureListener = null;
        }
        this.platformViewBinding.onStop();
    }

    @Override
    public void start() {
        if (this.memoryPressureListener == null) {
            this.memoryPressureListener = new MemoryPressureListener(this);
            this.getContext().registerComponentCallbacks((ComponentCallbacks)this.memoryPressureListener);
        }
        this.platformViewBinding.onStart(this.width, this.height);
    }

    @Override
    public void onMemoryWarning() {
        this.platformViewBinding.onMemoryWarning();
    }

    @Override
    public void setNoninteractive(boolean is) {
        this.platformViewBinding.setNoninteractive(is);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.platformViewBinding.onTouchEvent(event)) {
            return true;
        }
        return super.dispatchTouchEvent(event);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.width = w;
        this.height = h;
        super.onSizeChanged(w, h, oldw, oldh);
        this.platformViewBinding.onSizeChanged(this.width, this.height);
    }
}

