/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view.internal;

import android.opengl.GLSurfaceView;
import com.yandex.runtime.logging.Logger;
import com.yandex.runtime.view.internal.GLVersionProvider;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;

public class EGLConfigChooserImpl
implements GLSurfaceView.EGLConfigChooser,
GLVersionProvider {
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private static final int EGL_OPENGL_ES3_BIT_KHR = 64;
    private int glVersion = 2;

    public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
        EGLConfig config = null;
        config = EGLConfigChooserImpl.tryChooseConfig(egl, display, EGLConfigChooserImpl.getAttrs(3));
        if (config != null) {
            this.glVersion = 3;
        } else {
            Logger.warn("Could not choose OpenGl ES Version 3 config; Got EGL error " + egl.eglGetError());
            config = EGLConfigChooserImpl.tryChooseConfig(egl, display, EGLConfigChooserImpl.getAttrs(2));
        }
        if (config == null) {
            throw new RuntimeException("eglChooseConfig() failed; Got EGL error " + egl.eglGetError());
        }
        return config;
    }

    @Override
    public int getVersion() {
        return this.glVersion;
    }

    private static EGLConfig tryChooseConfig(EGL10 egl, EGLDisplay display, int[] attrs) {
        EGLConfig[] configs = new EGLConfig[1];
        int[] configsCount = new int[1];
        boolean result = egl.eglChooseConfig(display, attrs, configs, 1, configsCount);
        return result && configsCount[0] > 0 ? configs[0] : null;
    }

    private static int[] getAttrs(int glVersion) {
        return new int[]{12352, glVersion == 3 ? 64 : 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 16, 12326, 8, 12344};
    }
}

