/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view.internal;

import android.opengl.GLSurfaceView;
import com.yandex.runtime.graphics.GLContextVersionBinding;
import com.yandex.runtime.logging.Logger;
import com.yandex.runtime.view.internal.GLVersionProvider;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

public class GLContextFactory
implements GLSurfaceView.EGLContextFactory {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_CONTEXT_FLAGS_KHR = 12540;
    private static final int EGL_CONTEXT_OPENGL_DEBUG_BIT_KHR = 1;
    private final boolean debugEnabled;
    private final GLVersionProvider glVersionProvider;

    private int[] attributes(int glVersion, boolean debugEnabled) {
        int[] nArray;
        if (debugEnabled) {
            int[] nArray2 = new int[5];
            nArray2[0] = 12440;
            nArray2[1] = glVersion;
            nArray2[2] = 12540;
            nArray2[3] = 1;
            nArray = nArray2;
            nArray2[4] = 12344;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 12440;
            nArray3[1] = glVersion;
            nArray = nArray3;
            nArray3[2] = 12344;
        }
        return nArray;
    }

    public GLContextFactory(boolean debugEnabled, GLVersionProvider glVersionProvider) {
        this.debugEnabled = debugEnabled;
        this.glVersionProvider = glVersionProvider;
    }

    private EGLContext tryCreateContext(EGL10 egl, EGLDisplay display, EGLConfig config, boolean debugEnabled) {
        int glVersion = this.glVersionProvider.getVersion();
        Logger.warn("Create OpenGl ES context version " + String.valueOf(glVersion));
        return egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, this.attributes(glVersion, debugEnabled));
    }

    public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
        EGLContext context = null;
        if (this.debugEnabled) {
            Logger.warn("Trying to create debug gl context");
            context = this.tryCreateContext(egl, display, config, true);
            if (context == null || context == EGL10.EGL_NO_CONTEXT) {
                Logger.warn("Could not create debug gl context; Got EGL error " + egl.eglGetError());
            }
        }
        if (!(context != null && context != EGL10.EGL_NO_CONTEXT || (context = this.tryCreateContext(egl, display, config, false)) != null && context != EGL10.EGL_NO_CONTEXT)) {
            throw new RuntimeException("eglCreateContext() failed; Got EGL error " + egl.eglGetError());
        }
        GLContextVersionBinding.setVersion(this.glVersionProvider.getVersion());
        return context;
    }

    public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
        if (!egl.eglDestroyContext(display, context)) {
            throw new RuntimeException("eglDestroyContext() failed; Got EGL error " + egl.eglGetError());
        }
    }
}

