/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view.internal;

import android.graphics.Rect;
import android.opengl.GLSurfaceView;
import com.yandex.runtime.view.internal.EGLConfigChooserImpl;
import com.yandex.runtime.view.internal.GLContextFactory;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;

class GLRenderThread
extends Thread {
    private EGLConfigChooserImpl configChooser;
    private GLContextFactory glContextFactory;
    private GLSurfaceView.Renderer renderer;
    private boolean stopped = false;
    private boolean requested = false;
    private boolean paused = false;
    private EGL10 egl;
    private GL10 gl;
    private EGLDisplay eglDisplay;
    private EGLConfig eglConfig;
    private EGLContext eglContext;
    private EGLSurface eglSurface;
    private Object surface;
    private Rect newViewport = null;

    GLRenderThread(Object surface, EGLConfigChooserImpl configChooser, GLContextFactory glContextFactory, GLSurfaceView.Renderer renderer) {
        super("YMK_RenderThread");
        this.surface = surface;
        this.configChooser = configChooser;
        this.glContextFactory = glContextFactory;
        this.renderer = renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.initGL();
        this.renderer.onSurfaceCreated(this.gl, this.eglConfig);
        while (true) {
            GLRenderThread gLRenderThread = this;
            synchronized (gLRenderThread) {
                while (!(!this.paused && this.requested || this.stopped)) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.stopped) {
                    break;
                }
                this.requested = false;
                if (this.newViewport != null) {
                    this.renderer.onSurfaceChanged(this.gl, this.newViewport.width(), this.newViewport.height());
                    this.newViewport = null;
                }
            }
            this.renderer.onDrawFrame(this.gl);
            this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface);
        }
        this.finishGL();
    }

    public synchronized void requestRender() {
        if (!this.paused) {
            this.requested = true;
            this.notifyAll();
        }
    }

    public synchronized void onPause() {
        this.paused = true;
    }

    public synchronized void onResume() {
        this.paused = false;
        this.requested = true;
        this.notifyAll();
    }

    public synchronized void onSizeChanged(int width, int height) {
        this.newViewport = new Rect(0, 0, width, height);
        this.requestRender();
    }

    public synchronized void finish() {
        this.stopped = true;
        this.notifyAll();
    }

    private void initGL() {
        this.egl = (EGL10)EGLContext.getEGL();
        this.eglDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay() failed");
        }
        int[] version = new int[2];
        this.egl.eglInitialize(this.eglDisplay, version);
        this.checkEglError("eglInitialize() failed");
        this.eglConfig = this.configChooser.chooseConfig(this.egl, this.eglDisplay);
        this.eglContext = this.glContextFactory.createContext(this.egl, this.eglDisplay, this.eglConfig);
        this.eglSurface = this.egl.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, this.surface, null);
        this.checkEglError("eglCreateWindowSurface() failed");
        this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext);
        this.checkEglError("eglMakeCurrent() failed");
        this.gl = (GL10)this.eglContext.getGL();
    }

    private void finishGL() {
        this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        this.checkEglError("eglMakeCurrent() failed");
        this.glContextFactory.destroyContext(this.egl, this.eglDisplay, this.eglContext);
        this.egl.eglDestroySurface(this.eglDisplay, this.eglSurface);
        this.checkEglError("eglDestroySurface() failed");
    }

    private void checkEglError(String errorMessage) {
        int errorCode = this.egl.eglGetError();
        if (errorCode != 12288) {
            throw new RuntimeException(errorMessage + "; Got EGL error " + errorCode);
        }
    }
}

