/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view.internal;

import android.opengl.GLSurfaceView;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.yandex.runtime.view.internal.EGLConfigChooserImpl;
import com.yandex.runtime.view.internal.GLContextFactory;
import com.yandex.runtime.view.internal.GLRenderThread;

public class GLSurface {
    private boolean initialized = false;
    private EGLConfigChooserImpl configChooser = new EGLConfigChooserImpl();
    private GLContextFactory glContextFactory;
    private GLSurfaceView.Renderer renderer;
    private GLRenderThread renderThread;

    public GLSurface(boolean glDebugEnabled) {
        this.glContextFactory = new GLContextFactory(glDebugEnabled, this.configChooser);
    }

    public void onSurfaceAvailable(@NonNull Surface surface, int width, int height) {
        this.renderThread = new GLRenderThread(surface, this.configChooser, this.glContextFactory, this.renderer);
        this.renderThread.onSizeChanged(width, height);
        this.renderThread.start();
        this.initialized = true;
    }

    public void onSurfaceSizeChanged(Surface surface, int width, int height) {
        if (this.initialized) {
            this.renderThread.onSizeChanged(width, height);
        }
    }

    public boolean onSurfaceDestroyed(Surface surface) {
        if (this.initialized) {
            this.stopRenderThread();
        }
        return true;
    }

    public void onSurfaceUpdated(Surface surface) {
    }

    public void onPause() {
        if (this.initialized) {
            this.renderThread.onPause();
        }
    }

    public void onResume() {
        if (this.initialized) {
            this.renderThread.onResume();
        }
    }

    public void requestRender() {
        if (this.initialized) {
            this.renderThread.requestRender();
        }
    }

    public void setRenderer(GLSurfaceView.Renderer renderer) {
        this.renderer = renderer;
    }

    protected void stopRenderThread() {
        this.renderThread.finish();
        try {
            this.renderThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.initialized = false;
    }
}

