/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view.internal;

import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import com.yandex.runtime.view.internal.EGLConfigChooserImpl;
import com.yandex.runtime.view.internal.GLContextFactory;
import com.yandex.runtime.view.internal.GLRenderThread;

public class GLTextureView {
    private EGLConfigChooserImpl eglConfigChooser = new EGLConfigChooserImpl();
    private GLContextFactory glContextFactory;
    private GLRenderThread renderThread;

    public GLTextureView(boolean glDebugEnabled) {
        this.glContextFactory = new GLContextFactory(glDebugEnabled, this.eglConfigChooser);
    }

    protected void setRenderer(SurfaceTexture surfaceTexture, int width, int height, GLSurfaceView.Renderer renderer) {
        assert (!this.isInitialized());
        surfaceTexture.setDefaultBufferSize(width, height);
        this.renderThread = new GLRenderThread(surfaceTexture, this.eglConfigChooser, this.glContextFactory, renderer);
        this.renderThread.onSizeChanged(width, height);
        this.renderThread.start();
    }

    protected void onSizeChanged(int width, int height) {
        if (this.isInitialized()) {
            this.renderThread.onSizeChanged(width, height);
        }
    }

    public void requestRender() {
        if (this.isInitialized()) {
            this.renderThread.requestRender();
        }
    }

    protected void onPause() {
        if (this.isInitialized()) {
            this.renderThread.onPause();
        }
    }

    protected void onResume() {
        if (this.isInitialized()) {
            this.renderThread.onResume();
        }
    }

    public void onTextureDestroyed() {
        if (this.isInitialized()) {
            this.renderThread.finish();
            try {
                this.renderThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.renderThread = null;
        }
    }

    private boolean isInitialized() {
        return this.renderThread != null;
    }
}

