/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view.internal;

import android.graphics.Rect;
import android.opengl.GLSurfaceView;
import android.os.Process;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.view.internal.RenderDelegate;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class PlatformGLRenderer
implements GLSurfaceView.Renderer {
    private Rect viewport = null;
    private boolean isContextLost = false;
    private boolean hasSurface = false;
    private NativeObject nativeObject = null;
    private GLContextListener glContextListener = null;
    private GLSurfaceView.Renderer overlayRenderer = null;

    public PlatformGLRenderer(RenderDelegate renderDelegate) {
        this(renderDelegate, null);
    }

    public PlatformGLRenderer(RenderDelegate renderDelegate, GLContextListener l) {
        this(renderDelegate, l, null);
    }

    public PlatformGLRenderer(RenderDelegate renderDelegate, GLContextListener l, GLSurfaceView.Renderer overlayRenderer) {
        this.nativeObject = PlatformGLRenderer.createNative(renderDelegate);
        this.glContextListener = l;
        this.overlayRenderer = overlayRenderer;
    }

    public void onDrawFrame(GL10 gl) {
        this.renderImpl(this.isContextLost, this.viewport.left, this.viewport.top, this.viewport.width(), this.viewport.height());
        if (this.overlayRenderer != null) {
            this.overlayRenderer.onDrawFrame(gl);
        }
        if (this.isContextLost) {
            this.isContextLost = false;
        }
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Process.setThreadPriority((int)-8);
        if (this.hasSurface) {
            this.isContextLost = true;
        }
        this.hasSurface = true;
        if (this.glContextListener != null) {
            this.glContextListener.onContextCreated();
            this.glContextListener = null;
        }
        if (this.overlayRenderer != null) {
            this.overlayRenderer.onSurfaceCreated(gl, config);
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.viewport = new Rect(0, 0, width, height);
        if (this.overlayRenderer != null) {
            this.overlayRenderer.onSurfaceChanged(gl, width, height);
        }
    }

    private static native NativeObject createNative(RenderDelegate var0);

    private native void renderImpl(boolean var1, int var2, int var3, int var4, int var5);

    public static interface GLContextListener {
        public void onContextCreated();
    }
}

