/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view.internal;

import android.view.MotionEvent;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.bindings.internal.ArchiveWriter;
import com.yandex.runtime.view.internal.PlatformGLRenderer;
import com.yandex.runtime.view.internal.PlatformVulkanRenderer;
import com.yandex.runtime.view.internal.TouchEvent;
import java.nio.ByteBuffer;

public class PlatformViewBinding {
    private NativeObject nativeObject;
    private boolean noninteractive = false;
    private static final String LOG_TAG = "PlatformViewBinding";
    private ArchiveWriter touchEventWriter = new ArchiveWriter();

    public PlatformViewBinding(PlatformGLRenderer renderer, int width, int height) {
        this.nativeObject = PlatformViewBinding.createGLNative(renderer, width, height);
    }

    public PlatformViewBinding(PlatformVulkanRenderer renderer, int width, int height) {
        this.nativeObject = PlatformViewBinding.createVulkanNative(renderer, width, height);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.noninteractive || !TouchEvent.isTouchEvent(event)) {
            return false;
        }
        if (this.nativeObject.isEmpty()) {
            return false;
        }
        TouchEvent.serialize(event, this.touchEventWriter);
        ByteBuffer buffer = this.touchEventWriter.data();
        this.onSerializedTouchEventNative(buffer, buffer.position());
        buffer.clear();
        return true;
    }

    public NativeObject getNative() {
        return this.nativeObject;
    }

    public void destroyNative() {
        this.nativeObject.reset();
    }

    public void setNoninteractive(boolean is) {
        this.noninteractive = is;
    }

    public native void onResume();

    public native void onPause();

    public native void onStart(int var1, int var2);

    public native void onStop();

    public native void onMemoryWarning();

    public native void onSizeChanged(int var1, int var2);

    public native void requestRenderNative();

    private static native NativeObject createGLNative(PlatformGLRenderer var0, int var1, int var2);

    private static native NativeObject createVulkanNative(PlatformVulkanRenderer var0, int var1, int var2);

    private native void onSerializedTouchEventNative(ByteBuffer var1, int var2);
}

