/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view.internal;

import android.view.MotionEvent;
import com.yandex.runtime.bindings.internal.ArchiveWriter;

public class TouchEvent {
    public static boolean isTouchEvent(MotionEvent event) {
        return TouchEvent.getType(event) != null;
    }

    private static Type getType(MotionEvent event) {
        Type result = null;
        switch (event.getActionMasked()) {
            case 0: {
                result = Type.BEGAN;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                result = Type.MOVED;
                break;
            }
            case 1: {
                result = Type.ENDED;
                break;
            }
            case 3: {
                result = Type.CANCELED;
                break;
            }
        }
        return result;
    }

    private static boolean filterAction(MotionEvent event, int desiredActionIndex) {
        return event.getActionMasked() != 6 || event.getActionIndex() != desiredActionIndex;
    }

    private static int getFilteredActionsCount(MotionEvent event) {
        int result = 0;
        for (int i = 0; i < event.getPointerCount(); ++i) {
            if (!TouchEvent.filterAction(event, i)) continue;
            ++result;
        }
        return result;
    }

    public static void serialize(MotionEvent event, ArchiveWriter archive) {
        archive.add(TouchEvent.getType(event), false, Type.class);
        archive.add(event.getEventTime());
        archive.add(TouchEvent.getFilteredActionsCount(event));
        for (int i = 0; i < event.getPointerCount(); ++i) {
            if (!TouchEvent.filterAction(event, i)) continue;
            archive.add(event.getPointerId(i));
            archive.add(event.getX(i));
            archive.add(event.getY(i));
        }
    }

    private static enum Type {
        BEGAN,
        ENDED,
        MOVED,
        CANCELED;

    }
}

