/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.version.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.ide.common.repository.GradleVersion;
import com.yandex.mobileads.lint.base.version.cache.CacheFile;
import com.yandex.mobileads.lint.base.version.cache.CachedVersion;
import com.yandex.mobileads.lint.base.version.cache.CachedVersionValidator;

public final class VersionCache {
    @NonNull
    private static final Object LOCK = new Object();
    @Nullable
    private static volatile VersionCache sInstance;
    @NonNull
    private final CacheFile mCacheFile = new CacheFile();
    @NonNull
    private final CachedVersionValidator mCachedVersionValidator = new CachedVersionValidator();

    private VersionCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static VersionCache getInstance() {
        if (sInstance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new VersionCache();
                }
            }
        }
        return sInstance;
    }

    public void updateVersion(@NonNull GradleVersion version) {
        String versionString = version.toString();
        long updateTime = System.currentTimeMillis();
        CachedVersion cachedVersion = new CachedVersion(versionString, updateTime);
        this.mCacheFile.writeVersion(cachedVersion);
    }

    @Nullable
    public GradleVersion getVersion() {
        CachedVersion cachedVersion = this.mCacheFile.readVersion();
        GradleVersion gradleVersion = this.mCachedVersionValidator.isCachedVersionValid(cachedVersion) ? GradleVersion.tryParse((String)cachedVersion.getVersion()) : null;
        return gradleVersion;
    }
}

