/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.issue;

import androidx.annotation.NonNull;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Severity;
import com.yandex.mobileads.lint.base.issue.IssueInfo;

public class IntervalVersionIssueInfo
implements IssueInfo {
    private static final String ISSUE_DESCRIPTION_PATTERN = "For the adapter to work correctly, use %s library versions starting from %s and prior to %s.";
    @NonNull
    private final String mIssueId;
    @NonNull
    private final String mGroupId;
    @NonNull
    private final String mArtifactId;
    @NonNull
    private final String mMinVersion;
    @NonNull
    private final String mMaxVersion;
    @NonNull
    private final Class<? extends Detector> mDetectorClass;

    public IntervalVersionIssueInfo(@NonNull String issueId, @NonNull String groupId, @NonNull String artifactId, @NonNull String minVersion, @NonNull String maxVersion, @NonNull Class<? extends Detector> detectorClass) {
        this.mIssueId = issueId;
        this.mGroupId = groupId;
        this.mArtifactId = artifactId;
        this.mMinVersion = minVersion;
        this.mMaxVersion = maxVersion;
        this.mDetectorClass = detectorClass;
    }

    @Override
    @NonNull
    public String getIssueId() {
        return this.mIssueId;
    }

    @Override
    @NonNull
    public String getDescription() {
        return String.format(ISSUE_DESCRIPTION_PATTERN, this.mArtifactId, this.mMinVersion, this.mMaxVersion);
    }

    @Override
    @NonNull
    public Severity getSeverity() {
        return Severity.FATAL;
    }

    @NonNull
    public String getGroupId() {
        return this.mGroupId;
    }

    @NonNull
    public String getArtifactId() {
        return this.mArtifactId;
    }

    @NonNull
    public String getMinVersion() {
        return this.mMinVersion;
    }

    @NonNull
    public String getMaxVersion() {
        return this.mMaxVersion;
    }

    @Override
    @NonNull
    public Class<? extends Detector> getDetectorClass() {
        return this.mDetectorClass;
    }
}

