/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.version.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.mobileads.lint.base.version.cache.CachedVersion;

class CachedVersionSerializationUtils {
    CachedVersionSerializationUtils() {
    }

    @Nullable
    public CachedVersion deserialize(@NonNull String stringVersion) {
        CachedVersion cachedVersion;
        try {
            String[] lines = stringVersion.split("\n");
            long updateTime = Long.parseLong(lines[0]);
            String version = lines[1];
            cachedVersion = new CachedVersion(version, updateTime);
        }
        catch (IndexOutOfBoundsException | NumberFormatException ignored) {
            cachedVersion = null;
        }
        return cachedVersion;
    }

    @NonNull
    public String serialize(@NonNull CachedVersion gradleVersion) {
        String result = String.format("%s%n%s", gradleVersion.getUpdateTime(), gradleVersion.getVersion());
        return result;
    }
}

