/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.version.maven;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.ide.common.repository.GradleVersion;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ActualVersionParser {
    public static final String LATEST_VERSION_ELEMENT_NAME = "latest";
    @Nullable
    private String mActualVersion;
    @NonNull
    private final SAXParserFactory mParserFactory = SAXParserFactory.newInstance();
    private boolean mIsActualVersionNode;

    @Nullable
    public GradleVersion parseMavenResponse(@NonNull String response) {
        try {
            SAXParser saxParser = this.mParserFactory.newSAXParser();
            MavenXmlHandler handler = new MavenXmlHandler();
            StringReader stringReader = new StringReader(response);
            InputSource inputSource = new InputSource(stringReader);
            saxParser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return this.mActualVersion != null ? GradleVersion.tryParse((String)this.mActualVersion) : null;
    }

    private class MavenXmlHandler
    extends DefaultHandler {
        private MavenXmlHandler() {
        }

        @Override
        public void startElement(@Nullable String uri, @Nullable String localName, @Nullable String qName, @Nullable Attributes attributes) {
            if (ActualVersionParser.LATEST_VERSION_ELEMENT_NAME.equals(qName)) {
                ActualVersionParser.this.mIsActualVersionNode = true;
            }
        }

        @Override
        public void endElement(@Nullable String uri, @Nullable String localName, @Nullable String qName) {
            if (ActualVersionParser.LATEST_VERSION_ELEMENT_NAME.equals(qName)) {
                ActualVersionParser.this.mIsActualVersionNode = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (ActualVersionParser.this.mIsActualVersionNode) {
                ActualVersionParser.this.mActualVersion = new String(ch, start, length);
            }
        }
    }
}

