/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.checker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.ide.common.repository.GradleCoordinate;
import java.util.regex.Pattern;

class DependencyMatcher {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("^\\$.+");
    @NonNull
    private final String mGroupId;
    @NonNull
    private final String mArtifactId;

    public DependencyMatcher(@NonNull String groupId, @NonNull String artifactId) {
        this.mGroupId = groupId;
        this.mArtifactId = artifactId;
    }

    boolean matches(@Nullable GradleCoordinate dependency) {
        return dependency != null && this.mGroupId.equals(dependency.getGroupId()) && this.mArtifactId.equals(dependency.getArtifactId()) && !EXPRESSION_PATTERN.matcher(dependency.getVersion().toString()).matches();
    }
}

