/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.checker;

import androidx.annotation.NonNull;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.yandex.mobileads.lint.base.checker.DependencyMatcher;
import com.yandex.mobileads.lint.base.checker.DependencyParser;
import com.yandex.mobileads.lint.base.checker.IntervalVersionIssueMessageComposer;
import com.yandex.mobileads.lint.base.checker.VersionChecker;

public class IntervalVersionChecker
implements VersionChecker {
    @NonNull
    private final GradleVersion mMinVersion;
    @NonNull
    private final GradleVersion mMaxVersion;
    @NonNull
    private final Issue mVersionIssue;
    @NonNull
    private final IntervalVersionIssueMessageComposer mMessageComposer;
    @NonNull
    private final DependencyParser mDependencyParser;
    @NonNull
    private final DependencyMatcher mDependencyMatcher;

    public IntervalVersionChecker(@NonNull String groupId, @NonNull String artifactId, @NonNull String minVersion, @NonNull String maxVersion, @NonNull Issue versionIssue) {
        this.mDependencyMatcher = new DependencyMatcher(groupId, artifactId);
        this.mMinVersion = GradleVersion.parse((String)minVersion);
        this.mMaxVersion = GradleVersion.parse((String)maxVersion);
        this.mVersionIssue = versionIssue;
        this.mMessageComposer = new IntervalVersionIssueMessageComposer(artifactId, minVersion, maxVersion);
        this.mDependencyParser = new DependencyParser();
    }

    @Override
    public void checkDependencyVersion(@NonNull String dependency, @NonNull GradleContext context, @NonNull Object valueCookie) {
        GradleCoordinate gradleDependency;
        if (context.isEnabled(this.mVersionIssue) && (gradleDependency = this.mDependencyParser.parseDependency(dependency)) != null && this.mDependencyMatcher.matches(gradleDependency)) {
            GradleVersion version = gradleDependency.getVersion();
            Location location = context.getLocation(valueCookie);
            if (version.toString().matches(".*[0-9].*")) {
                if (this.mMinVersion.compareTo(version) > 0) {
                    context.report(this.mVersionIssue, location, this.mMessageComposer.getMinVersionErrorMessage());
                } else if (this.mMaxVersion.compareTo(version) <= 0) {
                    context.report(this.mVersionIssue, location, this.mMessageComposer.getMaxVersionErrorMessage());
                }
            }
        }
    }
}

