/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.checker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.yandex.mobileads.lint.base.checker.DependencyMatcher;
import com.yandex.mobileads.lint.base.checker.DependencyParser;
import com.yandex.mobileads.lint.base.checker.MobileAdsVersionOutdatedValidator;
import com.yandex.mobileads.lint.base.checker.OutdatedVersionIssueMessageComposer;
import com.yandex.mobileads.lint.base.checker.VersionChecker;
import com.yandex.mobileads.lint.base.version.ActualVersionProvider;

public class OutdatedVersionChecker
implements VersionChecker {
    @NonNull
    private final Issue mVersionIssue;
    @NonNull
    private final DependencyParser mDependencyParser;
    @NonNull
    private final DependencyMatcher mDependencyMatcher;
    @NonNull
    private final OutdatedVersionIssueMessageComposer mMessageComposer;
    @Nullable
    private final GradleVersion mActualVersion;
    @NonNull
    private final MobileAdsVersionOutdatedValidator mVersionOutdatedValidator;

    public OutdatedVersionChecker(@NonNull String groupId, @NonNull String artifactId, @NonNull ActualVersionProvider actualVersionProvider, @NonNull Issue versionIssue) {
        this.mVersionIssue = versionIssue;
        this.mDependencyMatcher = new DependencyMatcher(groupId, artifactId);
        this.mActualVersion = actualVersionProvider.getActualVersion(groupId, artifactId);
        this.mMessageComposer = new OutdatedVersionIssueMessageComposer(artifactId);
        this.mDependencyParser = new DependencyParser();
        this.mVersionOutdatedValidator = new MobileAdsVersionOutdatedValidator();
    }

    @Override
    public void checkDependencyVersion(@NonNull String dependency, @NonNull GradleContext context, @NonNull Object valueCookie) {
        GradleCoordinate gradleDependency;
        if (context.isEnabled(this.mVersionIssue) && this.mActualVersion != null && (gradleDependency = this.mDependencyParser.parseDependency(dependency)) != null && this.mDependencyMatcher.matches(gradleDependency) && this.mVersionOutdatedValidator.isVersionOutdated(gradleDependency.getVersion(), this.mActualVersion)) {
            Location location = context.getLocation(valueCookie);
            String message = this.mMessageComposer.getOutdatedVersionErrorMessage(this.mActualVersion.toString());
            context.report(this.mVersionIssue, location, message);
        }
    }
}

