/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.issue;

import androidx.annotation.NonNull;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Severity;
import com.yandex.mobileads.lint.base.issue.IssueInfo;

public class OutdatedVersionIssueInfo
implements IssueInfo {
    private static final String ISSUE_DESCRIPTION_PATTERN = "%nThe integrated version of the Yandex Mobile Ads SDK is outdated. Please update %s:%s to the latest version.%nLearn more about the latest version of the SDK here: https://yandex.ru/dev/mobile-ads/doc/android/quick-start/android-ads-component.html%nChangelog: https://yandex.ru/dev/mobile-ads/doc/intro/changelog-android.html%n";
    @NonNull
    private final String mIssueId;
    @NonNull
    private final String mArtifactId;
    @NonNull
    private final String mGroupId;
    @NonNull
    private final Class<? extends Detector> mDetectorClass;

    public OutdatedVersionIssueInfo(@NonNull String issueId, @NonNull String groupId, @NonNull String artifactId, @NonNull Class<? extends Detector> detectorClass) {
        this.mIssueId = issueId;
        this.mArtifactId = artifactId;
        this.mGroupId = groupId;
        this.mDetectorClass = detectorClass;
    }

    @NonNull
    public String getArtifactId() {
        return this.mArtifactId;
    }

    @NonNull
    public String getGroupId() {
        return this.mGroupId;
    }

    @Override
    @NonNull
    public String getIssueId() {
        return this.mIssueId;
    }

    @Override
    @NonNull
    public String getDescription() {
        return String.format(ISSUE_DESCRIPTION_PATTERN, this.mGroupId, this.mArtifactId);
    }

    @Override
    @NonNull
    public Severity getSeverity() {
        return Severity.FATAL;
    }

    @Override
    @NonNull
    public Class<? extends Detector> getDetectorClass() {
        return this.mDetectorClass;
    }
}

