/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.mobileads.lint.base.network.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class HttpClient {
    private static final String GET_METHOD = "GET";
    private static final boolean FOLLOW_REDIRECTS = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Response get(String stringUrl) throws IOException {
        Response response;
        String content = null;
        HttpURLConnection connection = this.getConnection(stringUrl);
        if (connection != null) {
            try {
                connection.setRequestMethod(GET_METHOD);
                connection.setInstanceFollowRedirects(true);
                Reader streamReader = this.getStreamReader(connection);
                content = this.readContent(streamReader);
            }
            catch (IOException iOException) {
            }
            finally {
                connection.disconnect();
            }
            response = new Response(content, connection.getResponseCode());
        } else {
            response = null;
        }
        return response;
    }

    @Nullable
    private HttpURLConnection getConnection(@NonNull String stringUrl) {
        HttpURLConnection connection;
        try {
            URL url = new URL(stringUrl);
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            connection = null;
        }
        return connection;
    }

    @NonNull
    private Reader getStreamReader(@NonNull HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        InputStream inputStream = status != 200 && connection.getErrorStream() != null ? connection.getErrorStream() : connection.getInputStream();
        InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        return streamReader;
    }

    @NonNull
    private String readContent(@NonNull Reader streamReader) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(streamReader);
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(String.format("%s%n", inputLine));
        }
        in.close();
        return content.toString();
    }
}

