/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.checker;

import com.android.ide.common.repository.GradleCoordinate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/yandex/mobileads/lint/base/checker/DependencyMatcher;", "", "groupId", "", "artifactId", "(Ljava/lang/String;Ljava/lang/String;)V", "equals", "", "other", "hashCode", "", "matches", "dependency", "Lcom/android/ide/common/repository/GradleCoordinate;", "Companion", "base-lint"})
public final class DependencyMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("^\\$.+");

    public DependencyMatcher(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public final boolean matches(@Nullable GradleCoordinate dependency) {
        return dependency != null && Intrinsics.areEqual((Object)this.groupId, (Object)dependency.getGroupId()) && Intrinsics.areEqual((Object)this.artifactId, (Object)dependency.getArtifactId()) && !EXPRESSION_PATTERN.matcher(dependency.getVersion().toString()).matches();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DependencyMatcher)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.groupId, (Object)((DependencyMatcher)other).groupId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.artifactId, (Object)((DependencyMatcher)other).artifactId);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/yandex/mobileads/lint/base/checker/DependencyMatcher$Companion;", "", "()V", "EXPRESSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "base-lint"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

