/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.checker;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.yandex.mobileads.lint.base.checker.DependencyMatcher;
import com.yandex.mobileads.lint.base.checker.DependencyParser;
import com.yandex.mobileads.lint.base.checker.IntervalVersionIssueMessageComposer;
import com.yandex.mobileads.lint.base.checker.VersionChecker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/yandex/mobileads/lint/base/checker/IntervalVersionChecker;", "Lcom/yandex/mobileads/lint/base/checker/VersionChecker;", "groupId", "", "artifactId", "rawMinVersion", "rawMaxVersion", "versionIssue", "Lcom/android/tools/lint/detector/api/Issue;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Issue;)V", "dependencyMatcher", "Lcom/yandex/mobileads/lint/base/checker/DependencyMatcher;", "dependencyParser", "Lcom/yandex/mobileads/lint/base/checker/DependencyParser;", "maxVersion", "Lcom/android/ide/common/repository/GradleVersion;", "kotlin.jvm.PlatformType", "messageComposer", "Lcom/yandex/mobileads/lint/base/checker/IntervalVersionIssueMessageComposer;", "minVersion", "checkDependencyVersion", "", "dependency", "context", "Lcom/android/tools/lint/detector/api/GradleContext;", "valueCookie", "", "equals", "", "other", "hashCode", "", "report", "version", "location", "Lcom/android/tools/lint/detector/api/Location;", "base-lint"})
public final class IntervalVersionChecker
implements VersionChecker {
    @NotNull
    private final Issue versionIssue;
    private final GradleVersion minVersion;
    private final GradleVersion maxVersion;
    @NotNull
    private final DependencyParser dependencyParser;
    @NotNull
    private final DependencyMatcher dependencyMatcher;
    @NotNull
    private final IntervalVersionIssueMessageComposer messageComposer;

    public IntervalVersionChecker(@NotNull String groupId, @NotNull String artifactId, @NotNull String rawMinVersion, @NotNull String rawMaxVersion, @NotNull Issue versionIssue) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)rawMinVersion, (String)"rawMinVersion");
        Intrinsics.checkNotNullParameter((Object)rawMaxVersion, (String)"rawMaxVersion");
        Intrinsics.checkNotNullParameter((Object)versionIssue, (String)"versionIssue");
        this.versionIssue = versionIssue;
        this.minVersion = GradleVersion.parse((String)rawMinVersion);
        this.maxVersion = GradleVersion.parse((String)rawMaxVersion);
        this.dependencyParser = new DependencyParser();
        this.dependencyMatcher = new DependencyMatcher(groupId, artifactId);
        this.messageComposer = new IntervalVersionIssueMessageComposer(artifactId, rawMinVersion, rawMaxVersion);
    }

    @Override
    public void checkDependencyVersion(@NotNull String dependency, @NotNull GradleContext context, @NotNull Object valueCookie) {
        GradleCoordinate gradleDependency;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
        if (context.isEnabled(this.versionIssue) && (gradleDependency = this.dependencyParser.parseDependency(dependency)) != null && this.dependencyMatcher.matches(gradleDependency)) {
            GradleVersion version = gradleDependency.getVersion();
            Location location = context.getLocation(valueCookie);
            String string = version.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            CharSequence charSequence = string;
            boolean versionInRightFormat = new Regex(".*[0-9].*").matches(charSequence);
            if (versionInRightFormat) {
                Intrinsics.checkNotNull((Object)version);
                this.report(version, location, context);
            }
        }
    }

    private final void report(GradleVersion version, Location location, GradleContext context) {
        if (this.minVersion.compareTo(version) > 0) {
            context.report(this.versionIssue, location, this.messageComposer.getMinVersionErrorMessage(), null);
        } else if (this.maxVersion.compareTo(version) <= 0) {
            context.report(this.versionIssue, location, this.messageComposer.getMaxVersionErrorMessage(), null);
        }
    }

    public int hashCode() {
        int result = this.versionIssue.hashCode();
        GradleVersion gradleVersion = this.minVersion;
        result = 31 * result + (gradleVersion != null ? gradleVersion.hashCode() : 0);
        GradleVersion gradleVersion2 = this.maxVersion;
        result = 31 * result + (gradleVersion2 != null ? gradleVersion2.hashCode() : 0);
        result = 31 * result + this.dependencyParser.hashCode();
        result = 31 * result + this.dependencyMatcher.hashCode();
        result = 31 * result + this.messageComposer.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntervalVersionChecker)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.versionIssue, (Object)((IntervalVersionChecker)other).versionIssue)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.minVersion, (Object)((IntervalVersionChecker)other).minVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.maxVersion, (Object)((IntervalVersionChecker)other).maxVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dependencyParser, (Object)((IntervalVersionChecker)other).dependencyParser)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dependencyMatcher, (Object)((IntervalVersionChecker)other).dependencyMatcher)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.messageComposer, (Object)((IntervalVersionChecker)other).messageComposer);
    }
}

