/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mobileads.lint.base.checker;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.yandex.mobileads.lint.base.checker.DependencyMatcher;
import com.yandex.mobileads.lint.base.checker.DependencyParser;
import com.yandex.mobileads.lint.base.checker.MobileAdsVersionOutdatedValidator;
import com.yandex.mobileads.lint.base.checker.OutdatedVersionIssueMessageComposer;
import com.yandex.mobileads.lint.base.checker.VersionChecker;
import com.yandex.mobileads.lint.base.version.ActualVersionProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/yandex/mobileads/lint/base/checker/OutdatedVersionChecker;", "Lcom/yandex/mobileads/lint/base/checker/VersionChecker;", "groupId", "", "artifactId", "actualVersionProvider", "Lcom/yandex/mobileads/lint/base/version/ActualVersionProvider;", "versionIssue", "Lcom/android/tools/lint/detector/api/Issue;", "dependencyParser", "Lcom/yandex/mobileads/lint/base/checker/DependencyParser;", "dependencyMatcher", "Lcom/yandex/mobileads/lint/base/checker/DependencyMatcher;", "messageComposer", "Lcom/yandex/mobileads/lint/base/checker/OutdatedVersionIssueMessageComposer;", "actualVersion", "Lcom/android/ide/common/repository/GradleVersion;", "versionOutdatedValidator", "Lcom/yandex/mobileads/lint/base/checker/MobileAdsVersionOutdatedValidator;", "(Ljava/lang/String;Ljava/lang/String;Lcom/yandex/mobileads/lint/base/version/ActualVersionProvider;Lcom/android/tools/lint/detector/api/Issue;Lcom/yandex/mobileads/lint/base/checker/DependencyParser;Lcom/yandex/mobileads/lint/base/checker/DependencyMatcher;Lcom/yandex/mobileads/lint/base/checker/OutdatedVersionIssueMessageComposer;Lcom/android/ide/common/repository/GradleVersion;Lcom/yandex/mobileads/lint/base/checker/MobileAdsVersionOutdatedValidator;)V", "checkDependencyVersion", "", "dependency", "context", "Lcom/android/tools/lint/detector/api/GradleContext;", "valueCookie", "", "base-lint"})
public final class OutdatedVersionChecker
implements VersionChecker {
    @NotNull
    private final Issue versionIssue;
    @NotNull
    private final DependencyParser dependencyParser;
    @NotNull
    private final DependencyMatcher dependencyMatcher;
    @NotNull
    private final OutdatedVersionIssueMessageComposer messageComposer;
    @Nullable
    private final GradleVersion actualVersion;
    @NotNull
    private final MobileAdsVersionOutdatedValidator versionOutdatedValidator;

    public OutdatedVersionChecker(@NotNull String groupId, @NotNull String artifactId, @NotNull ActualVersionProvider actualVersionProvider, @NotNull Issue versionIssue, @NotNull DependencyParser dependencyParser, @NotNull DependencyMatcher dependencyMatcher, @NotNull OutdatedVersionIssueMessageComposer messageComposer, @Nullable GradleVersion actualVersion, @NotNull MobileAdsVersionOutdatedValidator versionOutdatedValidator) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)actualVersionProvider, (String)"actualVersionProvider");
        Intrinsics.checkNotNullParameter((Object)versionIssue, (String)"versionIssue");
        Intrinsics.checkNotNullParameter((Object)dependencyParser, (String)"dependencyParser");
        Intrinsics.checkNotNullParameter((Object)dependencyMatcher, (String)"dependencyMatcher");
        Intrinsics.checkNotNullParameter((Object)messageComposer, (String)"messageComposer");
        Intrinsics.checkNotNullParameter((Object)versionOutdatedValidator, (String)"versionOutdatedValidator");
        this.versionIssue = versionIssue;
        this.dependencyParser = dependencyParser;
        this.dependencyMatcher = dependencyMatcher;
        this.messageComposer = messageComposer;
        this.actualVersion = actualVersion;
        this.versionOutdatedValidator = versionOutdatedValidator;
    }

    public /* synthetic */ OutdatedVersionChecker(String string, String string2, ActualVersionProvider actualVersionProvider, Issue issue, DependencyParser dependencyParser, DependencyMatcher dependencyMatcher, OutdatedVersionIssueMessageComposer outdatedVersionIssueMessageComposer, GradleVersion gradleVersion, MobileAdsVersionOutdatedValidator mobileAdsVersionOutdatedValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            dependencyParser = new DependencyParser();
        }
        if ((n & 0x20) != 0) {
            dependencyMatcher = new DependencyMatcher(string, string2);
        }
        if ((n & 0x40) != 0) {
            outdatedVersionIssueMessageComposer = new OutdatedVersionIssueMessageComposer(string2);
        }
        if ((n & 0x80) != 0) {
            gradleVersion = actualVersionProvider.getActualVersion(string, string2);
        }
        if ((n & 0x100) != 0) {
            mobileAdsVersionOutdatedValidator = new MobileAdsVersionOutdatedValidator();
        }
        this(string, string2, actualVersionProvider, issue, dependencyParser, dependencyMatcher, outdatedVersionIssueMessageComposer, gradleVersion, mobileAdsVersionOutdatedValidator);
    }

    @Override
    public void checkDependencyVersion(@NotNull String dependency, @NotNull GradleContext context, @NotNull Object valueCookie) {
        GradleCoordinate gradleDependency;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
        if (context.isEnabled(this.versionIssue) && this.actualVersion != null && (gradleDependency = this.dependencyParser.parseDependency(dependency)) != null && this.dependencyMatcher.matches(gradleDependency)) {
            GradleVersion gradleVersion = gradleDependency.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"getVersion(...)");
            if (this.versionOutdatedValidator.isVersionOutdated(gradleVersion, this.actualVersion)) {
                Location location = context.getLocation(valueCookie);
                String string = this.actualVersion.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String message = this.messageComposer.getOutdatedVersionErrorMessage(string);
                context.report(this.versionIssue, location, message, null);
            }
        }
    }
}

