/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.metrica;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.yandex.metrica.impl.ob.CD;
import com.yandex.metrica.impl.ob.GD;
import com.yandex.metrica.impl.ob.HD;
import com.yandex.metrica.impl.ob.Xd;

public class ReporterConfig {
    @NonNull
    public final String apiKey;
    @Nullable
    public final Integer sessionTimeout;
    @Nullable
    public final Boolean statisticsSending;
    @Nullable
    public final Integer maxReportsInDatabaseCount;
    @Nullable
    public final String userProfileID;
    @Nullable
    public final Boolean logs;

    ReporterConfig(@NonNull Builder builder) {
        this.apiKey = builder.b;
        this.sessionTimeout = builder.c;
        this.logs = builder.d;
        this.statisticsSending = builder.e;
        this.maxReportsInDatabaseCount = builder.f;
        this.userProfileID = builder.g;
    }

    ReporterConfig(@NonNull ReporterConfig reporterConfig) {
        this.apiKey = reporterConfig.apiKey;
        this.sessionTimeout = reporterConfig.sessionTimeout;
        this.logs = reporterConfig.logs;
        this.statisticsSending = reporterConfig.statisticsSending;
        this.maxReportsInDatabaseCount = reporterConfig.maxReportsInDatabaseCount;
        this.userProfileID = reporterConfig.userProfileID;
    }

    public static Builder createBuilderFromConfig(@NonNull ReporterConfig reporterConfig) {
        ReporterConfig reporterConfig2 = reporterConfig;
        Builder builder = ReporterConfig.newConfigBuilder(reporterConfig2.apiKey);
        if (Xd.a(reporterConfig2.sessionTimeout)) {
            builder.withSessionTimeout(reporterConfig.sessionTimeout);
        }
        if (Xd.a(reporterConfig.logs) && reporterConfig.logs.booleanValue()) {
            builder.withLogs();
        }
        if (Xd.a(reporterConfig.statisticsSending)) {
            builder.withStatisticsSending(reporterConfig.statisticsSending);
        }
        if (Xd.a(reporterConfig.maxReportsInDatabaseCount)) {
            builder.withMaxReportsInDatabaseCount(reporterConfig.maxReportsInDatabaseCount);
        }
        if (Xd.a((Object)reporterConfig.userProfileID)) {
            builder.withUserProfileID(reporterConfig.userProfileID);
        }
        return builder;
    }

    @NonNull
    public static Builder newConfigBuilder(@NonNull String string) {
        return new Builder(string);
    }

    public static class Builder {
        private static final GD<String> a = new CD<String>(new HD());
        private final String b;
        @Nullable
        private Integer c;
        @Nullable
        private Boolean d;
        @Nullable
        private Boolean e;
        @Nullable
        private Integer f;
        @Nullable
        private String g;

        Builder(@NonNull String string) {
            a.a(string);
            this.b = string;
        }

        @NonNull
        public Builder withSessionTimeout(int n2) {
            this.c = n2;
            return this;
        }

        @NonNull
        public Builder withLogs() {
            this.d = true;
            return this;
        }

        @NonNull
        public Builder withStatisticsSending(boolean bl2) {
            this.e = bl2;
            return this;
        }

        @NonNull
        public Builder withMaxReportsInDatabaseCount(int n2) {
            this.f = n2;
            return this;
        }

        @NonNull
        public Builder withUserProfileID(@Nullable String string) {
            this.g = string;
            return this;
        }

        @NonNull
        public ReporterConfig build() {
            return new ReporterConfig(this);
        }
    }
}

