/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.metrica;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.yandex.metrica.PreloadInfo;
import com.yandex.metrica.impl.ob.CD;
import com.yandex.metrica.impl.ob.GD;
import com.yandex.metrica.impl.ob.HD;
import com.yandex.metrica.impl.ob.Lb;
import com.yandex.metrica.impl.ob.Xd;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class YandexMetricaConfig {
    @NonNull
    public final String apiKey;
    @Nullable
    public final String appVersion;
    @Nullable
    public final Integer sessionTimeout;
    @Nullable
    public final Boolean crashReporting;
    @Nullable
    public final Boolean nativeCrashReporting;
    @Nullable
    public final Location location;
    @Nullable
    public final Boolean locationTracking;
    @Nullable
    public final Boolean installedAppCollecting = null;
    @Nullable
    public final Boolean logs;
    @Nullable
    public final PreloadInfo preloadInfo;
    @Nullable
    public final Boolean firstActivationAsUpdate;
    @Nullable
    public final Boolean statisticsSending;
    @Nullable
    public final Integer maxReportsInDatabaseCount;
    @Nullable
    public final Map<String, String> errorEnvironment;
    @Nullable
    public final String userProfileID;

    @NonNull
    public static Builder newConfigBuilder(@NonNull String string) {
        return new Builder(string);
    }

    public static YandexMetricaConfig fromJson(String string) {
        return new Lb().a(string);
    }

    protected YandexMetricaConfig(@NonNull Builder builder) {
        this.apiKey = builder.b;
        this.appVersion = builder.c;
        this.sessionTimeout = builder.d;
        this.crashReporting = builder.e;
        this.nativeCrashReporting = builder.f;
        this.location = builder.g;
        this.locationTracking = builder.h;
        this.logs = builder.i;
        this.preloadInfo = builder.j;
        this.firstActivationAsUpdate = builder.k;
        this.statisticsSending = builder.l;
        this.maxReportsInDatabaseCount = builder.m;
        this.errorEnvironment = Collections.unmodifiableMap(builder.n);
        this.userProfileID = builder.o;
    }

    protected YandexMetricaConfig(@NonNull YandexMetricaConfig yandexMetricaConfig) {
        this.apiKey = yandexMetricaConfig.apiKey;
        this.appVersion = yandexMetricaConfig.appVersion;
        this.sessionTimeout = yandexMetricaConfig.sessionTimeout;
        this.crashReporting = yandexMetricaConfig.crashReporting;
        this.nativeCrashReporting = yandexMetricaConfig.nativeCrashReporting;
        this.location = yandexMetricaConfig.location;
        this.locationTracking = yandexMetricaConfig.locationTracking;
        this.logs = yandexMetricaConfig.logs;
        this.preloadInfo = yandexMetricaConfig.preloadInfo;
        this.firstActivationAsUpdate = yandexMetricaConfig.firstActivationAsUpdate;
        this.statisticsSending = yandexMetricaConfig.statisticsSending;
        this.maxReportsInDatabaseCount = yandexMetricaConfig.maxReportsInDatabaseCount;
        this.errorEnvironment = yandexMetricaConfig.errorEnvironment;
        this.userProfileID = yandexMetricaConfig.userProfileID;
    }

    @NonNull
    public static Builder createBuilderFromConfig(@NonNull YandexMetricaConfig yandexMetricaConfig) {
        YandexMetricaConfig yandexMetricaConfig2 = yandexMetricaConfig;
        Builder builder = YandexMetricaConfig.newConfigBuilder(yandexMetricaConfig2.apiKey);
        if (Xd.a((Object)yandexMetricaConfig2.appVersion)) {
            builder.withAppVersion(yandexMetricaConfig.appVersion);
        }
        if (Xd.a(yandexMetricaConfig.sessionTimeout)) {
            builder.withSessionTimeout(yandexMetricaConfig.sessionTimeout);
        }
        if (Xd.a(yandexMetricaConfig.crashReporting)) {
            builder.withCrashReporting(yandexMetricaConfig.crashReporting);
        }
        if (Xd.a(yandexMetricaConfig.nativeCrashReporting)) {
            builder.withNativeCrashReporting(yandexMetricaConfig.nativeCrashReporting);
        }
        if (Xd.a(yandexMetricaConfig.location)) {
            builder.withLocation(yandexMetricaConfig.location);
        }
        if (Xd.a(yandexMetricaConfig.locationTracking)) {
            builder.withLocationTracking(yandexMetricaConfig.locationTracking);
        }
        if (Xd.a(yandexMetricaConfig.logs) && yandexMetricaConfig.logs.booleanValue()) {
            builder.withLogs();
        }
        if (Xd.a(yandexMetricaConfig.preloadInfo)) {
            builder.withPreloadInfo(yandexMetricaConfig.preloadInfo);
        }
        if (Xd.a(yandexMetricaConfig.firstActivationAsUpdate)) {
            builder.handleFirstActivationAsUpdate(yandexMetricaConfig.firstActivationAsUpdate);
        }
        if (Xd.a(yandexMetricaConfig.statisticsSending)) {
            builder.withStatisticsSending(yandexMetricaConfig.statisticsSending);
        }
        if (Xd.a(yandexMetricaConfig.maxReportsInDatabaseCount)) {
            builder.withMaxReportsInDatabaseCount(yandexMetricaConfig.maxReportsInDatabaseCount);
        }
        if (Xd.a(yandexMetricaConfig.errorEnvironment)) {
            for (Map.Entry<String, String> entry : yandexMetricaConfig.errorEnvironment.entrySet()) {
                builder.withErrorEnvironmentValue(entry.getKey(), entry.getValue());
            }
        }
        if (Xd.a((Object)yandexMetricaConfig.userProfileID)) {
            builder.withUserProfileID(yandexMetricaConfig.userProfileID);
        }
        return builder;
    }

    public String toJson() {
        return new Lb().a(this);
    }

    public static class Builder {
        private static final GD<String> a = new CD<String>(new HD());
        @NonNull
        private final String b;
        @Nullable
        private String c;
        @Nullable
        private Integer d;
        @Nullable
        private Boolean e;
        @Nullable
        private Boolean f;
        @Nullable
        private Location g;
        @Nullable
        private Boolean h;
        @Nullable
        private Boolean i;
        @Nullable
        private PreloadInfo j;
        @Nullable
        private Boolean k;
        @Nullable
        private Boolean l;
        @Nullable
        private Integer m;
        @NonNull
        private LinkedHashMap<String, String> n = new LinkedHashMap();
        @Nullable
        private String o;

        protected Builder(@NonNull String string) {
            a.a(string);
            this.b = string;
        }

        @NonNull
        public Builder withAppVersion(@Nullable String string) {
            this.c = string;
            return this;
        }

        @NonNull
        public Builder withSessionTimeout(int n2) {
            this.d = n2;
            return this;
        }

        @NonNull
        public Builder withCrashReporting(boolean bl2) {
            this.e = bl2;
            return this;
        }

        @NonNull
        public Builder withNativeCrashReporting(boolean bl2) {
            this.f = bl2;
            return this;
        }

        @NonNull
        public Builder withLogs() {
            this.i = true;
            return this;
        }

        @NonNull
        public Builder withLocation(@Nullable Location location) {
            this.g = location;
            return this;
        }

        @NonNull
        public Builder withLocationTracking(boolean bl2) {
            this.h = bl2;
            return this;
        }

        @NonNull
        public Builder withInstalledAppCollecting(boolean bl2) {
            return this;
        }

        @NonNull
        public Builder withPreloadInfo(@Nullable PreloadInfo preloadInfo) {
            this.j = preloadInfo;
            return this;
        }

        @NonNull
        public Builder handleFirstActivationAsUpdate(boolean bl2) {
            this.k = bl2;
            return this;
        }

        @NonNull
        public Builder withStatisticsSending(boolean bl2) {
            this.l = bl2;
            return this;
        }

        @NonNull
        public Builder withMaxReportsInDatabaseCount(int n2) {
            this.m = n2;
            return this;
        }

        @NonNull
        public Builder withErrorEnvironmentValue(@NonNull String string, @Nullable String string2) {
            Builder builder = this;
            builder.n.put(string, string2);
            return builder;
        }

        @NonNull
        public Builder withUserProfileID(@Nullable String string) {
            this.o = string;
            return this;
        }

        @NonNull
        public YandexMetricaConfig build() {
            return new YandexMetricaConfig(this);
        }
    }
}

