/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.metrica;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.metrica.impl.ob.U2;
import com.yandex.metrica.impl.ob.ro;
import com.yandex.metrica.impl.ob.uo;
import com.yandex.metrica.impl.ob.vo;

public class ReporterConfig {
    @NonNull
    public final String apiKey;
    @Nullable
    public final Integer sessionTimeout;
    @Nullable
    public final Boolean statisticsSending;
    @Nullable
    public final Integer maxReportsInDatabaseCount;
    @Nullable
    public final String userProfileID;
    @Nullable
    public final Boolean logs;

    ReporterConfig(@NonNull Builder builder) {
        this.apiKey = builder.a;
        this.sessionTimeout = builder.b;
        this.logs = builder.c;
        this.statisticsSending = builder.d;
        this.maxReportsInDatabaseCount = builder.e;
        this.userProfileID = builder.f;
    }

    ReporterConfig(@NonNull ReporterConfig reporterConfig) {
        this.apiKey = reporterConfig.apiKey;
        this.sessionTimeout = reporterConfig.sessionTimeout;
        this.logs = reporterConfig.logs;
        this.statisticsSending = reporterConfig.statisticsSending;
        this.maxReportsInDatabaseCount = reporterConfig.maxReportsInDatabaseCount;
        this.userProfileID = reporterConfig.userProfileID;
    }

    public static Builder createBuilderFromConfig(@NonNull ReporterConfig reporterConfig) {
        ReporterConfig reporterConfig2 = reporterConfig;
        Builder builder = ReporterConfig.newConfigBuilder(reporterConfig2.apiKey);
        if (U2.a(reporterConfig2.sessionTimeout)) {
            builder.withSessionTimeout(reporterConfig.sessionTimeout);
        }
        if (U2.a(reporterConfig.logs) && reporterConfig.logs.booleanValue()) {
            builder.withLogs();
        }
        if (U2.a(reporterConfig.statisticsSending)) {
            builder.withStatisticsSending(reporterConfig.statisticsSending);
        }
        if (U2.a(reporterConfig.maxReportsInDatabaseCount)) {
            builder.withMaxReportsInDatabaseCount(reporterConfig.maxReportsInDatabaseCount);
        }
        if (U2.a((Object)reporterConfig.userProfileID)) {
            builder.withUserProfileID(reporterConfig.userProfileID);
        }
        return builder;
    }

    @NonNull
    public static Builder newConfigBuilder(@NonNull String string) {
        return new Builder(string);
    }

    public static class Builder {
        private static final uo<String> g;
        private final String a;
        @Nullable
        private Integer b;
        @Nullable
        private Boolean c;
        @Nullable
        private Boolean d;
        @Nullable
        private Integer e;
        @Nullable
        private String f;

        Builder(@NonNull String string) {
            ((ro)g).a(string);
            this.a = string;
        }

        static {
            vo vo2;
            vo vo3 = vo2;
            vo2 = new vo();
            g = new ro<String>(vo3);
        }

        @NonNull
        public Builder withSessionTimeout(int n10) {
            this.b = n10;
            return this;
        }

        @NonNull
        public Builder withLogs() {
            this.c = Boolean.TRUE;
            return this;
        }

        @NonNull
        public Builder withStatisticsSending(boolean bl2) {
            this.d = bl2;
            return this;
        }

        @NonNull
        public Builder withMaxReportsInDatabaseCount(int n10) {
            this.e = n10;
            return this;
        }

        @NonNull
        public Builder withUserProfileID(@Nullable String string) {
            this.f = string;
            return this;
        }

        @NonNull
        public ReporterConfig build() {
            return new ReporterConfig(this);
        }
    }
}

