/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.metrica;

import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.metrica.PreloadInfo;
import com.yandex.metrica.impl.ob.A2;
import com.yandex.metrica.impl.ob.m1;
import com.yandex.metrica.impl.ob.un;
import com.yandex.metrica.impl.ob.xn;
import com.yandex.metrica.impl.ob.yn;
import java.util.LinkedHashMap;
import java.util.Map;

public class YandexMetricaConfig {
    @NonNull
    public final String apiKey;
    @Nullable
    public final String appVersion;
    @Nullable
    public final Integer sessionTimeout;
    @Nullable
    public final Boolean crashReporting;
    @Nullable
    public final Boolean nativeCrashReporting;
    @Nullable
    public final Location location;
    @Nullable
    public final Boolean locationTracking;
    @Nullable
    public final Boolean logs;
    @Nullable
    public final PreloadInfo preloadInfo;
    @Nullable
    public final Boolean firstActivationAsUpdate;
    @Nullable
    public final Boolean statisticsSending;
    @Nullable
    public final Integer maxReportsInDatabaseCount;
    @Nullable
    public final Map<String, String> errorEnvironment;
    @Nullable
    public final String userProfileID;
    @Nullable
    public final Boolean revenueAutoTrackingEnabled;
    @Nullable
    public final Boolean sessionsAutoTrackingEnabled;
    @Nullable
    public final Boolean appOpenTrackingEnabled;

    @NonNull
    public static Builder newConfigBuilder(@NonNull String string) {
        return new Builder(string);
    }

    public static YandexMetricaConfig fromJson(String string) {
        return new m1().a(string);
    }

    protected YandexMetricaConfig(@NonNull Builder builder) {
        this.apiKey = builder.a;
        this.appVersion = builder.b;
        this.sessionTimeout = builder.c;
        this.crashReporting = builder.d;
        this.nativeCrashReporting = builder.e;
        this.location = builder.f;
        this.locationTracking = builder.g;
        this.logs = builder.h;
        this.preloadInfo = builder.i;
        this.firstActivationAsUpdate = builder.j;
        this.statisticsSending = builder.k;
        this.maxReportsInDatabaseCount = builder.l;
        this.errorEnvironment = A2.e(builder.m);
        this.userProfileID = builder.n;
        this.revenueAutoTrackingEnabled = builder.o;
        this.sessionsAutoTrackingEnabled = builder.p;
        this.appOpenTrackingEnabled = builder.q;
    }

    protected YandexMetricaConfig(@NonNull YandexMetricaConfig yandexMetricaConfig) {
        this.apiKey = yandexMetricaConfig.apiKey;
        this.appVersion = yandexMetricaConfig.appVersion;
        this.sessionTimeout = yandexMetricaConfig.sessionTimeout;
        this.crashReporting = yandexMetricaConfig.crashReporting;
        this.nativeCrashReporting = yandexMetricaConfig.nativeCrashReporting;
        this.location = yandexMetricaConfig.location;
        this.locationTracking = yandexMetricaConfig.locationTracking;
        this.logs = yandexMetricaConfig.logs;
        this.preloadInfo = yandexMetricaConfig.preloadInfo;
        this.firstActivationAsUpdate = yandexMetricaConfig.firstActivationAsUpdate;
        this.statisticsSending = yandexMetricaConfig.statisticsSending;
        this.maxReportsInDatabaseCount = yandexMetricaConfig.maxReportsInDatabaseCount;
        this.errorEnvironment = yandexMetricaConfig.errorEnvironment;
        this.userProfileID = yandexMetricaConfig.userProfileID;
        this.revenueAutoTrackingEnabled = yandexMetricaConfig.revenueAutoTrackingEnabled;
        this.sessionsAutoTrackingEnabled = yandexMetricaConfig.sessionsAutoTrackingEnabled;
        this.appOpenTrackingEnabled = yandexMetricaConfig.appOpenTrackingEnabled;
    }

    @NonNull
    public static Builder createBuilderFromConfig(@NonNull YandexMetricaConfig yandexMetricaConfig) {
        YandexMetricaConfig yandexMetricaConfig2 = yandexMetricaConfig;
        Builder builder = YandexMetricaConfig.newConfigBuilder(yandexMetricaConfig2.apiKey);
        if (A2.a((Object)yandexMetricaConfig2.appVersion)) {
            builder.withAppVersion(yandexMetricaConfig.appVersion);
        }
        if (A2.a(yandexMetricaConfig.sessionTimeout)) {
            builder.withSessionTimeout(yandexMetricaConfig.sessionTimeout);
        }
        if (A2.a(yandexMetricaConfig.crashReporting)) {
            builder.withCrashReporting(yandexMetricaConfig.crashReporting);
        }
        if (A2.a(yandexMetricaConfig.nativeCrashReporting)) {
            builder.withNativeCrashReporting(yandexMetricaConfig.nativeCrashReporting);
        }
        if (A2.a(yandexMetricaConfig.location)) {
            builder.withLocation(yandexMetricaConfig.location);
        }
        if (A2.a(yandexMetricaConfig.locationTracking)) {
            builder.withLocationTracking(yandexMetricaConfig.locationTracking);
        }
        if (A2.a(yandexMetricaConfig.logs) && yandexMetricaConfig.logs.booleanValue()) {
            builder.withLogs();
        }
        if (A2.a(yandexMetricaConfig.preloadInfo)) {
            builder.withPreloadInfo(yandexMetricaConfig.preloadInfo);
        }
        if (A2.a(yandexMetricaConfig.firstActivationAsUpdate)) {
            builder.handleFirstActivationAsUpdate(yandexMetricaConfig.firstActivationAsUpdate);
        }
        if (A2.a(yandexMetricaConfig.statisticsSending)) {
            builder.withStatisticsSending(yandexMetricaConfig.statisticsSending);
        }
        if (A2.a(yandexMetricaConfig.maxReportsInDatabaseCount)) {
            builder.withMaxReportsInDatabaseCount(yandexMetricaConfig.maxReportsInDatabaseCount);
        }
        if (A2.a(yandexMetricaConfig.errorEnvironment)) {
            for (Map.Entry<String, String> entry : yandexMetricaConfig.errorEnvironment.entrySet()) {
                builder.withErrorEnvironmentValue(entry.getKey(), entry.getValue());
            }
        }
        if (A2.a((Object)yandexMetricaConfig.userProfileID)) {
            builder.withUserProfileID(yandexMetricaConfig.userProfileID);
        }
        if (A2.a(yandexMetricaConfig.revenueAutoTrackingEnabled)) {
            builder.withRevenueAutoTrackingEnabled(yandexMetricaConfig.revenueAutoTrackingEnabled);
        }
        if (A2.a(yandexMetricaConfig.sessionsAutoTrackingEnabled)) {
            builder.withSessionsAutoTrackingEnabled(yandexMetricaConfig.sessionsAutoTrackingEnabled);
        }
        if (A2.a(yandexMetricaConfig.appOpenTrackingEnabled)) {
            builder.withAppOpenTrackingEnabled(yandexMetricaConfig.appOpenTrackingEnabled);
        }
        return builder;
    }

    public String toJson() {
        return new m1().a(this);
    }

    public static class Builder {
        private static final xn<String> r;
        @NonNull
        private final String a;
        @Nullable
        private String b;
        @Nullable
        private Integer c;
        @Nullable
        private Boolean d;
        @Nullable
        private Boolean e;
        @Nullable
        private Location f;
        @Nullable
        private Boolean g;
        @Nullable
        private Boolean h;
        @Nullable
        private PreloadInfo i;
        @Nullable
        private Boolean j;
        @Nullable
        private Boolean k;
        @Nullable
        private Integer l;
        @NonNull
        private LinkedHashMap<String, String> m = new LinkedHashMap();
        @Nullable
        private String n;
        @Nullable
        private Boolean o;
        @Nullable
        private Boolean p;
        @Nullable
        private Boolean q;

        protected Builder(@NonNull String string) {
            ((un)r).a(string);
            this.a = string;
        }

        static {
            yn yn2;
            yn yn3 = yn2;
            yn2 = new yn();
            r = new un<String>(yn3);
        }

        @NonNull
        public Builder withAppVersion(@Nullable String string) {
            this.b = string;
            return this;
        }

        @NonNull
        public Builder withSessionTimeout(int n10) {
            this.c = n10;
            return this;
        }

        @NonNull
        public Builder withCrashReporting(boolean bl2) {
            this.d = bl2;
            return this;
        }

        @NonNull
        public Builder withNativeCrashReporting(boolean bl2) {
            this.e = bl2;
            return this;
        }

        @NonNull
        public Builder withLogs() {
            this.h = Boolean.TRUE;
            return this;
        }

        @NonNull
        public Builder withLocation(@Nullable Location location) {
            this.f = location;
            return this;
        }

        @NonNull
        public Builder withLocationTracking(boolean bl2) {
            this.g = bl2;
            return this;
        }

        @NonNull
        public Builder withPreloadInfo(@Nullable PreloadInfo preloadInfo) {
            this.i = preloadInfo;
            return this;
        }

        @NonNull
        public Builder handleFirstActivationAsUpdate(boolean bl2) {
            this.j = bl2;
            return this;
        }

        @NonNull
        public Builder withStatisticsSending(boolean bl2) {
            this.k = bl2;
            return this;
        }

        @NonNull
        public Builder withMaxReportsInDatabaseCount(int n10) {
            this.l = n10;
            return this;
        }

        @NonNull
        public Builder withErrorEnvironmentValue(@NonNull String string, @Nullable String string2) {
            Builder builder = this;
            builder.m.put(string, string2);
            return builder;
        }

        @NonNull
        public Builder withUserProfileID(@Nullable String string) {
            this.n = string;
            return this;
        }

        @NonNull
        public Builder withRevenueAutoTrackingEnabled(boolean bl2) {
            this.o = bl2;
            return this;
        }

        @NonNull
        public Builder withSessionsAutoTrackingEnabled(boolean bl2) {
            this.p = bl2;
            return this;
        }

        @NonNull
        public Builder withAppOpenTrackingEnabled(boolean bl2) {
            this.q = bl2;
            return this;
        }

        @NonNull
        public YandexMetricaConfig build() {
            return new YandexMetricaConfig(this);
        }
    }
}

