/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.apikey;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import yandex.cloud.sdk.auth.jwt.Jwt;
import yandex.cloud.sdk.auth.jwt.JwtCreator;
import yandex.cloud.sdk.auth.jwt.ServiceAccountKey;

public class ApiKey {
    private static final Duration EXPIRATION_OFFSET = Duration.ofMinutes(1L);
    private final ServiceAccountKey serviceAccountKey;
    private final JwtCreator jwtCreator;
    private volatile Jwt jwt = null;

    public ApiKey(ServiceAccountKey key) {
        this.serviceAccountKey = key;
        this.jwtCreator = new JwtCreator();
    }

    private ApiKey(ServiceAccountKey key, JwtCreator jwtCreator) {
        this.serviceAccountKey = key;
        this.jwtCreator = jwtCreator;
    }

    public ApiKey withJwtCreator(JwtCreator jwtCreator) {
        return new ApiKey(this.serviceAccountKey, jwtCreator);
    }

    public ServiceAccountKey getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public Jwt getJwt() {
        if (this.jwt == null || Instant.now().plus(EXPIRATION_OFFSET).isAfter(this.jwt.getExpireAt())) {
            this.jwt = this.jwtCreator.generateJwt(this.serviceAccountKey);
        }
        return this.jwt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKey apiKey = (ApiKey)o;
        return Objects.equals(this.serviceAccountKey, apiKey.serviceAccountKey) && Objects.equals(this.jwt, apiKey.jwt);
    }

    public int hashCode() {
        return Objects.hash(this.serviceAccountKey, this.jwt);
    }

    public String toString() {
        return String.format("ApiKey{serviceAccountKey=" + this.serviceAccountKey + ", jwt='%s'" + '}', this.jwt != null ? "***" : "null");
    }
}

