/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.jwt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import yandex.cloud.sdk.auth.jwt.RSAException;

public class SecurityUtils {
    public static final String RSA_ALGORITHM_FAMILY = "RSA";

    private SecurityUtils() {
    }

    public static PrivateKey createRsaPrivateKey(String keyPem) {
        try {
            PemObject pemObject = new PemReader((Reader)new StringReader(keyPem)).readPemObject();
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM_FAMILY);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RSAException(e);
        }
    }

    public static PublicKey createRsaPublicKey(String keyPem) {
        try {
            PemObject pemObject = new PemReader((Reader)new StringReader(keyPem)).readPemObject();
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pemObject.getContent());
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM_FAMILY);
            return keyFactory.generatePublic(keySpec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RSAException(e);
        }
    }
}

