/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.AbstractStub;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import yandex.cloud.api.endpoint.ApiEndpointOuterClass;
import yandex.cloud.api.endpoint.ApiEndpointServiceGrpc;
import yandex.cloud.api.endpoint.ApiEndpointServiceOuterClass;
import yandex.cloud.sdk.ChannelFactoryCreationException;
import yandex.cloud.sdk.ServiceToEndpointMapping;
import yandex.cloud.sdk.StubToServiceMapping;

public class ChannelFactory {
    public static final String DEFAULT_ENDPOINT = "api.cloud.yandex.net:443";
    private final Map<String, String> endpointMap;
    private final Map<String, ManagedChannel> channelCache;

    private ChannelFactory() {
        this(DEFAULT_ENDPOINT);
    }

    public ChannelFactory(String endpoint) {
        this.endpointMap = DEFAULT_ENDPOINT.equals(endpoint) ? ServiceToEndpointMapping.map : this.createEndpointMapping(endpoint);
        this.channelCache = new ConcurrentHashMap<String, ManagedChannel>();
    }

    public static ChannelFactory getDefaultChannelFactory() {
        return new ChannelFactory();
    }

    private Map<String, String> createEndpointMapping(String endpoint) {
        ApiEndpointServiceOuterClass.ListApiEndpointsResponse response;
        ManagedChannel channel = null;
        try {
            channel = NettyChannelBuilder.forTarget((String)endpoint).build();
            ApiEndpointServiceGrpc.ApiEndpointServiceBlockingStub stub = ApiEndpointServiceGrpc.newBlockingStub((Channel)channel);
            response = stub.list(ApiEndpointServiceOuterClass.ListApiEndpointsRequest.newBuilder().build());
        }
        catch (StatusRuntimeException e) {
            throw new ChannelFactoryCreationException("Cannot retrieve endpoint list", e);
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
        return response.getEndpointsList().stream().collect(Collectors.toMap(ApiEndpointOuterClass.ApiEndpoint::getId, ApiEndpointOuterClass.ApiEndpoint::getAddress));
    }

    public ManagedChannel getChannel(Class<? extends AbstractStub> clazz) {
        return this.channelCache.computeIfAbsent(this.resolveEndpoint(clazz), endpoint -> NettyChannelBuilder.forTarget((String)endpoint).build());
    }

    private String resolveEndpoint(Class<? extends AbstractStub> clazz) {
        if (!StubToServiceMapping.map.containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("cannot find service related to class %s", clazz.getSimpleName()));
        }
        String service = StubToServiceMapping.map.get(clazz);
        if (!this.endpointMap.containsKey(service)) {
            throw new IllegalStateException(String.format("cannot find endpoint for service %s", service));
        }
        return this.endpointMap.get(service);
    }
}

