/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk;

import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.AbstractStub;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.function.Function;
import yandex.cloud.sdk.ChannelFactory;
import yandex.cloud.sdk.auth.provider.CredentialProvider;
import yandex.cloud.sdk.grpc.interceptors.DeadlineClientInterceptor;
import yandex.cloud.sdk.grpc.interceptors.RequestIdInterceptor;

public class ServiceFactory {
    private static final Metadata.Key<String> AUTHORIZATION_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final CredentialProvider credentialProvider;
    private final Duration requestTimeout;
    private final ChannelFactory channelFactory;

    private ServiceFactory(CredentialProvider credentialProvider, Duration requestTimeout, ChannelFactory channelFactory) {
        this.credentialProvider = credentialProvider;
        this.requestTimeout = requestTimeout;
        this.channelFactory = channelFactory;
    }

    public static ServiceFactoryBuilder builder() {
        return new ServiceFactoryBuilder();
    }

    public <SERVICE extends AbstractStub<SERVICE>> SERVICE create(Class<SERVICE> clazz, Function<Channel, SERVICE> service) {
        return this.create(clazz, service, null);
    }

    public <SERVICE extends AbstractStub<SERVICE>> SERVICE create(Class<SERVICE> clazz, Function<Channel, SERVICE> service, Duration timeout) {
        ManagedChannel channel = this.channelFactory.getChannel(clazz);
        return this.create(channel, service, timeout);
    }

    public <SERVICE extends AbstractStub<SERVICE>> SERVICE create(ManagedChannel channel, Function<Channel, SERVICE> service) {
        return this.create(channel, service, null);
    }

    public <SERVICE extends AbstractStub<SERVICE>> SERVICE create(ManagedChannel channel, Function<Channel, SERVICE> service, Duration timeout) {
        AbstractStub serviceStub = (AbstractStub)service.apply((Channel)channel);
        serviceStub = serviceStub.withInterceptors(this.createInterceptors(timeout));
        if (this.credentialProvider != null) {
            serviceStub = serviceStub.withCallCredentials(this.createCallCredentials());
        }
        return (SERVICE)serviceStub;
    }

    private CallCredentials createCallCredentials() {
        return new CallCredentials(){

            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier applier) {
                String iamToken;
                try {
                    iamToken = ServiceFactory.this.credentialProvider.get().getToken();
                }
                catch (Exception e) {
                    applier.fail(Status.UNAUTHENTICATED.withDescription(e.getMessage()));
                    return;
                }
                Metadata metadata = new Metadata();
                metadata.put(AUTHORIZATION_KEY, (Object)("Bearer " + iamToken));
                applier.apply(metadata);
            }

            public void thisUsesUnstableApi() {
            }
        };
    }

    private ClientInterceptor[] createInterceptors(Duration timeout) {
        ArrayList<Object> interceptors = new ArrayList<Object>();
        if (timeout != null) {
            interceptors.add(DeadlineClientInterceptor.fromDuration(timeout));
        } else if (this.requestTimeout != null) {
            interceptors.add(DeadlineClientInterceptor.fromDuration(this.requestTimeout));
        }
        interceptors.add(new RequestIdInterceptor());
        return interceptors.toArray(new ClientInterceptor[0]);
    }

    public static class ServiceFactoryBuilder {
        private static final Duration DEFAULT_REQUEST_TIMEOUT = null;
        private CredentialProvider credentialProvider;
        private ChannelFactory channelFactory = new ChannelFactory("api.cloud.yandex.net:443");
        private Duration requestTimeout = DEFAULT_REQUEST_TIMEOUT;

        private ServiceFactoryBuilder() {
        }

        public ServiceFactoryBuilder credentialProvider(CredentialProvider credentialProvider) {
            this.credentialProvider = credentialProvider;
            return this;
        }

        public ServiceFactoryBuilder credentialProvider(CredentialProvider.Builder credentialProviderBuilder) {
            this.credentialProvider = credentialProviderBuilder.build();
            return this;
        }

        public ServiceFactoryBuilder endpoint(String endpoint) {
            this.channelFactory = new ChannelFactory(endpoint);
            return this;
        }

        public ServiceFactoryBuilder channelFactory(ChannelFactory channelFactory) {
            this.channelFactory = channelFactory;
            return this;
        }

        public ServiceFactoryBuilder requestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public ServiceFactory build() {
            return new ServiceFactory(this.credentialProvider, this.requestTimeout, this.channelFactory);
        }

        public String toString() {
            return "ServiceFactoryConfigBuilder{, requestTimeout=" + this.requestTimeout + '}';
        }
    }
}

