/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal;

import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.div.internal.AssertionErrorHandler;
import com.yandex.div.internal.ComparisonFailure;

public class Assert {
    @NonNull
    private static AssertionErrorHandler sAssertionErrorHandler = assertionError -> {
        throw assertionError;
    };
    private static volatile boolean sEnabled = false;

    private Assert() {
    }

    public static boolean isEnabled() {
        return sEnabled;
    }

    public static void setEnabled(boolean enabled) {
        sEnabled = enabled;
    }

    public static void assertTrue(@Nullable String message, boolean condition) {
        if (!condition) {
            Assert.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(null, condition);
    }

    public static void assertFalse(@Nullable String message, boolean condition) {
        Assert.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(null, condition);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void fail(@Nullable String message) {
        if (sEnabled) {
            Assert.performFail(new AssertionError((Object)(message == null ? "" : message)));
        }
    }

    public static void fail(@Nullable String message, @Nullable Throwable cause) {
        if (sEnabled) {
            AssertionError assertionError = new AssertionError((Object)message);
            ((Throwable)((Object)assertionError)).initCause(cause);
            Assert.performFail(assertionError);
        }
    }

    public static void setAssertPerformer(@NonNull AssertionErrorHandler assertionErrorHandler) {
        sAssertionErrorHandler = assertionErrorHandler;
    }

    public static void assertEquals(@Nullable Object expected, @Nullable Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(@Nullable String message, @Nullable Object expected, @Nullable Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        if (expected instanceof String && actual instanceof String) {
            String cleanMessage = message == null ? "" : message;
            Assert.performFail(new ComparisonFailure(cleanMessage, (String)expected, (String)actual));
        } else {
            Assert.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(long expected, long actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(int expected, int actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(@Nullable String message, long expected, long actual) {
        Assert.assertEquals(message, (Object)expected, (Object)actual);
    }

    public static void assertNotNull(@Nullable String message, @Nullable Object object) {
        Assert.assertTrue(message, object != null);
    }

    public static void assertNotNull(@Nullable Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNull(@Nullable String message, @Nullable Object object) {
        Assert.assertTrue(message, object == null);
    }

    public static void assertNull(@Nullable Object object) {
        Assert.assertNull(null, object);
    }

    public static void assertSame(@Nullable String message, @Nullable Object expected, @Nullable Object actual) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(message, expected, actual);
    }

    public static void assertSame(@Nullable Object expected, @Nullable Object actual) {
        Assert.assertSame(null, expected, actual);
    }

    public static void assertNotSame(@Nullable String message, @Nullable Object unexpected, @Nullable Object actual) {
        if (unexpected == actual) {
            Assert.failSame(message);
        }
    }

    public static void assertNotSame(@Nullable Object unexpected, @Nullable Object actual) {
        Assert.assertNotSame(null, unexpected, actual);
    }

    public static void assertMainThread() {
        Assert.assertSame("Code run not in main thread!", Looper.getMainLooper(), Looper.myLooper());
    }

    public static void assertNotMainThread() {
        Assert.assertNotSame("Code run in main thread!", Looper.getMainLooper(), Looper.myLooper());
    }

    private static void failSame(@Nullable String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected not same");
    }

    private static void failNotSame(@Nullable String message, @Nullable Object expected, @Nullable Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    private static void failNotEquals(@Nullable String message, @Nullable Object expected, @Nullable Object actual) {
        Assert.fail(Assert.format(message, expected, actual));
    }

    static String format(@Nullable String message, @Nullable Object expected, @Nullable Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !message.equals("")) {
            formatted = message + " ";
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return formatted + "expected: " + Assert.formatClassAndValue(expected, expectedString) + " but was: " + Assert.formatClassAndValue(actual, actualString);
        }
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(@Nullable Object value, @Nullable String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    private static void performFail(@NonNull AssertionError assertionError) {
        if (!Assert.isEnabled()) {
            return;
        }
        sAssertionErrorHandler.handleError(assertionError);
    }
}

