/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.beacon;

import android.app.Application;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.yandex.android.beacon.BeaconItem;
import com.yandex.android.beacon.SendBeaconDb;
import com.yandex.android.util.SerializationUtils;
import com.yandex.div.internal.Assert;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0010\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0017J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\bH\u0017J\u0016\u0010!\u001a\u0004\u0018\u00010\u0010*\u00020\u00152\u0006\u0010\"\u001a\u00020\u001cH\u0012J\u0016\u0010#\u001a\u0004\u0018\u00010\u0005*\u00020\u00152\u0006\u0010\"\u001a\u00020\u001cH\u0012\u00a8\u0006&"}, d2={"Lcom/yandex/android/beacon/SendBeaconDb;", "Landroid/database/sqlite/SQLiteOpenHelper;", "context", "Landroid/content/Context;", "databaseName", "", "(Landroid/content/Context;Ljava/lang/String;)V", "add", "Lcom/yandex/android/beacon/BeaconItem$Persistent;", "url", "Landroid/net/Uri;", "headers", "", "addTimestamp", "", "payload", "Lorg/json/JSONObject;", "allItems", "", "beaconItemFromCursor", "cursor", "Landroid/database/Cursor;", "onCreate", "", "sqLiteDatabase", "Landroid/database/sqlite/SQLiteDatabase;", "onUpgrade", "oldVersion", "", "newVersion", "remove", "", "item", "getNullableJson", "columnIndex", "getNullableString", "Companion", "Factory", "beacon_release"})
public class SendBeaconDb
extends SQLiteOpenHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int DATABASE_VERSION = 2;
    private static final int DATABASE_INIT_VERSION = 1;
    @NotNull
    private static final String TABLE_ITEMS = "items";
    @NotNull
    private static final String COLUMN_ID = "_id";
    @NotNull
    private static final String COLUMN_URL = "url";
    @NotNull
    private static final String COLUMN_HEADERS = "headers";
    @NotNull
    private static final String COLUMN_ADD_TIMESTAMP = "add_timestamp";
    @NotNull
    private static final String COLUMN_PAYLOAD = "payload";
    @NotNull
    private static final String DATABASE_CREATE = "\n            CREATE TABLE items(\n            _id INTEGER PRIMARY KEY AUTOINCREMENT,\n            url TEXT NOT NULL,\n            headers TEXT,\n            add_timestamp INTEGER, \n            payload TEXT)";
    @NotNull
    private static final String ADD_PAYLOAD_COLUMN_TO_ITEM = "\n            ALTER TABLE items ADD COLUMN payload TEXT;\n        ";
    @NotNull
    private static final String[] QUERY_COLUMNS;
    @NotNull
    private static final String REMOVE_CLAUSE = "_id = ?";
    @JvmField
    @NotNull
    public static Factory factory;

    public SendBeaconDb(@NotNull Context context, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        super(context, databaseName, null, 2);
        Assert.assertTrue((boolean)(context instanceof Application));
    }

    public void onCreate(@NotNull SQLiteDatabase sqLiteDatabase) {
        Intrinsics.checkNotNullParameter((Object)sqLiteDatabase, (String)"sqLiteDatabase");
        sqLiteDatabase.execSQL(DATABASE_CREATE);
    }

    public void onUpgrade(@NotNull SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)sqLiteDatabase, (String)"sqLiteDatabase");
        if (oldVersion == 1) {
            sqLiteDatabase.execSQL(ADD_PAYLOAD_COLUMN_TO_ITEM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public List<BeaconItem.Persistent> allItems() {
        List result = new ArrayList();
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = null;
        try {
            cursor = db.query(TABLE_ITEMS, QUERY_COLUMNS, null, null, null, null, null, null);
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    result.add(this.beaconItemFromCursor(cursor));
                }
            }
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
            db.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public BeaconItem.Persistent add(@NotNull Uri url, @NotNull Map<String, String> headers, long addTimestamp, @Nullable JSONObject payload) {
        long l;
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)url, (String)COLUMN_URL);
        Intrinsics.checkNotNullParameter(headers, (String)COLUMN_HEADERS);
        ContentValues $this$add_u24lambda_u2d0 = contentValues = new ContentValues(3);
        boolean bl = false;
        $this$add_u24lambda_u2d0.put(COLUMN_URL, url.toString());
        $this$add_u24lambda_u2d0.put(COLUMN_HEADERS, SerializationUtils.serialize(headers));
        $this$add_u24lambda_u2d0.put(COLUMN_ADD_TIMESTAMP, Long.valueOf(addTimestamp));
        ContentValues contentValues2 = contentValues;
        SQLiteDatabase database = this.getWritableDatabase();
        Closeable closeable = (Closeable)database;
        Throwable throwable = null;
        try {
            SQLiteDatabase it = (SQLiteDatabase)closeable;
            boolean bl2 = false;
            l = database.insert(TABLE_ITEMS, null, contentValues2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        long rowId = l;
        return new BeaconItem.Persistent(url, headers, payload, addTimestamp, rowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public boolean remove(@Nullable BeaconItem.Persistent item) {
        int n;
        if (item == null) {
            return false;
        }
        SQLiteDatabase database = this.getWritableDatabase();
        Closeable closeable = (Closeable)database;
        Throwable throwable = null;
        try {
            SQLiteDatabase it = (SQLiteDatabase)closeable;
            boolean bl = false;
            String[] stringArray = new String[]{String.valueOf(item.getRowId())};
            n = database.delete(TABLE_ITEMS, REMOVE_CLAUSE, stringArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        int res = n;
        return res != 0;
    }

    private BeaconItem.Persistent beaconItemFromCursor(Cursor cursor) {
        Uri uri = Uri.parse((String)cursor.getString(1));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(cursor.getString(1))");
        return new BeaconItem.Persistent(uri, SerializationUtils.deserializeMap(cursor.getString(2)), this.getNullableJson(cursor, 4), cursor.getLong(3), cursor.getLong(0));
    }

    private String getNullableString(Cursor $this$getNullableString, int columnIndex) {
        return $this$getNullableString.isNull(columnIndex) ? null : $this$getNullableString.getString(columnIndex);
    }

    private JSONObject getNullableJson(Cursor $this$getNullableJson, int columnIndex) {
        JSONObject jSONObject;
        String string = this.getNullableString($this$getNullableJson, columnIndex);
        if (string == null) {
            jSONObject = null;
        } else {
            String it = string;
            boolean bl = false;
            if (((CharSequence)it).length() > 0) {
                JSONObject jSONObject2;
                try {
                    jSONObject2 = new JSONObject(it);
                }
                catch (JSONException e) {
                    Assert.fail((String)Intrinsics.stringPlus((String)"Payload parsing exception: ", (Object)((Object)e)));
                    jSONObject2 = null;
                }
                jSONObject = jSONObject2;
            } else {
                jSONObject = null;
            }
        }
        return jSONObject;
    }

    static {
        String[] stringArray = new String[]{COLUMN_ID, COLUMN_URL, COLUMN_HEADERS, COLUMN_ADD_TIMESTAMP, COLUMN_PAYLOAD};
        QUERY_COLUMNS = stringArray;
        factory = Companion.factory.1.INSTANCE;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/yandex/android/beacon/SendBeaconDb$Factory;", "", "create", "Lcom/yandex/android/beacon/SendBeaconDb;", "context", "Landroid/content/Context;", "databaseName", "", "beacon_release"})
    public static interface Factory {
        @NotNull
        public SendBeaconDb create(@NotNull Context var1, @NotNull String var2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\u00148\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u00a8\u0006\u0016"}, d2={"Lcom/yandex/android/beacon/SendBeaconDb$Companion;", "", "()V", "ADD_PAYLOAD_COLUMN_TO_ITEM", "", "COLUMN_ADD_TIMESTAMP", "COLUMN_HEADERS", "COLUMN_ID", "COLUMN_PAYLOAD", "COLUMN_URL", "DATABASE_CREATE", "DATABASE_INIT_VERSION", "", "DATABASE_VERSION", "QUERY_COLUMNS", "", "[Ljava/lang/String;", "REMOVE_CLAUSE", "TABLE_ITEMS", "factory", "Lcom/yandex/android/beacon/SendBeaconDb$Factory;", "getFactory$beacon_release$annotations", "beacon_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getFactory$beacon_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

