/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.beacon;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.yandex.android.beacon.BeaconItem;
import com.yandex.android.beacon.SendBeaconConfiguration;
import com.yandex.android.beacon.SendBeaconDb;
import com.yandex.android.beacon.SendBeaconPerWorkerLogger;
import com.yandex.android.beacon.SendBeaconRequest;
import com.yandex.android.beacon.SendBeaconRequestExecutor;
import com.yandex.android.beacon.SendBeaconResponse;
import com.yandex.android.beacon.SendBeaconWorker;
import com.yandex.android.beacon.SendBeaconWorkerScheduler;
import com.yandex.android.net.CookieStorage;
import com.yandex.div.internal.Assert;
import com.yandex.div.internal.Log;
import com.yandex.div.internal.util.Clock;
import com.yandex.div.internal.util.SingleThreadExecutor;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 .2\u00020\u0001:\u0005./012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0\"2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\fJ<\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0\"2\u0006\u0010(\u001a\u00020)2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\fJ\u0010\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/yandex/android/beacon/SendBeaconWorkerImpl;", "Lcom/yandex/android/beacon/SendBeaconWorker;", "context", "Landroid/content/Context;", "configuration", "Lcom/yandex/android/beacon/SendBeaconConfiguration;", "(Landroid/content/Context;Lcom/yandex/android/beacon/SendBeaconConfiguration;)V", "extraLogger", "Lcom/yandex/android/beacon/SendBeaconPerWorkerLogger;", "getExtraLogger", "()Lcom/yandex/android/beacon/SendBeaconPerWorkerLogger;", "hasMoreWork", "", "Ljava/lang/Boolean;", "hostCallback", "Lcom/yandex/android/beacon/SendBeaconWorkerScheduler;", "getHostCallback", "()Lcom/yandex/android/beacon/SendBeaconWorkerScheduler;", "implThread", "Lcom/yandex/android/beacon/SendBeaconWorkerImpl$ImplThread;", "requestExecutor", "Lcom/yandex/android/beacon/SendBeaconRequestExecutor;", "getRequestExecutor", "()Lcom/yandex/android/beacon/SendBeaconRequestExecutor;", "runningJob", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/yandex/android/beacon/SendBeaconWorkerImpl$RunningJob;", "workerThreadExecutor", "Lcom/yandex/android/beacon/SendBeaconWorkerImpl$WorkerThreadExecutor;", "add", "", "url", "Landroid/net/Uri;", "headers", "", "", "payload", "Lorg/json/JSONObject;", "tryImmediately", "addNonPersistentUrl", "cookieStorage", "Lcom/yandex/android/net/CookieStorage;", "onStart", "callback", "Lcom/yandex/android/beacon/SendBeaconWorker$Callback;", "onStop", "Companion", "ImplThread", "RunningJob", "WorkerData", "WorkerThreadExecutor", "beacon_release"})
public final class SendBeaconWorkerImpl
implements SendBeaconWorker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final SendBeaconConfiguration configuration;
    @NotNull
    private final WorkerThreadExecutor workerThreadExecutor;
    @NotNull
    private final ImplThread implThread;
    @NotNull
    private final AtomicReference<RunningJob> runningJob;
    @Nullable
    private volatile Boolean hasMoreWork;
    @NotNull
    private static final String TAG = "SendBeaconWorker";
    @JvmField
    public static final long URL_EXPIRE_PERIOD_MS = TimeUnit.DAYS.toMillis(1L);

    public SendBeaconWorkerImpl(@NotNull Context context, @NotNull SendBeaconConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.context = context;
        this.configuration = configuration;
        this.workerThreadExecutor = new WorkerThreadExecutor(this.configuration.getExecutor());
        this.implThread = new ImplThread();
        this.runningJob = new AtomicReference<Object>(null);
        Log.d((String)TAG, (String)"SendBeaconWorker created");
    }

    private final SendBeaconRequestExecutor getRequestExecutor() {
        return this.configuration.getRequestExecutor();
    }

    private final SendBeaconWorkerScheduler getHostCallback() {
        return this.configuration.getWorkerScheduler();
    }

    private final SendBeaconPerWorkerLogger getExtraLogger() {
        return this.configuration.getPerWorkerLogger();
    }

    public final void add(@NotNull Uri url, @NotNull Map<String, String> headers, @Nullable JSONObject payload, boolean tryImmediately) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"Adding url ", (Object)url));
        this.workerThreadExecutor.post(() -> SendBeaconWorkerImpl.add$lambda-0(this, url, headers, payload, tryImmediately));
    }

    public final void addNonPersistentUrl(@NotNull Uri url, @NotNull Map<String, String> headers, @NotNull CookieStorage cookieStorage, @Nullable JSONObject payload, boolean tryImmediately) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)cookieStorage, (String)"cookieStorage");
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"Adding non persistent url ", (Object)url));
        this.workerThreadExecutor.post(() -> SendBeaconWorkerImpl.addNonPersistentUrl$lambda-1(this, url, headers, cookieStorage, payload, tryImmediately));
    }

    @Override
    public boolean onStart(@NotNull SendBeaconWorker.Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Log.d((String)TAG, (String)"Starting job");
        if (Intrinsics.areEqual((Object)this.hasMoreWork, (Object)false)) {
            Log.d((String)TAG, (String)"Starting job, return false");
            return false;
        }
        RunningJob newJob = new RunningJob(callback);
        RunningJob previousJob = this.runningJob.getAndSet(newJob);
        Assert.assertNull((Object)previousJob);
        this.workerThreadExecutor.post(() -> SendBeaconWorkerImpl.onStart$lambda-2(this, newJob));
        Log.d((String)TAG, (String)"Starting job, return true");
        return true;
    }

    @Override
    public boolean onStop() {
        Log.d((String)TAG, (String)"Stopping job");
        this.runningJob.set(null);
        boolean result = !Intrinsics.areEqual((Object)this.hasMoreWork, (Object)false);
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"Stopping job: ", (Object)result));
        return result;
    }

    private static final void add$lambda-0(SendBeaconWorkerImpl this$0, Uri $url, Map $headers, JSONObject $payload, boolean $tryImmediately) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)$headers, (String)"$headers");
        this$0.implThread.addUrl($url, $headers, $payload, $tryImmediately);
    }

    private static final void addNonPersistentUrl$lambda-1(SendBeaconWorkerImpl this$0, Uri $url, Map $headers, CookieStorage $cookieStorage, JSONObject $payload, boolean $tryImmediately) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)$headers, (String)"$headers");
        Intrinsics.checkNotNullParameter((Object)$cookieStorage, (String)"$cookieStorage");
        this$0.implThread.addNonPersistentUrl($url, $headers, $cookieStorage, $payload, $tryImmediately);
    }

    private static final void onStart$lambda-2(SendBeaconWorkerImpl this$0, RunningJob $newJob) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$newJob, (String)"$newJob");
        this$0.implThread.executeJob($newJob);
    }

    public static final /* synthetic */ Context access$getContext$p(SendBeaconWorkerImpl $this) {
        return $this.context;
    }

    public static final /* synthetic */ SendBeaconConfiguration access$getConfiguration$p(SendBeaconWorkerImpl $this) {
        return $this.configuration;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/yandex/android/beacon/SendBeaconWorkerImpl$WorkerThreadExecutor;", "Lcom/yandex/div/internal/util/SingleThreadExecutor;", "executor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "handleError", "", "e", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "beacon_release"})
    private static final class WorkerThreadExecutor
    extends SingleThreadExecutor {
        public WorkerThreadExecutor(@NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            super(executor, "SendBeacon");
        }

        protected void handleError(@NotNull RuntimeException e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/yandex/android/beacon/SendBeaconWorkerImpl$RunningJob;", "", "callback", "Lcom/yandex/android/beacon/SendBeaconWorker$Callback;", "(Lcom/yandex/android/beacon/SendBeaconWorker$Callback;)V", "sendFinishToCallback", "", "backingOff", "", "beacon_release"})
    private static final class RunningJob {
        @NotNull
        private final SendBeaconWorker.Callback callback;

        public RunningJob(@NotNull SendBeaconWorker.Callback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.callback = callback;
        }

        public final void sendFinishToCallback(boolean backingOff) {
            this.callback.finish(backingOff);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0003\u001a\u00060\u0004R\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J<\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\rJ4\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u000bH\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001f\u0010\u0003\u001a\u00060\u0004R\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lcom/yandex/android/beacon/SendBeaconWorkerImpl$ImplThread;", "", "(Lcom/yandex/android/beacon/SendBeaconWorkerImpl;)V", "workerData", "Lcom/yandex/android/beacon/SendBeaconWorkerImpl$WorkerData;", "Lcom/yandex/android/beacon/SendBeaconWorkerImpl;", "getWorkerData", "()Lcom/yandex/android/beacon/SendBeaconWorkerImpl$WorkerData;", "workerData$delegate", "Lkotlin/Lazy;", "addBeaconItem", "", "tryImmediately", "", "beaconData", "Lcom/yandex/android/beacon/BeaconItem;", "addNonPersistentUrl", "url", "Landroid/net/Uri;", "headers", "", "", "cookieStorage", "Lcom/yandex/android/net/CookieStorage;", "payload", "Lorg/json/JSONObject;", "addUrl", "executeJob", "job", "Lcom/yandex/android/beacon/SendBeaconWorkerImpl$RunningJob;", "is5xxHttpCode", "response", "Lcom/yandex/android/beacon/SendBeaconResponse;", "proceedJobImpl", "sendItem", "beacon_release"})
    @WorkerThread
    private final class ImplThread {
        @NotNull
        private final Lazy workerData$delegate;

        public ImplThread() {
            Intrinsics.checkNotNullParameter((Object)SendBeaconWorkerImpl.this, (String)"this$0");
            this.workerData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WorkerData>(SendBeaconWorkerImpl.this){
                final /* synthetic */ SendBeaconWorkerImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final WorkerData invoke() {
                    return this.this$0.new WorkerData(SendBeaconWorkerImpl.access$getContext$p(this.this$0), SendBeaconWorkerImpl.access$getConfiguration$p(this.this$0).getDatabaseName());
                }
            }));
        }

        private final WorkerData getWorkerData() {
            Lazy lazy = this.workerData$delegate;
            return (WorkerData)lazy.getValue();
        }

        public final void addUrl(@NotNull Uri url, @NotNull Map<String, String> headers, @Nullable JSONObject payload, boolean tryImmediately) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            long nowMs = Clock.get().getCurrentTimeMs();
            BeaconItem beaconData = this.getWorkerData().push(url, headers, nowMs, payload);
            this.addBeaconItem(tryImmediately, this.getWorkerData(), beaconData);
        }

        public final void addNonPersistentUrl(@NotNull Uri url, @NotNull Map<String, String> headers, @NotNull CookieStorage cookieStorage, @Nullable JSONObject payload, boolean tryImmediately) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)cookieStorage, (String)"cookieStorage");
            long nowMs = Clock.get().getCurrentTimeMs();
            BeaconItem beaconData = this.getWorkerData().pushNonPersistent(url, headers, nowMs, cookieStorage, payload);
            this.addBeaconItem(tryImmediately, this.getWorkerData(), beaconData);
        }

        private final void addBeaconItem(boolean tryImmediately, WorkerData workerData2, BeaconItem beaconData) {
            boolean sendResult;
            if (tryImmediately && (sendResult = this.sendItem(beaconData))) {
                workerData2.pop();
                return;
            }
            RunningJob job = (RunningJob)SendBeaconWorkerImpl.this.runningJob.get();
            if (job == null) {
                SendBeaconWorkerImpl.this.getHostCallback().schedule(SendBeaconWorkerImpl.this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void executeJob(@NotNull RunningJob job) {
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            try {
                this.proceedJobImpl();
            }
            finally {
                boolean changed = SendBeaconWorkerImpl.this.runningJob.compareAndSet(job, null);
                if (changed) {
                    boolean backingOff = false;
                    if (Intrinsics.areEqual((Object)SendBeaconWorkerImpl.this.hasMoreWork, (Object)false)) {
                        Log.d((String)SendBeaconWorkerImpl.TAG, (String)"Finishing job");
                        backingOff = false;
                    } else {
                        Log.d((String)SendBeaconWorkerImpl.TAG, (String)"Giving up in the end");
                        backingOff = true;
                    }
                    job.sendFinishToCallback(backingOff);
                }
            }
        }

        private final void proceedJobImpl() {
            long nowMs = Clock.get().getCurrentTimeMs();
            Iterator<BeaconItem> it = this.getWorkerData().iterator();
            while (it.hasNext()) {
                BeaconItem item = it.next();
                if (SendBeaconWorkerImpl.this.runningJob.get() == null) {
                    return;
                }
                if (item.getAddTimestamp() + URL_EXPIRE_PERIOD_MS < nowMs) {
                    Log.w((String)SendBeaconWorkerImpl.TAG, (String)Intrinsics.stringPlus((String)"Drop outdated url: ", (Object)item.getUrl()));
                    it.remove();
                    continue;
                }
                Log.d((String)SendBeaconWorkerImpl.TAG, (String)Intrinsics.stringPlus((String)"Trying to send ", (Object)item.getUrl()));
                boolean sendResult = this.sendItem(item);
                Log.d((String)SendBeaconWorkerImpl.TAG, (String)Intrinsics.stringPlus((String)"Trying to send, result ", (Object)sendResult));
                if (!sendResult) continue;
                it.remove();
            }
        }

        private final boolean sendItem(BeaconItem beaconData) {
            boolean bl;
            SendBeaconRequest request = SendBeaconRequest.Companion.from(beaconData);
            Uri url = beaconData.getUrl();
            String string = request.getUrl().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url.toString()");
            String s = string;
            SendBeaconWorkerImpl.this.getExtraLogger().onTrySendUrl(s);
            try {
                boolean bl2;
                SendBeaconResponse response = SendBeaconWorkerImpl.this.getRequestExecutor().execute(request);
                if (response.isValid()) {
                    SendBeaconWorkerImpl.this.getExtraLogger().onSuccessSendUrl(s);
                    Log.d((String)SendBeaconWorkerImpl.TAG, (String)Intrinsics.stringPlus((String)"Sent url ok ", (Object)url));
                    bl2 = true;
                } else if (this.is5xxHttpCode(response)) {
                    SendBeaconWorkerImpl.this.getExtraLogger().onFailedSendUrlDueServerError(s);
                    Log.e((String)SendBeaconWorkerImpl.TAG, (String)("Failed to send url " + url + ", but treat as sent."));
                    bl2 = true;
                } else {
                    SendBeaconWorkerImpl.this.getExtraLogger().onFailedSendUrl(s, false);
                    Log.e((String)SendBeaconWorkerImpl.TAG, (String)Intrinsics.stringPlus((String)"Failed to send url ", (Object)url));
                    bl2 = false;
                }
                bl = bl2;
            }
            catch (IOException e) {
                SendBeaconWorkerImpl.this.getExtraLogger().onFailedSendUrl(s, true);
                Log.e((String)SendBeaconWorkerImpl.TAG, (String)Intrinsics.stringPlus((String)"Failed to send url ", (Object)url), (Throwable)e);
                bl = false;
            }
            return bl;
        }

        private final boolean is5xxHttpCode(SendBeaconResponse response) {
            return response.getResponseCode() / 100 == 5;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0083\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0096\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ4\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J<\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\b\u0010\u001c\u001a\u00020\u000fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/yandex/android/beacon/SendBeaconWorkerImpl$WorkerData;", "", "Lcom/yandex/android/beacon/BeaconItem;", "context", "Landroid/content/Context;", "databaseName", "", "(Lcom/yandex/android/beacon/SendBeaconWorkerImpl;Landroid/content/Context;Ljava/lang/String;)V", "db", "Lcom/yandex/android/beacon/SendBeaconDb;", "itemCache", "Ljava/util/Deque;", "iterator", "", "pop", "", "push", "url", "Landroid/net/Uri;", "headers", "", "nowMs", "", "payload", "Lorg/json/JSONObject;", "pushNonPersistent", "cookieStorage", "Lcom/yandex/android/net/CookieStorage;", "updateHasMoreWork", "beacon_release"})
    @WorkerThread
    private final class WorkerData
    implements Iterable<BeaconItem>,
    KMappedMarker {
        @NotNull
        private final SendBeaconDb db;
        @NotNull
        private final Deque<BeaconItem> itemCache;

        public WorkerData(@NotNull Context context, String databaseName) {
            Intrinsics.checkNotNullParameter((Object)SendBeaconWorkerImpl.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
            this.db = SendBeaconDb.factory.create(context, databaseName);
            this.itemCache = new ArrayDeque(this.db.allItems());
            Log.e((String)SendBeaconWorkerImpl.TAG, (String)Intrinsics.stringPlus((String)"Reading from database, items count: ", (Object)this.itemCache.size()));
            this.updateHasMoreWork();
        }

        @NotNull
        public final BeaconItem push(@NotNull Uri url, @NotNull Map<String, String> headers, long nowMs, @Nullable JSONObject payload) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            BeaconItem.Persistent item = this.db.add(url, headers, nowMs, payload);
            this.itemCache.push(item);
            this.updateHasMoreWork();
            return item;
        }

        @NotNull
        public final BeaconItem pushNonPersistent(@NotNull Uri url, @NotNull Map<String, String> headers, long nowMs, @NotNull CookieStorage cookieStorage, @Nullable JSONObject payload) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)cookieStorage, (String)"cookieStorage");
            BeaconItem.NonPersistent item = new BeaconItem.NonPersistent(url, headers, payload, nowMs, cookieStorage);
            this.itemCache.push(item);
            this.updateHasMoreWork();
            return item;
        }

        public final void pop() {
            BeaconItem item = this.itemCache.pop();
            this.db.remove(item.asPersistent());
            this.updateHasMoreWork();
        }

        @Override
        @NotNull
        public Iterator<BeaconItem> iterator() {
            Iterator<BeaconItem> iterator2 = this.itemCache.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"itemCache.iterator()");
            Iterator<BeaconItem> it = iterator2;
            return new Iterator<BeaconItem>(it, this){
                @Nullable
                private BeaconItem last;
                final /* synthetic */ Iterator<BeaconItem> $it;
                final /* synthetic */ WorkerData this$0;
                {
                    this.$it = $it;
                    this.this$0 = $receiver;
                }

                @Nullable
                public final BeaconItem getLast() {
                    return this.last;
                }

                public final void setLast(@Nullable BeaconItem beaconItem) {
                    this.last = beaconItem;
                }

                public boolean hasNext() {
                    return this.$it.hasNext();
                }

                @NotNull
                public BeaconItem next() {
                    BeaconItem item;
                    this.last = item = this.$it.next();
                    Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                    return item;
                }

                public void remove() {
                    this.$it.remove();
                    BeaconItem beaconItem = this.last;
                    WorkerData.access$getDb$p(this.this$0).remove((BeaconItem.Persistent)(beaconItem == null ? null : beaconItem.asPersistent()));
                    WorkerData.access$updateHasMoreWork(this.this$0);
                }
            };
        }

        private final void updateHasMoreWork() {
            SendBeaconWorkerImpl.this.hasMoreWork = !this.itemCache.isEmpty();
        }

        public static final /* synthetic */ SendBeaconDb access$getDb$p(WorkerData $this) {
            return $this.db;
        }

        public static final /* synthetic */ void access$updateHasMoreWork(WorkerData $this) {
            $this.updateHasMoreWork();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\b"}, d2={"Lcom/yandex/android/beacon/SendBeaconWorkerImpl$Companion;", "", "()V", "TAG", "", "URL_EXPIRE_PERIOD_MS", "", "getURL_EXPIRE_PERIOD_MS$beacon_release$annotations", "beacon_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getURL_EXPIRE_PERIOD_MS$beacon_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

