/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.evaluable.function;

import com.yandex.div.evaluable.EvaluableExceptionKt;
import com.yandex.div.evaluable.EvaluableType;
import com.yandex.div.evaluable.Function;
import com.yandex.div.evaluable.FunctionArgument;
import com.yandex.div.evaluable.function.ColorComponentGetter;
import com.yandex.div.evaluable.types.Color;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/yandex/div/evaluable/function/ColorStringComponentGetter;", "Lcom/yandex/div/evaluable/Function;", "componentGetter", "Lcom/yandex/div/evaluable/function/ColorComponentGetter;", "(Lcom/yandex/div/evaluable/function/ColorComponentGetter;)V", "declaredArgs", "", "Lcom/yandex/div/evaluable/FunctionArgument;", "getDeclaredArgs", "()Ljava/util/List;", "isPure", "", "()Z", "resultType", "Lcom/yandex/div/evaluable/EvaluableType;", "getResultType", "()Lcom/yandex/div/evaluable/EvaluableType;", "evaluate", "", "args", "onWarning", "Lkotlin/Function1;", "", "", "div-evaluable"})
public abstract class ColorStringComponentGetter
extends Function {
    @NotNull
    private final ColorComponentGetter componentGetter;
    @NotNull
    private final List<FunctionArgument> declaredArgs;
    @NotNull
    private final EvaluableType resultType;
    private final boolean isPure;

    public ColorStringComponentGetter(@NotNull ColorComponentGetter componentGetter) {
        Intrinsics.checkNotNullParameter((Object)componentGetter, (String)"componentGetter");
        super(null, null, 3, null);
        this.componentGetter = componentGetter;
        this.declaredArgs = CollectionsKt.listOf((Object)new FunctionArgument(EvaluableType.STRING, false, 2, null));
        this.resultType = EvaluableType.NUMBER;
        this.isPure = true;
    }

    @Override
    @NotNull
    public List<FunctionArgument> getDeclaredArgs() {
        return this.declaredArgs;
    }

    @Override
    @NotNull
    public EvaluableType getResultType() {
        return this.resultType;
    }

    @Override
    public boolean isPure() {
        return this.isPure;
    }

    @Override
    @NotNull
    protected Object evaluate(@NotNull List<? extends Object> args, @NotNull Function1<? super String, Unit> onWarning) {
        int n;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        String colorString = (String)CollectionsKt.first(args);
        try {
            n = Color.Companion.parse-C4zCDoM(colorString);
        }
        catch (IllegalArgumentException e) {
            EvaluableExceptionKt.throwExceptionOnFunctionEvaluationFailed(this.getName(), args, "Unable to convert value to Color, expected format #AARRGGBB.", e);
            throw new KotlinNothingValueException();
        }
        int color = n;
        return this.componentGetter.invoke(CollectionsKt.listOf((Object)Color.box-impl(color)), onWarning);
    }
}

