/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.evaluable.internal;

import com.yandex.div.evaluable.EvaluableException;
import com.yandex.div.evaluable.TokenizingException;
import com.yandex.div.evaluable.internal.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u00013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J \u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002J\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002J\u001e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002J,\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ(\u0010 \u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\b\b\u0002\u0010!\u001a\u00020\u000eH\u0002J#\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010%J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010'\u001a\u00020\u0007J\f\u0010(\u001a\u00020\u000e*\u00020\u0004H\u0002J\f\u0010)\u001a\u00020\u000e*\u00020\u0004H\u0002J\f\u0010*\u001a\u00020\u000e*\u00020\u0004H\u0002J\u0014\u0010+\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010,\u001a\u00020\u000e*\u00020\u00042\b\b\u0002\u0010-\u001a\u00020\u00042\b\b\u0002\u0010.\u001a\u00020\u0004H\u0002J\f\u0010/\u001a\u00020\u000e*\u00020\u0004H\u0002J\u0014\u00100\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u00101\u001a\u00020\u000e*\u00020\u0004H\u0002J\f\u00102\u001a\u00020\u000e*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00064"}, d2={"Lcom/yandex/div/evaluable/internal/Tokenizer;", "", "()V", "EMPTY_CHAR", "", "ESCAPE_LITERALS", "", "", "[Ljava/lang/String;", "invalidToken", "Lcom/yandex/div/evaluable/EvaluableException;", "state", "Lcom/yandex/div/evaluable/internal/Tokenizer$TokenizationState;", "isAtEndOfString", "", "isLiteral", "isOperator", "tokens", "", "Lcom/yandex/div/evaluable/internal/Token;", "isUnaryOperator", "processExpression", "", "processIdentifier", "", "processKeyword", "identifier", "processNumber", "processString", "Lcom/yandex/div/evaluable/internal/Token$Operand$Literal$Str;", "processString-wB-4SYI", "(Lcom/yandex/div/evaluable/internal/Tokenizer$TokenizationState;Z)Ljava/lang/String;", "processStringTemplate", "isPartOfExpression", "replaceEscapingLiterals", "string", "escapingLiterals", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "tokenize", "input", "isAlphabetic", "isAtEnd", "isAtEndOfExpression", "isAtEndOfStringLiteral", "isDecimal", "previousChar", "nextChar", "isNumber", "isStartOfExpression", "isValidIdentifier", "isWhiteSpace", "TokenizationState", "div-evaluable"})
public final class Tokenizer {
    @NotNull
    public static final Tokenizer INSTANCE = new Tokenizer();
    private static final char EMPTY_CHAR = '\u0000';
    @NotNull
    private static final String[] ESCAPE_LITERALS;

    private Tokenizer() {
    }

    @NotNull
    public final List<Token> tokenize(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        TokenizationState state = new TokenizationState(input);
        try {
            this.processStringTemplate(state, state.getTokens(), false);
        }
        catch (EvaluableException exception) {
            if (exception instanceof TokenizingException) {
                throw new EvaluableException("Error tokenizing '" + input + "'.", exception);
            }
            throw exception;
        }
        return state.getTokens();
    }

    private final void processStringTemplate(TokenizationState state, List<Token> tokens, boolean isPartOfExpression) {
        if (isPartOfExpression) {
            TokenizationState.forward$default(state, 0, 1, null);
        }
        List stringTemplateTokens = new ArrayList();
        String stringLiteral = this.processString-wB-4SYI(state, isPartOfExpression);
        if (this.isAtEnd(state.currentChar())) {
            if (isPartOfExpression) {
                throw new TokenizingException(Intrinsics.stringPlus((String)"''' expected at end of string literal at ", (Object)state.getIndex()), null, 2, null);
            }
            String string = stringLiteral;
            if (string != null) {
                String it = string;
                boolean bl = false;
                tokens.add(Token.Operand.Literal.Str.box-impl(it));
            }
            return;
        }
        if (this.isAtEndOfStringLiteral(state.currentChar(), state)) {
            String string = stringLiteral;
            if (string == null) {
                string = Token.Operand.Literal.Str.constructor-impl("");
            }
            tokens.add(Token.Operand.Literal.Str.box-impl(string));
            TokenizationState.forward$default(state, 0, 1, null);
            return;
        }
        if (stringLiteral != null && this.isStartOfExpression(state.currentChar(), state)) {
            stringTemplateTokens.add(Token.StringTemplate.Start.INSTANCE);
            stringTemplateTokens.add(Token.Operand.Literal.Str.box-impl(stringLiteral));
        }
        while (this.isStartOfExpression(state.currentChar(), state)) {
            String it;
            boolean isSpecialCaseWithExpressionInStringTemplate;
            List expressionTokens = new ArrayList();
            this.processExpression(state, expressionTokens);
            String stringAfterExpression = Tokenizer.processString-wB-4SYI$default(this, state, false, 2, null);
            boolean bl = isSpecialCaseWithExpressionInStringTemplate = !isPartOfExpression && stringTemplateTokens.isEmpty() && stringAfterExpression == null && !this.isStartOfExpression(state.currentChar(), state);
            if (isSpecialCaseWithExpressionInStringTemplate) {
                tokens.addAll(expressionTokens);
                return;
            }
            if (stringTemplateTokens.isEmpty()) {
                stringTemplateTokens.add(Token.StringTemplate.Start.INSTANCE);
            }
            stringTemplateTokens.add(Token.StringTemplate.StartOfExpression.INSTANCE);
            stringTemplateTokens.addAll(expressionTokens);
            stringTemplateTokens.add(Token.StringTemplate.EndOfExpression.INSTANCE);
            if (stringAfterExpression == null) continue;
            boolean bl2 = false;
            stringTemplateTokens.add(Token.Operand.Literal.Str.box-impl(it));
        }
        if (isPartOfExpression && !this.isAtEndOfStringLiteral(state.currentChar(), state)) {
            throw new TokenizingException(Intrinsics.stringPlus((String)"''' expected at end of string literal at ", (Object)state.getIndex()), null, 2, null);
        }
        if (!((Collection)stringTemplateTokens).isEmpty()) {
            tokens.addAll(stringTemplateTokens);
            tokens.add(Token.StringTemplate.End.INSTANCE);
        }
        if (isPartOfExpression) {
            TokenizationState.forward$default(state, 0, 1, null);
        }
    }

    static /* synthetic */ void processStringTemplate$default(Tokenizer tokenizer, TokenizationState tokenizationState, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        tokenizer.processStringTemplate(tokenizationState, list, bl);
    }

    private final String processString-wB-4SYI(TokenizationState state, boolean isLiteral) {
        String string;
        int start = state.getIndex();
        while (!this.isAtEndOfString(state, isLiteral)) {
            TokenizationState.forward$default(state, 0, 1, null);
        }
        String string2 = Tokenizer.replaceEscapingLiterals$default(this, state.part(start, state.getIndex()), null, 2, null);
        if (((CharSequence)string2).length() > 0) {
            string = Token.Operand.Literal.Str.constructor-impl(string2);
        } else {
            string = null;
        }
        return string;
    }

    static /* synthetic */ String processString-wB-4SYI$default(Tokenizer tokenizer, TokenizationState tokenizationState, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return tokenizer.processString-wB-4SYI(tokenizationState, bl);
    }

    @NotNull
    public final String replaceEscapingLiterals(@NotNull String string, @NotNull String[] escapingLiterals) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)escapingLiterals, (String)"escapingLiterals");
        StringBuilder literalBuilder = new StringBuilder();
        int index = 0;
        while (index < string.length()) {
            if (string.charAt(index) == '\\') {
                CharSequence charSequence2;
                int startIndexOfBackslash = index;
                while (index < string.length() && string.charAt(index) == '\\') {
                    int n = index;
                    index = n + 1;
                }
                int countOfBackslashes = index - startIndexOfBackslash;
                int n = countOfBackslashes / 2;
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int it = n3 = n2++;
                    boolean charSequence2 = false;
                    literalBuilder.append('\\');
                }
                boolean remainsEscapingBackslash = countOfBackslashes % 2 == 1;
                if (!remainsEscapingBackslash) continue;
                if (index == string.length() || string.charAt(index) == ' ') {
                    throw new TokenizingException(Intrinsics.stringPlus((String)"Alone backslash at ", (Object)(index - 1)), null, 2, null);
                }
                Set escapingLiteralsSet = ArraysKt.toMutableSet((Object[])escapingLiterals);
                String literalToReplace = null;
                int literalIndex = 0;
                while (((charSequence2 = (CharSequence)literalToReplace) == null || charSequence2.length() == 0) && !((Collection)escapingLiteralsSet).isEmpty() && index < string.length()) {
                    Iterator escapingLiteralsIterator = escapingLiteralsSet.iterator();
                    while (escapingLiteralsIterator.hasNext() && index < string.length()) {
                        String literal = (String)escapingLiteralsIterator.next();
                        if (literal.charAt(literalIndex) != string.charAt(index)) {
                            escapingLiteralsIterator.remove();
                            continue;
                        }
                        if (literalIndex != StringsKt.getLastIndex((CharSequence)literal)) continue;
                        literalToReplace = literal;
                        break;
                    }
                    int n4 = literalIndex;
                    literalIndex = n4 + 1;
                    n4 = index;
                    index = n4 + 1;
                }
                CharSequence charSequence3 = literalToReplace;
                if (charSequence3 == null || charSequence3.length() == 0) {
                    throw new EvaluableException("Incorrect string escape", null, 2, null);
                }
                literalBuilder.append(literalToReplace);
                continue;
            }
            int n = index;
            index = n + 1;
            literalBuilder.append(string.charAt(n));
        }
        String string2 = literalBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"literalBuilder.toString()");
        return string2;
    }

    public static /* synthetic */ String replaceEscapingLiterals$default(Tokenizer tokenizer, String string, String[] stringArray, int n, Object object) {
        if ((n & 2) != 0) {
            stringArray = ESCAPE_LITERALS;
        }
        return tokenizer.replaceEscapingLiterals(string, stringArray);
    }

    private final boolean isAtEndOfString(TokenizationState state, boolean isLiteral) {
        return this.isAtEnd(state.currentChar()) || this.isStartOfExpression(state.currentChar(), state) || isLiteral && this.isAtEndOfStringLiteral(state.currentChar(), state);
    }

    private final boolean processExpression(TokenizationState state, List<Token> tokens) {
        if (!this.isStartOfExpression(state.currentChar(), state)) {
            return false;
        }
        state.forward(2);
        while (!this.isAtEnd(state.currentChar()) && state.currentChar() != '}') {
            Token.Operator token;
            char c = state.currentChar();
            if (c == '?') {
                tokens.add(Token.Operator.TernaryIf.INSTANCE);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == ':') {
                tokens.add(Token.Operator.TernaryElse.INSTANCE);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == '+') {
                Token.Operator operator;
                if (this.isUnaryOperator(tokens)) {
                    operator = Token.Operator.Unary.Plus.INSTANCE;
                } else if (this.isOperator(tokens)) {
                    operator = Token.Operator.Binary.Sum.Plus.INSTANCE;
                } else {
                    throw this.invalidToken(state);
                }
                token = operator;
                tokens.add(token);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == '-') {
                Token.Operator operator;
                if (this.isUnaryOperator(tokens)) {
                    operator = Token.Operator.Unary.Minus.INSTANCE;
                } else if (this.isOperator(tokens)) {
                    operator = Token.Operator.Binary.Sum.Minus.INSTANCE;
                } else {
                    throw this.invalidToken(state);
                }
                token = operator;
                tokens.add(token);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == '*') {
                tokens.add(Token.Operator.Binary.Factor.Multiplication.INSTANCE);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == '/') {
                tokens.add(Token.Operator.Binary.Factor.Division.INSTANCE);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == '%') {
                tokens.add(Token.Operator.Binary.Factor.Modulo.INSTANCE);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == '!') {
                if (TokenizationState.nextChar$default(state, 0, 1, null) == '=') {
                    tokens.add(Token.Operator.Binary.Equality.NotEqual.INSTANCE);
                    state.forward(2);
                    continue;
                }
                if (this.isUnaryOperator(tokens)) {
                    tokens.add(Token.Operator.Unary.Not.INSTANCE);
                    TokenizationState.forward$default(state, 0, 1, null);
                    continue;
                }
                throw this.invalidToken(state);
            }
            if (c == '&') {
                if (TokenizationState.nextChar$default(state, 0, 1, null) == '&') {
                    tokens.add(Token.Operator.Binary.Logical.And.INSTANCE);
                    state.forward(2);
                    continue;
                }
                throw this.invalidToken(state);
            }
            if (c == '|') {
                if (TokenizationState.nextChar$default(state, 0, 1, null) == '|') {
                    tokens.add(Token.Operator.Binary.Logical.Or.INSTANCE);
                    state.forward(2);
                    continue;
                }
                throw this.invalidToken(state);
            }
            if (c == '<') {
                if (TokenizationState.nextChar$default(state, 0, 1, null) == '=') {
                    tokens.add(Token.Operator.Binary.Comparison.LessOrEqual.INSTANCE);
                    state.forward(2);
                    continue;
                }
                tokens.add(Token.Operator.Binary.Comparison.Less.INSTANCE);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == '>') {
                if (TokenizationState.nextChar$default(state, 0, 1, null) == '=') {
                    tokens.add(Token.Operator.Binary.Comparison.GreaterOrEqual.INSTANCE);
                    state.forward(2);
                    continue;
                }
                tokens.add(Token.Operator.Binary.Comparison.Greater.INSTANCE);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == '=') {
                if (TokenizationState.nextChar$default(state, 0, 1, null) == '=') {
                    tokens.add(Token.Operator.Binary.Equality.Equal.INSTANCE);
                    state.forward(2);
                    continue;
                }
                throw this.invalidToken(state);
            }
            if (c == '(') {
                tokens.add(Token.Bracket.LeftRound.INSTANCE);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == ')') {
                tokens.add(Token.Bracket.RightRound.INSTANCE);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == ',') {
                tokens.add(Token.Function.ArgumentDelimiter.INSTANCE);
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (c == '\'') {
                Tokenizer.processStringTemplate$default(this, state, tokens, false, 4, null);
                continue;
            }
            if (this.isWhiteSpace(state.currentChar())) {
                TokenizationState.forward$default(state, 0, 1, null);
                continue;
            }
            if (this.isDecimal(state.currentChar(), TokenizationState.prevChar$default(state, 0, 1, null), TokenizationState.nextChar$default(state, 0, 1, null))) {
                this.processNumber(state, tokens);
                continue;
            }
            if (this.isAlphabetic(state.currentChar())) {
                this.processIdentifier(state, tokens);
                continue;
            }
            throw this.invalidToken(state);
        }
        if (!this.isAtEndOfExpression(state.currentChar())) {
            throw new TokenizingException(Intrinsics.stringPlus((String)"'}' expected at end of expression at ", (Object)state.getIndex()), null, 2, null);
        }
        TokenizationState.forward$default(state, 0, 1, null);
        return true;
    }

    static /* synthetic */ boolean processExpression$default(Tokenizer tokenizer, TokenizationState tokenizationState, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = tokenizationState.getTokens();
        }
        return tokenizer.processExpression(tokenizationState, list);
    }

    private final void processNumber(TokenizationState state, List<Token> tokens) {
        int start = state.getIndex();
        boolean isNegative = CollectionsKt.lastOrNull(tokens) instanceof Token.Operator.Unary.Minus;
        if (isNegative) {
            CollectionsKt.removeLastOrNull(tokens);
        }
        do {
            TokenizationState.forward$default(state, 0, 1, null);
        } while (Character.isDigit(state.currentChar()));
        if (state.charAt(start) == '.' || this.isDecimal(state.currentChar(), TokenizationState.prevChar$default(state, 0, 1, null), TokenizationState.nextChar$default(state, 0, 1, null))) {
            double d;
            while (this.isDecimal(state.currentChar(), TokenizationState.prevChar$default(state, 0, 1, null), TokenizationState.nextChar$default(state, 0, 1, null))) {
                TokenizationState.forward$default(state, 0, 1, null);
            }
            String valueStr = isNegative ? Intrinsics.stringPlus((String)"-", (Object)state.part(start, state.getIndex())) : state.part(start, state.getIndex());
            try {
                d = Double.parseDouble(valueStr);
            }
            catch (Exception e) {
                throw new EvaluableException("Value " + valueStr + " can't be converted to Number type.", null, 2, null);
            }
            double value = d;
            tokens.add(Token.Operand.Literal.Num.box-impl(Token.Operand.Literal.Num.constructor-impl(value)));
        } else {
            long l;
            String valueStr = isNegative ? Intrinsics.stringPlus((String)"-", (Object)state.part(start, state.getIndex())) : state.part(start, state.getIndex());
            try {
                l = Long.parseLong(valueStr);
            }
            catch (Exception e) {
                throw new EvaluableException("Value " + valueStr + " can't be converted to Integer type.", null, 2, null);
            }
            long value = l;
            tokens.add(Token.Operand.Literal.Num.box-impl(Token.Operand.Literal.Num.constructor-impl(value)));
        }
    }

    private final void processIdentifier(TokenizationState state, List<Token> tokens) {
        int start = state.getIndex();
        while (this.isValidIdentifier(state.currentChar())) {
            TokenizationState.forward$default(state, 0, 1, null);
        }
        String name = state.part(start, state.getIndex());
        if (this.processKeyword(name, tokens)) {
            return;
        }
        if (state.currentChar() == '(') {
            if (StringsKt.contains$default((CharSequence)name, (char)'.', (boolean)false, (int)2, null)) {
                throw new EvaluableException("Invalid function name '" + name + '\'', null, 2, null);
            }
            tokens.add(new Token.Function(name));
        } else {
            tokens.add(Token.Operand.Variable.box-impl(Token.Operand.Variable.constructor-impl(name)));
        }
    }

    private final boolean processKeyword(String identifier, List<Token> tokens) {
        boolean bl;
        Token.Operand.Literal.Bool token;
        String string = identifier;
        Token.Operand.Literal.Bool bool = Intrinsics.areEqual((Object)string, (Object)"true") ? Token.Operand.Literal.Bool.box-impl(Token.Operand.Literal.Bool.constructor-impl(true)) : (token = Intrinsics.areEqual((Object)string, (Object)"false") ? Token.Operand.Literal.Bool.box-impl(Token.Operand.Literal.Bool.constructor-impl(false)) : null);
        if (token == null) {
            bl = false;
        } else {
            tokens.add(token);
            bl = true;
        }
        return bl;
    }

    private final EvaluableException invalidToken(TokenizationState state) {
        return new EvaluableException("Invalid token '" + state.currentChar() + "' at position " + state.getIndex(), null, 2, null);
    }

    private final boolean isOperator(List<? extends Token> tokens) {
        if (tokens.isEmpty() || CollectionsKt.last(tokens) instanceof Token.Operator.Unary) {
            return false;
        }
        return CollectionsKt.last(tokens) instanceof Token.Operand || CollectionsKt.last(tokens) instanceof Token.Bracket.RightRound;
    }

    private final boolean isUnaryOperator(List<? extends Token> tokens) {
        return !this.isOperator(tokens) && !(CollectionsKt.lastOrNull(tokens) instanceof Token.Operator.Unary);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAlphabetic(char $this$isAlphabetic) {
        boolean bl;
        boolean bl2;
        if ('a' <= $this$isAlphabetic) {
            if ($this$isAlphabetic < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= $this$isAlphabetic) {
            if ($this$isAlphabetic < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ($this$isAlphabetic != '_') return false;
        return true;
    }

    private final boolean isNumber(char $this$isNumber) {
        return '0' <= $this$isNumber ? $this$isNumber < ':' : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDecimal(char $this$isDecimal, char previousChar, char nextChar) {
        if (Character.isDigit($this$isDecimal)) return true;
        char c = $this$isDecimal;
        if (c != '.') {
            boolean bl;
            if (c == 'e' ? true : c == 'E') {
                if (!Character.isDigit(previousChar)) return false;
                if (Character.isDigit(nextChar)) return true;
                if (nextChar == '+') return true;
                if (nextChar != '-') return false;
                return true;
            }
            if (c == '+') {
                bl = true;
            } else {
                if (c != '-') return false;
                bl = true;
            }
            if (!bl) return false;
            if (previousChar != 'e') {
                if (previousChar != 'E') return false;
            }
            if (!Character.isDigit(nextChar)) return false;
            return true;
        }
        boolean bl = Character.isDigit(nextChar);
        if (!bl) return false;
        return true;
    }

    static /* synthetic */ boolean isDecimal$default(Tokenizer tokenizer, char c, char c2, char c3, int n, Object object) {
        if ((n & 1) != 0) {
            c2 = '\u0000';
        }
        if ((n & 2) != 0) {
            c3 = '\u0000';
        }
        return tokenizer.isDecimal(c, c2, c3);
    }

    private final boolean isWhiteSpace(char $this$isWhiteSpace) {
        return $this$isWhiteSpace == ' ' || $this$isWhiteSpace == '\t' || $this$isWhiteSpace == '\r' || $this$isWhiteSpace == '\n';
    }

    private final boolean isValidIdentifier(char $this$isValidIdentifier) {
        return this.isAlphabetic($this$isValidIdentifier) || this.isNumber($this$isValidIdentifier) || $this$isValidIdentifier == '.';
    }

    private final boolean isAtEndOfStringLiteral(char $this$isAtEndOfStringLiteral, TokenizationState state) {
        return $this$isAtEndOfStringLiteral == '\'' && !state.currentCharIsEscaped();
    }

    private final boolean isStartOfExpression(char $this$isStartOfExpression, TokenizationState state) {
        return $this$isStartOfExpression == '@' && TokenizationState.prevChar$default(state, 0, 1, null) != '\\' && TokenizationState.nextChar$default(state, 0, 1, null) == '{';
    }

    private final boolean isAtEndOfExpression(char $this$isAtEndOfExpression) {
        return $this$isAtEndOfExpression == '}';
    }

    private final boolean isAtEnd(char $this$isAtEnd) {
        return $this$isAtEnd == '\u0000';
    }

    static {
        String[] stringArray = new String[]{"'", "@{"};
        ESCAPE_LITERALS = stringArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0006\u0010\u0015\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0017J\u0013\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u001a\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u0006J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001J\u0010\u0010\u001d\u001a\u00020\u00112\b\b\u0002\u0010\u001e\u001a\u00020\u0006J\u0016\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006J\u0010\u0010\"\u001a\u00020\u00112\b\b\u0002\u0010\u001e\u001a\u00020\u0006J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/yandex/div/evaluable/internal/Tokenizer$TokenizationState;", "", "source", "", "(Ljava/lang/String;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "tokens", "", "Lcom/yandex/div/evaluable/internal/Token;", "getTokens", "()Ljava/util/List;", "charAt", "", "position", "component1", "copy", "currentChar", "currentCharIsEscaped", "", "equals", "other", "forward", "count", "hashCode", "nextChar", "step", "part", "from", "to", "prevChar", "toString", "div-evaluable"})
    private static final class TokenizationState {
        @NotNull
        private final String source;
        private int index;
        @NotNull
        private final List<Token> tokens;

        public TokenizationState(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
            this.tokens = new ArrayList();
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @NotNull
        public final List<Token> getTokens() {
            return this.tokens;
        }

        public final char prevChar(int step) {
            return this.index - step >= 0 ? this.source.charAt(this.index - step) : (char)'\u0000';
        }

        public static /* synthetic */ char prevChar$default(TokenizationState tokenizationState, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return tokenizationState.prevChar(n);
        }

        public final boolean currentCharIsEscaped() {
            int n;
            if (this.index >= this.source.length()) {
                n = 0;
            } else {
                int n2;
                int currentIndex = this.index - 1;
                int backslashesCounter = 0;
                while (currentIndex > 0 && this.source.charAt(currentIndex) == '\\') {
                    n2 = backslashesCounter;
                    backslashesCounter = n2 + 1;
                    n2 = currentIndex;
                    currentIndex = n2 + -1;
                }
                boolean isEscaped = backslashesCounter % 2 == 1;
                n = n2;
            }
            return n != 0;
        }

        public final char currentChar() {
            return this.index >= this.source.length() ? (char)'\u0000' : this.source.charAt(this.index);
        }

        public final char charAt(int position) {
            return (0 <= position ? position < this.source.length() : false) ? this.source.charAt(position) : (char)'\u0000';
        }

        @NotNull
        public final String part(int from, int to) {
            String string = this.source.substring(from, to);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }

        public final char nextChar(int step) {
            return this.index + step >= this.source.length() ? (char)'\u0000' : this.source.charAt(this.index + step);
        }

        public static /* synthetic */ char nextChar$default(TokenizationState tokenizationState, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return tokenizationState.nextChar(n);
        }

        public final int forward(int count) {
            int value = this.index;
            this.index += count;
            return value;
        }

        public static /* synthetic */ int forward$default(TokenizationState tokenizationState, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return tokenizationState.forward(n);
        }

        private final String component1() {
            return this.source;
        }

        @NotNull
        public final TokenizationState copy(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new TokenizationState(source);
        }

        public static /* synthetic */ TokenizationState copy$default(TokenizationState tokenizationState, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = tokenizationState.source;
            }
            return tokenizationState.copy(string);
        }

        @NotNull
        public String toString() {
            return "TokenizationState(source=" + this.source + ')';
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenizationState)) {
                return false;
            }
            TokenizationState tokenizationState = (TokenizationState)other;
            return Intrinsics.areEqual((Object)this.source, (Object)tokenizationState.source);
        }
    }
}

