/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.evaluable.types;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/yandex/div/evaluable/types/DateTime;", "", "timestampMillis", "", "timezone", "Ljava/util/TimeZone;", "(JLjava/util/TimeZone;)V", "calendar", "Ljava/util/Calendar;", "kotlin.jvm.PlatformType", "getCalendar", "()Ljava/util/Calendar;", "calendar$delegate", "Lkotlin/Lazy;", "getTimestampMillis$div_evaluable", "()J", "timestampUtc", "getTimezone$div_evaluable", "()Ljava/util/TimeZone;", "timezoneMinutes", "", "getTimezoneMinutes$div_evaluable", "()I", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "Companion", "div-evaluable"})
public final class DateTime
implements Comparable<DateTime> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long timestampMillis;
    @NotNull
    private final TimeZone timezone;
    @NotNull
    private final Lazy calendar$delegate;
    private final int timezoneMinutes;
    private final long timestampUtc;
    @NotNull
    private static final String DEFAULT_FORMAT_PATTERN = "yyyy-MM-dd hh:mm:ss";
    @NotNull
    private static final SimpleTimeZone utcTimezone = new SimpleTimeZone(0, "UTC");

    public DateTime(long timestampMillis, @NotNull TimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        this.timestampMillis = timestampMillis;
        this.timezone = timezone;
        this.calendar$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Calendar>(this){
            final /* synthetic */ DateTime this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Calendar invoke() {
                Calendar calendar2 = Calendar.getInstance(DateTime.access$getUtcTimezone$cp());
                DateTime dateTime = this.this$0;
                Calendar $this$invoke_u24lambda_u240 = calendar2;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setTimeInMillis(dateTime.getTimestampMillis$div_evaluable());
                return calendar2;
            }
        }));
        this.timezoneMinutes = this.timezone.getRawOffset() / 60;
        this.timestampUtc = this.timestampMillis - (long)(this.timezoneMinutes * 60000);
    }

    public final long getTimestampMillis$div_evaluable() {
        return this.timestampMillis;
    }

    @NotNull
    public final TimeZone getTimezone$div_evaluable() {
        return this.timezone;
    }

    private final Calendar getCalendar() {
        Lazy lazy = this.calendar$delegate;
        return (Calendar)lazy.getValue();
    }

    public final int getTimezoneMinutes$div_evaluable() {
        return this.timezoneMinutes;
    }

    @NotNull
    public String toString() {
        Calendar calendar2 = this.getCalendar();
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"calendar");
        return Companion.formatDate$div_evaluable(calendar2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DateTime)) {
            return false;
        }
        return this.timestampUtc == ((DateTime)other).timestampUtc;
    }

    public int hashCode() {
        return Long.hashCode(this.timestampUtc);
    }

    @Override
    public int compareTo(@NotNull DateTime other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.timestampUtc, (long)other.timestampUtc);
    }

    public static final /* synthetic */ SimpleTimeZone access$getUtcTimezone$cp() {
        return utcTimezone;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/yandex/div/evaluable/types/DateTime$Companion;", "", "()V", "DEFAULT_FORMAT_PATTERN", "", "utcTimezone", "Ljava/util/SimpleTimeZone;", "formatDate", "c", "Ljava/util/Calendar;", "formatDate$div_evaluable", "parseAsUTC", "Lcom/yandex/div/evaluable/types/DateTime;", "source", "parseAsUTC$div_evaluable", "div-evaluable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTime parseAsUTC$div_evaluable(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            SimpleDateFormat dateFormat = new SimpleDateFormat(DateTime.DEFAULT_FORMAT_PATTERN, Locale.getDefault());
            Date date = dateFormat.parse(source);
            Intrinsics.checkNotNull((Object)date);
            Date date2 = date;
            long l = date2.getTime() + (long)Calendar.getInstance().getTimeZone().getRawOffset();
            TimeZone timeZone = TimeZone.getTimeZone("UTC");
            Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getTimeZone(\"UTC\")");
            return new DateTime(l, timeZone);
        }

        @NotNull
        public final String formatDate$div_evaluable(@NotNull Calendar c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            String yyyy = String.valueOf(c.get(1));
            String MM = StringsKt.padStart((String)String.valueOf(c.get(2) + 1), (int)2, (char)'0');
            String DD = StringsKt.padStart((String)String.valueOf(c.get(5)), (int)2, (char)'0');
            String hh = StringsKt.padStart((String)String.valueOf(c.get(11)), (int)2, (char)'0');
            String mm = StringsKt.padStart((String)String.valueOf(c.get(12)), (int)2, (char)'0');
            String ss = StringsKt.padStart((String)String.valueOf(c.get(13)), (int)2, (char)'0');
            return yyyy + '-' + MM + '-' + DD + ' ' + hh + ':' + mm + ':' + ss;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

