/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.histogram;

import androidx.annotation.NonNull;
import com.yandex.div.histogram.HistogramBridge;
import java.util.concurrent.TimeUnit;

public class HistogramRecorder {
    @NonNull
    private final HistogramBridge mBridge;

    public HistogramRecorder(@NonNull HistogramBridge bridge) {
        this.mBridge = bridge;
    }

    public void recordBooleanHistogram(@NonNull String name, boolean sample) {
        this.mBridge.recordBooleanHistogram(name, sample);
    }

    public void recordEnumeratedHistogram(@NonNull String name, int sample, int boundary) {
        this.mBridge.recordEnumeratedHistogram(name, sample, boundary);
    }

    public void recordPercentageHistogram(@NonNull String name, int sample) {
        this.mBridge.recordLinearCountHistogram(name, sample, 1, 101, 102);
    }

    public void recordLinearCountHistogram(@NonNull String name, int sample, int min, int max, int bucketCount) {
        this.mBridge.recordLinearCountHistogram(name, sample, min, max, bucketCount);
    }

    public void recordCount100Histogram(@NonNull String name, int sample) {
        this.mBridge.recordCountHistogram(name, sample, 1, 100, 50);
    }

    public void recordCount1KHistogram(@NonNull String name, int sample) {
        this.mBridge.recordCountHistogram(name, sample, 1, 1000, 50);
    }

    public void recordCount10KHistogram(@NonNull String name, int sample) {
        this.mBridge.recordCountHistogram(name, sample, 1, 10000, 50);
    }

    public void recordCount100KHistogram(@NonNull String name, int sample) {
        this.mBridge.recordCountHistogram(name, sample, 1, 100000, 50);
    }

    public void recordCount1MHistogram(@NonNull String name, int sample) {
        this.mBridge.recordCountHistogram(name, sample, 1, 1000000, 50);
    }

    public void recordCustomCountHistogram(@NonNull String name, int sample, int min, int max, int bucketCount) {
        this.mBridge.recordCountHistogram(name, sample, min, max, bucketCount);
    }

    public void recordShortTimeHistogram(@NonNull String name, long duration, @NonNull TimeUnit unit) {
        this.mBridge.recordTimeHistogram(name, unit.toMillis(duration), 1L, 10000L, TimeUnit.MILLISECONDS, 50);
    }

    public void recordMediumTimeHistogram(@NonNull String name, long duration, @NonNull TimeUnit unit) {
        this.mBridge.recordTimeHistogram(name, unit.toMillis(duration), 1L, 180000L, TimeUnit.MILLISECONDS, 50);
    }

    public void recordLongTimeHistogram(@NonNull String name, long duration, @NonNull TimeUnit unit) {
        this.mBridge.recordTimeHistogram(name, unit.toMillis(duration), 1L, 3600000L, TimeUnit.MILLISECONDS, 50);
    }

    public void recordCustomTimeHistogram(@NonNull String name, long duration, long min, long max, @NonNull TimeUnit unit, int bucketCount) {
        this.mBridge.recordTimeHistogram(name, unit.toMillis(duration), unit.toMillis(min), unit.toMillis(max), TimeUnit.MILLISECONDS, bucketCount);
    }

    public void recordMemoryKbHistogram(@NonNull String name, int sizeKb) {
        this.mBridge.recordCountHistogram(name, sizeKb, 1000, 500000, 50);
    }

    public void recordMemoryMbHistogram(@NonNull String name, int sizeMb) {
        this.mBridge.recordCountHistogram(name, sizeMb, 1, 1000, 50);
    }

    public void recordLargeMemoryMbHistogram(@NonNull String name, int sizeMb) {
        this.mBridge.recordCountHistogram(name, sizeMb, 1, 64000, 100);
    }

    public void recordSparseSlowlyHistogram(@NonNull String name, int sample) {
        this.mBridge.recordSparseSlowlyHistogram(name, sample);
    }
}

