/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.histogram.util;

import com.yandex.div.histogram.util.HistogramUtils;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0000H\u0002J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0000H\u0002J\b\u0010\f\u001a\u00020\u0000H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0012\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/yandex/div/histogram/util/JSONUtf8BytesCalculator;", "", "()V", "bytesSize", "", "array", "entriesSeparator", "entries", "key", "name", "", "keyValueSeparator", "object", "string", "", "value", "Companion", "div-histogram_release"})
public final class JSONUtf8BytesCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int bytesSize;
    private static final int OBJECT_BRACES_BYTES = 2;
    private static final int ARRAY_BRACKETS_BYTES = 2;
    private static final int QUOTES_BYTES = 2;
    private static final int ENTRIES_SEPARATOR_BYTES = 1;
    private static final int KEY_VALUE_SEPARATOR_BYTES = 1;
    private static final int NULL_BYTES = 4;
    private static final int ESCAPED_CHARACTERS_BYTES = 2;
    private static final int TRUE_BYTES = 4;
    private static final int FALSE_BYTES = 5;

    private final JSONUtf8BytesCalculator array() {
        this.bytesSize += 2;
        return this;
    }

    private final JSONUtf8BytesCalculator object() {
        this.bytesSize += 2;
        return this;
    }

    private final JSONUtf8BytesCalculator value(Object value) {
        if (value instanceof JSONArray) {
            JSONUtf8BytesCalculator.Companion.calculateUtf8JsonArrayBytes((JSONArray)value, this);
            return this;
        }
        if (value instanceof JSONObject) {
            JSONUtf8BytesCalculator.Companion.calculateUtf8JsonBytes((JSONObject)value, this);
            return this;
        }
        if (value == null || value == JSONObject.NULL) {
            this.bytesSize += 4;
        } else if (value instanceof Boolean) {
            this.bytesSize += (Boolean)value != false ? 4 : 5;
        } else if (value instanceof Number) {
            String string = JSONObject.numberToString((Number)((Number)value));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"numberToString(value)");
            this.bytesSize += HistogramUtils.INSTANCE.calculateUtf8StringByteSize(string);
        } else {
            this.string(value.toString());
        }
        return this;
    }

    private final void string(String value) {
        this.bytesSize += 2;
        int n = 0;
        int n2 = value.length();
        while (n < n2) {
            int n3;
            char ch = value.charAt(n);
            ++n;
            char c = ch;
            if ((((((c == '\"' ? true : c == '\\') ? true : c == '/') ? true : c == '\t') ? true : c == '\b') ? true : c == '\n') ? true : c == '\r') {
                n3 = 2;
            } else if (ch <= '\u001f') {
                String string = "\\u%04x";
                Object[] objectArray = new Object[]{(int)ch};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                n3 = HistogramUtils.INSTANCE.calculateUtf8StringByteSize(string2);
            } else {
                n3 = HistogramUtils.INSTANCE.getUtf8CharByteSize(ch);
            }
            this.bytesSize += n3;
        }
    }

    private final JSONUtf8BytesCalculator key(String name) {
        this.string(name);
        return this;
    }

    private final JSONUtf8BytesCalculator keyValueSeparator() {
        ++this.bytesSize;
        return this;
    }

    private final JSONUtf8BytesCalculator entriesSeparator(int entries) {
        if (entries <= 1) {
            return this;
        }
        this.bytesSize += 1 * (entries - 1);
        return this;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0014J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/yandex/div/histogram/util/JSONUtf8BytesCalculator$Companion;", "", "()V", "ARRAY_BRACKETS_BYTES", "", "ENTRIES_SEPARATOR_BYTES", "ESCAPED_CHARACTERS_BYTES", "FALSE_BYTES", "KEY_VALUE_SEPARATOR_BYTES", "NULL_BYTES", "OBJECT_BRACES_BYTES", "QUOTES_BYTES", "TRUE_BYTES", "calculateUtf8JsonArrayBytes", "", "json", "Lorg/json/JSONArray;", "jsonUtf8BytesCalculator", "Lcom/yandex/div/histogram/util/JSONUtf8BytesCalculator;", "calculateUtf8JsonBytes", "Lorg/json/JSONObject;", "div-histogram_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int calculateUtf8JsonBytes(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JSONUtf8BytesCalculator jsonUtf8BytesCalculator = new JSONUtf8BytesCalculator();
            this.calculateUtf8JsonBytes(json, jsonUtf8BytesCalculator);
            return jsonUtf8BytesCalculator.bytesSize;
        }

        /*
         * WARNING - void declaration
         */
        private final void calculateUtf8JsonBytes(JSONObject json, JSONUtf8BytesCalculator jsonUtf8BytesCalculator) {
            void $this$forEach$iv;
            jsonUtf8BytesCalculator.object().entriesSeparator(json.length());
            Iterator iterator = json.keys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"json.keys()");
            boolean $i$f$forEach = false;
            void var5_5 = $this$forEach$iv;
            while (var5_5.hasNext()) {
                Object element$iv = var5_5.next();
                String it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                jsonUtf8BytesCalculator.key(it).keyValueSeparator().value(json.get(it));
            }
        }

        private final void calculateUtf8JsonArrayBytes(JSONArray json, JSONUtf8BytesCalculator jsonUtf8BytesCalculator) {
            jsonUtf8BytesCalculator.array().entriesSeparator(json.length());
            int n = 0;
            int n2 = json.length();
            while (n < n2) {
                int i = n++;
                jsonUtf8BytesCalculator.value(json.get(i));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

