/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.histogram.util;

import com.yandex.div.histogram.HistogramCallType;
import com.yandex.div.histogram.HistogramRecordConfiguration;
import com.yandex.div.histogram.util.JSONUtf8BytesCalculator;
import com.yandex.div.internal.Assert;
import com.yandex.div.internal.KAssert;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/yandex/div/histogram/util/HistogramUtils;", "", "()V", "calculateUtf8JsonByteSize", "", "json", "Lorg/json/JSONObject;", "calculateUtf8StringByteSize", "str", "", "getUtf8CharByteSize", "ch", "", "shouldRecordHistogram", "", "callType", "configuration", "Lcom/yandex/div/histogram/HistogramRecordConfiguration;", "div-histogram_release"})
@SourceDebugExtension(value={"SMAP\nHistogramUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistogramUtils.kt\ncom/yandex/div/histogram/util/HistogramUtils\n+ 2 KAssert.kt\ncom/yandex/div/internal/KAssert\n*L\n1#1,74:1\n14#2,4:75\n14#2,4:79\n*S KotlinDebug\n*F\n+ 1 HistogramUtils.kt\ncom/yandex/div/histogram/util/HistogramUtils\n*L\n43#1:75,4\n61#1:79,4\n*E\n"})
public final class HistogramUtils {
    @NotNull
    public static final HistogramUtils INSTANCE = new HistogramUtils();

    private HistogramUtils() {
    }

    public final int calculateUtf8StringByteSize(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        int byteSize = 0;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            byteSize += this.getUtf8CharByteSize(ch);
        }
        return byteSize;
    }

    public final int getUtf8CharByteSize(char ch) {
        int n;
        if (Character.isHighSurrogate(ch)) {
            n = 4;
        } else if (Character.isLowSurrogate(ch)) {
            n = 0;
        } else if (ch < '\u0080') {
            n = 1;
        } else if (ch < '\u0800') {
            n = 2;
        } else if (ch < '\u10000') {
            n = 3;
        } else {
            KAssert this_$iv = KAssert.INSTANCE;
            boolean $i$f$fail = false;
            if (Assert.isEnabled()) {
                boolean bl = false;
                Assert.fail((String)("Unsupported character: '" + ch + '\''));
            }
            n = 4;
        }
        return n;
    }

    public final boolean shouldRecordHistogram(@HistogramCallType @NotNull String callType, @NotNull HistogramRecordConfiguration configuration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)callType, (String)"callType");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        switch (callType) {
            case "Cold": {
                bl = configuration.isColdRecordingEnabled();
                break;
            }
            case "Cool": {
                bl = configuration.isCoolRecordingEnabled();
                break;
            }
            case "Warm": {
                bl = configuration.isWarmRecordingEnabled();
                break;
            }
            default: {
                KAssert this_$iv = KAssert.INSTANCE;
                boolean $i$f$fail = false;
                if (Assert.isEnabled()) {
                    boolean bl2 = false;
                    Assert.fail((String)("Unknown histogram call type: " + callType));
                }
                bl = false;
            }
        }
        return bl;
    }

    public final int calculateUtf8JsonByteSize(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return JSONUtf8BytesCalculator.Companion.calculateUtf8JsonBytes(json);
    }
}

