/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.json;

import com.yandex.div.internal.parser.JsonTopologicalSorting;
import com.yandex.div.internal.parser.ParsingEnvironmentImpl;
import com.yandex.div.internal.parser.TemplateParsingErrorLogger;
import com.yandex.div.internal.util.CollectionsKt;
import com.yandex.div.json.JsonTemplate;
import com.yandex.div.json.ParsingEnvironment;
import com.yandex.div.json.ParsingErrorLogger;
import com.yandex.div.json.ParsingException;
import com.yandex.div.json.templates.CachingTemplateProvider;
import com.yandex.div.json.templates.InMemoryTemplateProvider;
import com.yandex.div.json.templates.TemplateProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0002\u001c\u001dB\u001f\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/yandex/div/json/TemplateParsingEnvironment;", "T", "Lcom/yandex/div/json/JsonTemplate;", "Lcom/yandex/div/json/ParsingEnvironment;", "logger", "Lcom/yandex/div/json/ParsingErrorLogger;", "mainTemplateProvider", "Lcom/yandex/div/json/templates/CachingTemplateProvider;", "(Lcom/yandex/div/json/ParsingErrorLogger;Lcom/yandex/div/json/templates/CachingTemplateProvider;)V", "getLogger", "()Lcom/yandex/div/json/ParsingErrorLogger;", "templateFactory", "Lcom/yandex/div/json/TemplateParsingEnvironment$TemplateFactory;", "getTemplateFactory", "()Lcom/yandex/div/json/TemplateParsingEnvironment$TemplateFactory;", "templates", "Lcom/yandex/div/json/templates/TemplateProvider;", "getTemplates", "()Lcom/yandex/div/json/templates/TemplateProvider;", "parseTemplates", "", "json", "Lorg/json/JSONObject;", "parseTemplatesWithResult", "", "", "parseTemplatesWithResultAndDependencies", "Lcom/yandex/div/json/TemplateParsingEnvironment$TemplateParsingResult;", "TemplateFactory", "TemplateParsingResult", "div-json_release"})
public abstract class TemplateParsingEnvironment<T extends JsonTemplate<?>>
implements ParsingEnvironment {
    @NotNull
    private final ParsingErrorLogger logger;
    @NotNull
    private final CachingTemplateProvider<T> mainTemplateProvider;
    @NotNull
    private final TemplateProvider<T> templates;

    @JvmOverloads
    public TemplateParsingEnvironment(@NotNull ParsingErrorLogger logger, @NotNull CachingTemplateProvider<T> mainTemplateProvider) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(mainTemplateProvider, (String)"mainTemplateProvider");
        this.logger = logger;
        this.mainTemplateProvider = mainTemplateProvider;
        this.templates = this.mainTemplateProvider;
    }

    public /* synthetic */ TemplateParsingEnvironment(ParsingErrorLogger parsingErrorLogger, CachingTemplateProvider cachingTemplateProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cachingTemplateProvider = new CachingTemplateProvider(new InMemoryTemplateProvider(), TemplateProvider.Companion.empty());
        }
        this(parsingErrorLogger, cachingTemplateProvider);
    }

    @Override
    @NotNull
    public ParsingErrorLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public abstract TemplateFactory<T> getTemplateFactory();

    @NotNull
    public TemplateProvider<T> getTemplates() {
        return this.templates;
    }

    public final void parseTemplates(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Map<String, T> parsed = this.parseTemplatesWithResult(json);
        this.mainTemplateProvider.putAll(parsed);
    }

    @NotNull
    public final Map<String, T> parseTemplatesWithResult(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return this.parseTemplatesWithResultAndDependencies(json).getParsedTemplates();
    }

    @NotNull
    public final TemplateParsingResult<T> parseTemplatesWithResultAndDependencies(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Map parsedTemplates = CollectionsKt.arrayMap();
        Map templateDependencies = CollectionsKt.arrayMap();
        try {
            Map<String, Set<String>> orderedNamesWithDependencies = JsonTopologicalSorting.INSTANCE.sort(json, this.getLogger(), this);
            this.mainTemplateProvider.takeSnapshot(parsedTemplates);
            TemplateProvider tmpProvider = TemplateProvider.Companion.wrap(parsedTemplates);
            Map<String, Set<String>> $this$forEach$iv = orderedNamesWithDependencies;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Set<String>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Set<String>> element$iv;
                Map.Entry<String, Set<String>> $dstr$name$dependencies = element$iv = iterator.next();
                boolean bl = false;
                String name = $dstr$name$dependencies.getKey();
                Set<String> dependencies = $dstr$name$dependencies.getValue();
                try {
                    ParsingEnvironmentImpl env = new ParsingEnvironmentImpl(tmpProvider, new TemplateParsingErrorLogger(this.getLogger(), name));
                    TemplateFactory<T> templateFactory = this.getTemplateFactory();
                    ParsingEnvironment parsingEnvironment = env;
                    JSONObject jSONObject = json.getJSONObject(name);
                    Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"json.getJSONObject(name)");
                    JsonTemplate template = (JsonTemplate)templateFactory.create(parsingEnvironment, true, jSONObject);
                    parsedTemplates.put(name, template);
                    if (!(!((Collection)dependencies).isEmpty())) continue;
                    templateDependencies.put(name, dependencies);
                }
                catch (ParsingException e) {
                    this.getLogger().logTemplateError(e, name);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().logError(e);
        }
        return new TemplateParsingResult(parsedTemplates, templateDependencies);
    }

    @JvmOverloads
    public TemplateParsingEnvironment(@NotNull ParsingErrorLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this(logger, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J%\u0010\u0003\u001a\u00028\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/yandex/div/json/TemplateParsingEnvironment$TemplateFactory;", "T", "", "create", "env", "Lcom/yandex/div/json/ParsingEnvironment;", "topLevel", "", "json", "Lorg/json/JSONObject;", "(Lcom/yandex/div/json/ParsingEnvironment;ZLorg/json/JSONObject;)Ljava/lang/Object;", "div-json_release"})
    public static interface TemplateFactory<T> {
        public T create(@NotNull ParsingEnvironment var1, boolean var2, @NotNull JSONObject var3) throws JSONException;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B3\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0004\u00a2\u0006\u0002\u0010\bR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\f"}, d2={"Lcom/yandex/div/json/TemplateParsingEnvironment$TemplateParsingResult;", "T", "", "parsedTemplates", "", "", "templateDependencies", "", "(Ljava/util/Map;Ljava/util/Map;)V", "getParsedTemplates", "()Ljava/util/Map;", "getTemplateDependencies", "div-json_release"})
    public static final class TemplateParsingResult<T> {
        @NotNull
        private final Map<String, T> parsedTemplates;
        @NotNull
        private final Map<String, Set<String>> templateDependencies;

        public TemplateParsingResult(@NotNull Map<String, ? extends T> parsedTemplates, @NotNull Map<String, ? extends Set<String>> templateDependencies) {
            Intrinsics.checkNotNullParameter(parsedTemplates, (String)"parsedTemplates");
            Intrinsics.checkNotNullParameter(templateDependencies, (String)"templateDependencies");
            this.parsedTemplates = parsedTemplates;
            this.templateDependencies = templateDependencies;
        }

        @NotNull
        public final Map<String, T> getParsedTemplates() {
            return this.parsedTemplates;
        }

        @NotNull
        public final Map<String, Set<String>> getTemplateDependencies() {
            return this.templateDependencies;
        }
    }
}

