/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal.parser;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.div.internal.parser.ListValidator;
import com.yandex.div.internal.parser.TypeHelper;
import com.yandex.div.internal.parser.TypeHelpersKt;
import com.yandex.div.internal.parser.ValueValidator;
import com.yandex.div.json.JSONSerializable;
import com.yandex.div.json.ParsingEnvironment;
import com.yandex.div.json.ParsingErrorLogger;
import com.yandex.div.json.ParsingException;
import com.yandex.div.json.ParsingExceptionKt;
import com.yandex.div.json.expressions.ConstantExpressionList;
import com.yandex.div.json.expressions.Expression;
import com.yandex.div.json.expressions.ExpressionList;
import com.yandex.div.json.expressions.MutableExpressionList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonParser {
    @NonNull
    private static final ValueValidator<?> ALWAYS_VALID = any -> true;
    @NonNull
    private static final ValueValidator<String> IS_STRING = any -> true;
    @NonNull
    private static final ListValidator<?> ALWAYS_VALID_LIST = any -> true;
    @NonNull
    private static final Function1<?, ?> AS_IS = any -> any;
    private static final ExpressionList<?> EMPTY_EXPRESSION_LIST = new ConstantExpressionList(Collections.emptyList());

    @Nullable
    public static <T> Expression<T> readOptionalExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readOptionalExpression(jsonObject, key, JsonParser.doNotConvert(), validator, logger, env, typeHelper);
    }

    @Nullable
    public static <T> Expression<T> readOptionalExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @Nullable Expression<T> defaultValue, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readOptionalExpression(jsonObject, key, JsonParser.doNotConvert(), JsonParser.alwaysValid(), logger, env, defaultValue, typeHelper);
    }

    @Nullable
    public static Expression<String> readOptionalExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<String> typeHelper) {
        return JsonParser.readOptionalExpression(jsonObject, key, JsonParser.doNotConvert(), IS_STRING, logger, env, typeHelper);
    }

    @Nullable
    public static <R, T> Expression<T> readOptionalExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readOptionalExpression(jsonObject, key, converter, JsonParser.alwaysValid(), logger, env, typeHelper);
    }

    @NonNull
    public static Expression<JSONArray> readExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readExpression(jsonObject, key, JsonParser.doNotConvert(), logger, env, TypeHelpersKt.TYPE_HELPER_JSON_ARRAY);
    }

    @NonNull
    public static Expression<String> readExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<String> typeHelper) {
        return JsonParser.readExpression(jsonObject, key, JsonParser.doNotConvert(), IS_STRING, logger, env, typeHelper);
    }

    @NonNull
    public static <T> Expression<T> readExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readExpression(jsonObject, key, JsonParser.doNotConvert(), validator, logger, env, typeHelper);
    }

    @NonNull
    public static <R, T> Expression<T> readExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readExpression(jsonObject, key, converter, JsonParser.alwaysValid(), logger, env, typeHelper);
    }

    @Nullable
    public static <R, T> Expression<T> readOptionalExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readOptionalExpression(jsonObject, key, converter, validator, logger, env, null, typeHelper);
    }

    @Nullable
    public static <R, T> Expression<T> readOptionalExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @Nullable Expression<T> defaultValue, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readOptionalExpression(jsonObject, key, converter, JsonParser.alwaysValid(), logger, env, defaultValue, typeHelper);
    }

    @Nullable
    public static <T> Expression<T> readOptionalExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @Nullable Expression<T> defaultValue, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readOptionalExpression(jsonObject, key, JsonParser.doNotConvert(), validator, logger, env, defaultValue, typeHelper);
    }

    @Nullable
    public static <R, T> Expression<T> readOptionalExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @Nullable Expression<T> defaultValue, @NonNull TypeHelper<T> typeHelper) {
        Object value;
        Object intermediate = JsonParser.optSafe(jsonObject, key);
        if (intermediate == null) {
            return null;
        }
        if (Expression.mayBeExpression(intermediate)) {
            return new Expression.MutableExpression<R, T>(key, intermediate.toString(), converter, validator, logger, typeHelper, defaultValue);
        }
        try {
            value = converter.invoke(intermediate);
        }
        catch (ClassCastException castException) {
            logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        catch (Exception e) {
            logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate, (Throwable)e));
            return null;
        }
        if (value == null) {
            logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate));
            return null;
        }
        try {
            if (!validator.isValid(value)) {
                logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate));
                return null;
            }
        }
        catch (ClassCastException castException) {
            logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        return Expression.constant(value);
    }

    @NonNull
    public static <R, T> Expression<T> readExpression(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        Object value;
        Object intermediate = JsonParser.optSafe(jsonObject, key);
        if (intermediate == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        if (Expression.mayBeExpression(intermediate)) {
            return new Expression.MutableExpression<R, T>(key, intermediate.toString(), converter, validator, logger, typeHelper, null);
        }
        try {
            value = converter.invoke(intermediate);
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate);
        }
        catch (Exception e) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, intermediate, (Throwable)e);
        }
        if (value == null) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, intermediate);
        }
        try {
            if (!validator.isValid(value)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, intermediate);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate);
        }
        return Expression.constant(value);
    }

    @Nullable
    public static <T> T readOptional(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readOptional(jsonObject, key, JsonParser.doNotConvert(), validator, logger, env);
    }

    @Nullable
    public static <T> T readOptional(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readOptional(jsonObject, key, JsonParser.doNotConvert(), JsonParser.alwaysValid(), logger, env);
    }

    @Nullable
    public static <R, T> T readOptional(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readOptional(jsonObject, key, converter, JsonParser.alwaysValid(), logger, env);
    }

    @Nullable
    public static <T extends JSONSerializable> T readOptional(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        JSONObject json = jsonObject.optJSONObject(key);
        if (json == null) {
            return null;
        }
        try {
            return (T)((JSONSerializable)creator.invoke((Object)env, (Object)json));
        }
        catch (ParsingException e) {
            logger.logError(e);
            return null;
        }
    }

    @Nullable
    public static <R, T> T readOptional(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        Object intermediate = JsonParser.optSafe(jsonObject, key);
        if (intermediate == null) {
            return null;
        }
        Object result = null;
        try {
            result = converter.invoke(intermediate);
        }
        catch (ClassCastException castException) {
            logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        catch (Exception e) {
            logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate, (Throwable)e));
            return null;
        }
        if (result == null) {
            logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate));
            return null;
        }
        try {
            if (!validator.isValid(result)) {
                logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate));
                return null;
            }
        }
        catch (ClassCastException castException) {
            logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        return (T)result;
    }

    @Nullable
    public static <T> T readOptional(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function2<ParsingEnvironment, JSONObject, T> converter, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        Object result;
        JSONObject intermediate = jsonObject.optJSONObject(key);
        if (intermediate == null) {
            return null;
        }
        try {
            result = converter.invoke((Object)env, (Object)intermediate);
        }
        catch (ClassCastException castException) {
            logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        catch (Exception e) {
            logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate, (Throwable)e));
            return null;
        }
        if (result == null) {
            logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate));
            return null;
        }
        try {
            if (!validator.isValid(result)) {
                logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate));
                return null;
            }
        }
        catch (ClassCastException castException) {
            logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        return (T)result;
    }

    @NonNull
    public static <T> T read(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.read(jsonObject, key, JsonParser.doNotConvert(), validator, logger, env);
    }

    @NonNull
    public static <T> T read(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.read(jsonObject, key, JsonParser.doNotConvert(), JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <R, T> T read(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.read(jsonObject, key, converter, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <T> T read(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.read(jsonObject, key, creator, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <T> T read(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        Object result;
        JSONObject json = jsonObject.optJSONObject(key);
        if (json == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        try {
            result = creator.invoke((Object)env, (Object)json);
        }
        catch (ParsingException e) {
            throw ParsingExceptionKt.dependencyFailed(jsonObject, key, e);
        }
        if (result == null) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, null);
        }
        try {
            if (!validator.isValid(result)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, result);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, result);
        }
        return (T)result;
    }

    @NonNull
    public static <R, T> T read(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        Object result;
        Object intermediate = JsonParser.optSafe(jsonObject, key);
        if (intermediate == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        try {
            result = converter.invoke(intermediate);
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate);
        }
        catch (Exception e) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, intermediate, (Throwable)e);
        }
        if (result == null) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, intermediate);
        }
        try {
            if (!validator.isValid(result)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, result);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, result);
        }
        return (T)result;
    }

    @Nullable
    public static <R, T> List<T> readOptionalList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function2<ParsingEnvironment, R, T> creator, @NonNull ListValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readOptionalList(jsonObject, key, creator, validator, JsonParser.alwaysValid(), logger, env);
    }

    @Nullable
    public static <R, T> List<T> readOptionalList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readOptionalList(jsonObject, key, converter, validator, JsonParser.alwaysValid(), logger, env);
    }

    @Nullable
    public static <R, T> List<T> readOptionalList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> validator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        JSONArray optJSONArray = jsonObject.optJSONArray(key);
        if (optJSONArray == null) {
            return null;
        }
        int length = optJSONArray.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!validator.isValid(emptyList)) {
                    logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return null;
                }
            }
            catch (ClassCastException castException) {
                logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return null;
            }
            return emptyList;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            block15: {
                Object intermediate;
                Object preResult = optJSONArray.opt(i);
                Object object = intermediate = Intrinsics.areEqual((Object)preResult, (Object)JSONObject.NULL) ? null : preResult;
                if (intermediate == null) continue;
                try {
                    item = converter.invoke(intermediate);
                }
                catch (ClassCastException castException) {
                    logger.logError(ParsingExceptionKt.typeMismatch(optJSONArray, key, i, intermediate));
                    continue;
                }
                catch (Exception e) {
                    logger.logError(ParsingExceptionKt.invalidValue(optJSONArray, key, i, intermediate, e));
                    continue;
                }
                if (item == null) continue;
                try {
                    if (!itemValidator.isValid(item)) {
                        logger.logError(ParsingExceptionKt.invalidValue(optJSONArray, key, i, item));
                    }
                    break block15;
                }
                catch (ClassCastException castException) {
                    logger.logError(ParsingExceptionKt.typeMismatch(optJSONArray, key, i, item));
                }
                continue;
            }
            list.add(item);
        }
        try {
            if (!validator.isValid(list)) {
                logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, list));
                return null;
            }
        }
        catch (ClassCastException castException) {
            logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, list));
            return null;
        }
        return list;
    }

    @Nullable
    public static <R, T> List<T> readOptionalList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function2<ParsingEnvironment, R, T> creator, @NonNull ListValidator<T> validator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        JSONArray optJSONArray = jsonObject.optJSONArray(key);
        if (optJSONArray == null) {
            return null;
        }
        int length = optJSONArray.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!validator.isValid(emptyList)) {
                    logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return null;
                }
            }
            catch (ClassCastException castException) {
                logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return null;
            }
            return emptyList;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            block15: {
                JSONObject intermediate = JsonParser.optSafe(optJSONArray.optJSONObject(i));
                if (intermediate == null) continue;
                try {
                    item = creator.invoke((Object)env, (Object)intermediate);
                }
                catch (ClassCastException castException) {
                    logger.logError(ParsingExceptionKt.typeMismatch(optJSONArray, key, i, intermediate));
                    continue;
                }
                catch (Exception e) {
                    logger.logError(ParsingExceptionKt.invalidValue(optJSONArray, key, i, intermediate, e));
                    continue;
                }
                if (item == null) continue;
                try {
                    if (!itemValidator.isValid(item)) {
                        logger.logError(ParsingExceptionKt.invalidValue(optJSONArray, key, i, item));
                    }
                    break block15;
                }
                catch (ClassCastException castException) {
                    logger.logError(ParsingExceptionKt.typeMismatch(optJSONArray, key, i, item));
                }
                continue;
            }
            list.add(item);
        }
        try {
            if (!validator.isValid(list)) {
                logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, list));
                return null;
            }
        }
        catch (ClassCastException castException) {
            logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, list));
            return null;
        }
        return list;
    }

    @NonNull
    public static <T> List<T> readList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ListValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readList(jsonObject, key, creator, validator, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <T> List<T> readList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ListValidator<T> validator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        JSONArray optJSONArray = jsonObject.optJSONArray(key);
        if (optJSONArray == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        int length = optJSONArray.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!validator.isValid(emptyList)) {
                    logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return emptyList;
                }
            }
            catch (ClassCastException castException) {
                logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return emptyList;
            }
            return emptyList;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            block15: {
                JSONObject intermediate = JsonParser.optSafe(optJSONArray.optJSONObject(i));
                if (intermediate == null) continue;
                try {
                    item = creator.invoke((Object)env, (Object)intermediate);
                }
                catch (ClassCastException castException) {
                    logger.logError(ParsingExceptionKt.typeMismatch(optJSONArray, key, i, intermediate));
                    continue;
                }
                catch (Exception e) {
                    logger.logError(ParsingExceptionKt.invalidValue(optJSONArray, key, i, intermediate, e));
                    continue;
                }
                if (item == null) continue;
                try {
                    if (!itemValidator.isValid(item)) {
                        logger.logError(ParsingExceptionKt.invalidValue(optJSONArray, key, i, item));
                    }
                    break block15;
                }
                catch (ClassCastException castException) {
                    logger.logError(ParsingExceptionKt.typeMismatch(optJSONArray, key, i, item));
                }
                continue;
            }
            list.add(item);
        }
        try {
            if (!validator.isValid(list)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, list);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, list);
        }
        return list;
    }

    @NonNull
    public static List<String> readList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ListValidator<String> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readList(jsonObject, key, JsonParser.doNotConvert(), validator, IS_STRING, logger, env);
    }

    @NonNull
    public static <R, T> List<T> readList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readList(jsonObject, key, converter, validator, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <R, T> List<T> readList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> validator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        JSONArray optJSONArray = jsonObject.optJSONArray(key);
        if (optJSONArray == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        int length = optJSONArray.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!validator.isValid(emptyList)) {
                    logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return emptyList;
                }
            }
            catch (ClassCastException castException) {
                logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return emptyList;
            }
            return emptyList;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            block15: {
                Object intermediate = JsonParser.optSafe(optJSONArray.opt(i));
                if (intermediate == null) continue;
                try {
                    item = converter.invoke(intermediate);
                }
                catch (ClassCastException castException) {
                    logger.logError(ParsingExceptionKt.typeMismatch(optJSONArray, key, i, intermediate));
                    continue;
                }
                catch (Exception e) {
                    logger.logError(ParsingExceptionKt.invalidValue(optJSONArray, key, i, intermediate, e));
                    continue;
                }
                if (item == null) continue;
                try {
                    if (!itemValidator.isValid(item)) {
                        logger.logError(ParsingExceptionKt.invalidValue(optJSONArray, key, i, item));
                    }
                    break block15;
                }
                catch (ClassCastException castException) {
                    logger.logError(ParsingExceptionKt.typeMismatch(optJSONArray, key, i, item));
                }
                continue;
            }
            list.add(item);
        }
        try {
            if (!validator.isValid(list)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, list);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, list);
        }
        return list;
    }

    @NonNull
    public static ExpressionList<String> readExpressionList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ListValidator<String> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<String> typeHelper) {
        return JsonParser.readExpressionList(jsonObject, key, JsonParser.doNotConvert(), validator, IS_STRING, logger, env, typeHelper);
    }

    @NonNull
    public static ExpressionList<String> readExpressionList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ListValidator<String> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readExpressionList(jsonObject, key, JsonParser.doNotConvert(), validator, IS_STRING, logger, env, TypeHelpersKt.TYPE_HELPER_STRING);
    }

    @NonNull
    public static <R, T> ExpressionList<T> readExpressionList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readExpressionList(jsonObject, key, converter, validator, JsonParser.alwaysValid(), logger, env, typeHelper);
    }

    @NonNull
    public static <T> ExpressionList<T> readExpressionList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ListValidator<T> validator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readExpressionList(jsonObject, key, JsonParser.doNotConvert(), validator, itemValidator, logger, env, typeHelper);
    }

    @Nullable
    public static <T> ExpressionList<T> readOptionalExpressionList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull ListValidator<T> validator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readOptionalExpressionList(jsonObject, key, JsonParser.doNotConvert(), validator, itemValidator, logger, env, typeHelper);
    }

    @Nullable
    public static <R, T> ExpressionList<T> readOptionalExpressionList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> validator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonParser.readExpressionList(jsonObject, key, converter, validator, itemValidator, logger, env, typeHelper, ErrorHandler.IGNORE);
    }

    @NonNull
    public static <R, T> ExpressionList<T> readExpressionList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> validator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        ExpressionList result = JsonParser.readExpressionList(jsonObject, key, converter, validator, itemValidator, logger, env, typeHelper, ErrorHandler.FAIL_FAST);
        if (result == null) {
            throw ParsingExceptionKt.invalidValue(key, jsonObject);
        }
        return result;
    }

    @Nullable
    private static <R, T> ExpressionList readExpressionList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> validator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper, @NonNull ErrorHandler errorHandler) {
        int i;
        JSONArray optJSONArray = jsonObject.optJSONArray(key);
        if (optJSONArray == null) {
            errorHandler.process(ParsingExceptionKt.missingValue(jsonObject, key));
            return null;
        }
        int length = optJSONArray.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!validator.isValid(emptyList)) {
                    logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return EMPTY_EXPRESSION_LIST;
                }
            }
            catch (ClassCastException castException) {
                logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return EMPTY_EXPRESSION_LIST;
            }
            return EMPTY_EXPRESSION_LIST;
        }
        ArrayList<Object> untypedList = new ArrayList<Object>(length);
        boolean containsExpressions = false;
        for (i = 0; i < length; ++i) {
            Object item;
            block18: {
                Object intermediate = JsonParser.optSafe(optJSONArray.opt(i));
                if (intermediate == null) continue;
                if (Expression.mayBeExpression(intermediate)) {
                    containsExpressions = true;
                    untypedList.add(new Expression.MutableExpression<R, T>(key + "[" + i + "]", intermediate.toString(), converter, itemValidator, logger, typeHelper, null));
                    continue;
                }
                try {
                    item = converter.invoke(intermediate);
                }
                catch (ClassCastException castException) {
                    logger.logError(ParsingExceptionKt.typeMismatch(optJSONArray, key, i, intermediate));
                    continue;
                }
                catch (Exception e) {
                    logger.logError(ParsingExceptionKt.invalidValue(optJSONArray, key, i, intermediate, e));
                    continue;
                }
                if (item == null) continue;
                try {
                    if (!itemValidator.isValid(item)) {
                        logger.logError(ParsingExceptionKt.invalidValue(optJSONArray, key, i, item));
                    }
                    break block18;
                }
                catch (ClassCastException castException) {
                    logger.logError(ParsingExceptionKt.typeMismatch(optJSONArray, key, i, item));
                }
                continue;
            }
            untypedList.add(item);
        }
        if (containsExpressions) {
            for (i = 0; i < untypedList.size(); ++i) {
                Object item = untypedList.get(i);
                if (item instanceof Expression) continue;
                untypedList.set(i, Expression.constant(item));
            }
            ArrayList<Object> list = untypedList;
            return new MutableExpressionList<T>(key, list, validator, env.getLogger());
        }
        ArrayList<Object> list = untypedList;
        try {
            if (!validator.isValid(list)) {
                errorHandler.process(ParsingExceptionKt.invalidValue(jsonObject, key, list));
                return null;
            }
        }
        catch (ClassCastException castException) {
            errorHandler.process(ParsingExceptionKt.typeMismatch(jsonObject, key, list));
            return null;
        }
        return new ConstantExpressionList(list);
    }

    @NonNull
    public static <T> List<T> readStrictList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ListValidator<T> listValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readStrictList(jsonObject, key, creator, listValidator, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <T> List<T> readStrictList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ListValidator<T> listValidator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        JSONArray optJSONArray = jsonObject.optJSONArray(key);
        if (optJSONArray == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        int length = optJSONArray.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!listValidator.isValid(emptyList)) {
                    logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return emptyList;
                }
            }
            catch (ClassCastException castException) {
                logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return emptyList;
            }
            return emptyList;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            JSONObject intermediate = JsonParser.optSafe(optJSONArray.optJSONObject(i));
            if (intermediate == null) {
                throw ParsingExceptionKt.missingValue(optJSONArray, key, i);
            }
            try {
                item = creator.invoke((Object)env, (Object)intermediate);
            }
            catch (ClassCastException castException) {
                throw ParsingExceptionKt.typeMismatch(optJSONArray, key, i, intermediate);
            }
            catch (Exception e) {
                throw ParsingExceptionKt.invalidValue(optJSONArray, key, i, intermediate, e);
            }
            if (item == null) {
                throw ParsingExceptionKt.invalidValue(optJSONArray, key, i, intermediate);
            }
            try {
                if (!itemValidator.isValid(item)) {
                    throw ParsingExceptionKt.invalidValue(optJSONArray, key, i, intermediate);
                }
            }
            catch (ClassCastException castException) {
                throw ParsingExceptionKt.typeMismatch(optJSONArray, key, i, item);
            }
            list.add(item);
        }
        try {
            if (!listValidator.isValid(list)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, list);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, list);
        }
        return list;
    }

    @NonNull
    public static <R, T> List<T> readStrictList(@NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> listValidator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger) {
        JSONArray optJSONArray = jsonObject.optJSONArray(key);
        if (optJSONArray == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        int length = optJSONArray.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!listValidator.isValid(emptyList)) {
                    logger.logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return emptyList;
                }
            }
            catch (ClassCastException castException) {
                logger.logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return emptyList;
            }
            return emptyList;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            JSONObject intermediate = JsonParser.optSafe(optJSONArray.optJSONObject(i));
            if (intermediate == null) {
                throw ParsingExceptionKt.missingValue(optJSONArray, key, i);
            }
            try {
                item = converter.invoke((Object)intermediate);
            }
            catch (ClassCastException castException) {
                throw ParsingExceptionKt.typeMismatch(optJSONArray, key, i, intermediate);
            }
            catch (Exception e) {
                throw ParsingExceptionKt.invalidValue(optJSONArray, key, i, intermediate, e);
            }
            if (item == null) {
                throw ParsingExceptionKt.invalidValue(optJSONArray, key, i, intermediate);
            }
            try {
                if (!itemValidator.isValid(item)) {
                    throw ParsingExceptionKt.invalidValue(optJSONArray, key, i, item);
                }
            }
            catch (ClassCastException castException) {
                throw ParsingExceptionKt.typeMismatch(optJSONArray, key, i, item);
            }
            list.add(item);
        }
        try {
            if (!listValidator.isValid(list)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, list);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, list);
        }
        return list;
    }

    @NonNull
    static <T> ValueValidator<T> alwaysValid() {
        return ALWAYS_VALID;
    }

    @NonNull
    static <T> ListValidator<T> alwaysValidList() {
        return ALWAYS_VALID_LIST;
    }

    @NonNull
    static <T> Function1<T, T> doNotConvert() {
        return AS_IS;
    }

    @Nullable
    private static <T> T optSafe(@Nullable T json) {
        if (json == null || json == JSONObject.NULL) {
            return null;
        }
        return json;
    }

    @Nullable
    private static Object optSafe(JSONObject json, String key) {
        Object value = json.opt(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value;
    }

    private static interface ErrorHandler {
        public static final ErrorHandler FAIL_FAST = e -> {
            throw e;
        };
        public static final ErrorHandler IGNORE = e -> {};

        public void process(ParsingException var1);
    }
}

