/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal.parser;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.div.internal.parser.JsonParser;
import com.yandex.div.internal.parser.JsonTemplateParserKt;
import com.yandex.div.internal.parser.ListValidator;
import com.yandex.div.internal.parser.TypeHelper;
import com.yandex.div.internal.parser.TypeHelpersKt;
import com.yandex.div.internal.parser.ValueValidator;
import com.yandex.div.internal.template.Field;
import com.yandex.div.internal.template.FieldKt;
import com.yandex.div.json.ParsingEnvironment;
import com.yandex.div.json.ParsingErrorLogger;
import com.yandex.div.json.ParsingException;
import com.yandex.div.json.expressions.Expression;
import com.yandex.div.json.expressions.ExpressionList;
import java.util.List;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonTemplateParser {
    private static final ValueValidator<String> IS_NOT_EMPTY = value -> !value.isEmpty();

    @NonNull
    public static <T> Field<T> readOptionalField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readOptionalField(json, key, overridable, fallback, JsonParser.doNotConvert(), JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <T> Field<T> readOptionalField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readOptionalField(json, key, overridable, fallback, JsonParser.doNotConvert(), validator, logger, env);
    }

    @NonNull
    public static <R, T> Field<T> readOptionalField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull Function1<R, T> converter, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readOptionalField(json, key, overridable, fallback, converter, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <R, T> Field<T> readOptionalField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull Function1<R, T> converter, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        T opt = JsonParser.readOptional(json, key, converter, validator, logger, env);
        if (opt != null) {
            return new Field.Value<T>(overridable, opt);
        }
        String reference = JsonTemplateParser.readReference(json, key, logger, env);
        if (reference != null) {
            return new Field.Reference(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <T> Field<T> readOptionalField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readOptionalField(json, key, overridable, fallback, creator, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <T> Field<T> readOptionalField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        T opt = JsonParser.readOptional(json, key, creator, validator, logger, env);
        if (opt != null) {
            return new Field.Value<T>(overridable, opt);
        }
        String reference = JsonTemplateParser.readReference(json, key, logger, env);
        if (reference != null) {
            return new Field.Reference(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <T> Field<T> readField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readField(json, key, overridable, fallback, JsonParser.doNotConvert(), JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <T> Field<T> readField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull ValueValidator<T> valueValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readField(json, key, overridable, fallback, JsonParser.doNotConvert(), valueValidator, logger, env);
    }

    @NonNull
    public static <R, T> Field<T> readField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull Function1<R, T> converter, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readField(json, key, overridable, fallback, converter, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <R, T> Field<T> readField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull Function1<R, T> converter, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        try {
            T value = JsonParser.read(json, key, converter, validator, logger, env);
            return new Field.Value<T>(overridable, value);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonTemplateParser.readReference(json, key, logger, env);
            Field<T> referenceOrFallback = JsonTemplateParser.referenceOrFallback(overridable, reference, fallback);
            if (referenceOrFallback != null) {
                return referenceOrFallback;
            }
            throw e;
        }
    }

    @NonNull
    public static <T> Field<T> readField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readField(json, key, overridable, fallback, creator, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <T> Field<T> readField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<T> fallback, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        try {
            T result = JsonParser.read(json, key, creator, validator, logger, env);
            return new Field.Value<T>(overridable, result);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonTemplateParser.readReference(json, key, logger, env);
            Field<T> referenceOrFallback = JsonTemplateParser.referenceOrFallback(overridable, reference, fallback);
            if (referenceOrFallback != null) {
                return referenceOrFallback;
            }
            throw e;
        }
    }

    @PublishedApi
    @Nullable
    public static String readReference(@NonNull JSONObject json, @NonNull String key, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonParser.readOptional(json, '$' + key, IS_NOT_EMPTY, logger, env);
    }

    @NonNull
    public static <R, T> Field<Expression<T>> readOptionalFieldWithExpression(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<Expression<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonTemplateParser.readOptionalFieldWithExpression(json, key, overridable, fallback, converter, JsonParser.alwaysValid(), logger, env, typeHelper);
    }

    @NonNull
    public static <T> Field<Expression<T>> readOptionalFieldWithExpression(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<Expression<T>> fallback, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonTemplateParser.readOptionalFieldWithExpression(json, key, overridable, fallback, JsonParser.doNotConvert(), JsonParser.alwaysValid(), logger, env, typeHelper);
    }

    @NonNull
    public static <T> Field<Expression<T>> readOptionalFieldWithExpression(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<Expression<T>> fallback, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonTemplateParser.readOptionalFieldWithExpression(json, key, overridable, fallback, JsonParser.doNotConvert(), validator, logger, env, typeHelper);
    }

    @NonNull
    public static <R, T> Field<Expression<T>> readOptionalFieldWithExpression(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<Expression<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        Expression<T> opt = JsonParser.readOptionalExpression(json, key, converter, validator, logger, env, null, typeHelper);
        if (opt != null) {
            return new Field.Value<Expression<T>>(overridable, opt);
        }
        String reference = JsonTemplateParser.readReference(json, key, logger, env);
        if (reference != null) {
            return new Field.Reference<Expression<T>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <R, T> Field<List<T>> readListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> listValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        try {
            List<T> opt = JsonParser.readList(json, key, converter, listValidator, JsonParser.alwaysValid(), logger, env);
            return new Field.Value<List<T>>(overridable, opt);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonTemplateParser.readReference(json, key, logger, env);
            Field<List<T>> result = JsonTemplateParser.referenceOrFallback(overridable, reference, fallback);
            if (result != null) {
                return result;
            }
            throw e;
        }
    }

    @NonNull
    public static <R, T> Field<ExpressionList<T>> readExpressionListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<ExpressionList<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> listValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        ExpressionList<T> opt = JsonParser.readOptionalExpressionList(json, key, converter, listValidator, JsonParser.alwaysValid(), logger, env, typeHelper);
        if (opt != null) {
            return new Field.Value<ExpressionList<T>>(overridable, opt);
        }
        String reference = JsonTemplateParser.readReference(json, key, logger, env);
        if (reference != null) {
            return new Field.Reference<ExpressionList<T>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <T> Field<ExpressionList<T>> readExpressionListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<ExpressionList<T>> fallback, @NonNull ListValidator<T> listValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonTemplateParser.readExpressionListField(json, key, overridable, fallback, JsonParser.doNotConvert(), listValidator, logger, env, typeHelper);
    }

    @NonNull
    public static <T> Field<ExpressionList<T>> readExpressionListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<ExpressionList<T>> fallback, @NonNull ListValidator<T> listValidator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        ExpressionList opt = JsonParser.readOptionalExpressionList(json, key, JsonParser.doNotConvert(), listValidator, itemValidator, logger, env, typeHelper);
        if (opt != null) {
            return new Field.Value(overridable, opt);
        }
        String reference = JsonTemplateParser.readReference(json, key, logger, env);
        if (reference != null) {
            return new Field.Reference<ExpressionList<T>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <R, T> Field<List<T>> readOptionalListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readOptionalListField(json, key, overridable, fallback, converter, JsonParser.alwaysValidList(), JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <R, T> Field<List<T>> readOptionalListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> listValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readOptionalListField(json, key, overridable, fallback, converter, listValidator, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <R, T> Field<List<T>> readOptionalListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> listValidator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        List<T> opt = JsonParser.readOptionalList(json, key, converter, listValidator, itemValidator, logger, env);
        if (opt != null) {
            return new Field.Value<List<T>>(overridable, opt);
        }
        String reference = JsonTemplateParser.readReference(json, key, logger, env);
        if (reference != null) {
            return new Field.Reference<List<T>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <R, T> Field<List<T>> readOptionalListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull Function2<ParsingEnvironment, R, T> creator, @NonNull ListValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        List<T> opt = JsonParser.readOptionalList(json, key, creator, validator, logger, env);
        if (opt != null) {
            return new Field.Value<List<T>>(overridable, opt);
        }
        String reference = JsonTemplateParser.readReference(json, key, logger, env);
        if (reference != null) {
            return new Field.Reference<List<T>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <T> Field<List<T>> readOptionalListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull ListValidator<T> validator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        List opt = JsonParser.readOptionalList(json, key, JsonParser.doNotConvert(), validator, itemValidator, logger, env);
        if (opt != null) {
            return new Field.Value(overridable, opt);
        }
        String reference = JsonTemplateParser.readReference(json, key, logger, env);
        if (reference != null) {
            return new Field.Reference<List<T>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <R, T> Field<ExpressionList<T>> readOptionalExpressionListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<ExpressionList<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> listValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonTemplateParser.readExpressionListField(json, key, overridable, fallback, converter, listValidator, logger, env, typeHelper);
    }

    @NonNull
    public static <T> Field<ExpressionList<T>> readOptionalExpressionListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<ExpressionList<T>> fallback, @NonNull ListValidator<T> listValidator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        ExpressionList opt = JsonParser.readOptionalExpressionList(json, key, JsonParser.doNotConvert(), listValidator, itemValidator, logger, env, typeHelper);
        if (opt != null) {
            return new Field.Value(overridable, opt);
        }
        String reference = JsonTemplateParser.readReference(json, key, logger, env);
        if (reference != null) {
            return new Field.Reference<ExpressionList<T>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <T> Field<List<T>> readStrictListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ListValidator<T> listValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readStrictListField(json, key, overridable, fallback, creator, listValidator, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <T> Field<List<T>> readListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ListValidator<T> listValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readListField(json, key, overridable, fallback, creator, listValidator, JsonParser.alwaysValid(), logger, env);
    }

    @NonNull
    public static <T> Field<List<T>> readListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ListValidator<T> listValidator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        try {
            List<T> opt = JsonParser.readList(json, key, creator, listValidator, itemValidator, logger, env);
            return new Field.Value<List<T>>(overridable, opt);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonTemplateParser.readReference(json, key, logger, env);
            Field<List<T>> result = JsonTemplateParser.referenceOrFallback(overridable, reference, fallback);
            if (result != null) {
                return result;
            }
            throw e;
        }
    }

    @NonNull
    public static <T> Field<List<T>> readStrictListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull Function2<ParsingEnvironment, JSONObject, T> creator, @NonNull ListValidator<T> listValidator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        try {
            List<T> opt = JsonParser.readStrictList(json, key, creator, listValidator, itemValidator, logger, env);
            return new Field.Value<List<T>>(overridable, opt);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonTemplateParser.readReference(json, key, logger, env);
            Field<List<T>> result = JsonTemplateParser.referenceOrFallback(overridable, reference, fallback);
            if (result != null) {
                return result;
            }
            throw e;
        }
    }

    @NonNull
    public static <R, T> Field<List<T>> readStrictListField(@NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ListValidator<T> listValidator, @NonNull ValueValidator<T> itemValidator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        try {
            List<T> opt = JsonParser.readStrictList(json, key, converter, listValidator, itemValidator, logger);
            return new Field.Value<List<T>>(overridable, opt);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonTemplateParser.readReference(json, key, logger, env);
            Field<List<T>> result = JsonTemplateParser.referenceOrFallback(overridable, reference, fallback);
            if (result != null) {
                return result;
            }
            throw e;
        }
    }

    @PublishedApi
    @Nullable
    public static <T> Field<T> referenceOrFallback(boolean overridable, @Nullable String reference, @Nullable Field<T> fallback) {
        if (reference != null) {
            return new Field.Reference(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return overridable ? Field.Companion.nullField(overridable) : null;
    }

    @NonNull
    public static <R, T> Field<Expression<T>> readFieldWithExpression(@NonNull JSONObject jsonObject, @NonNull String key, boolean overridable, @Nullable Field<Expression<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonTemplateParser.readFieldWithExpression(jsonObject, key, overridable, fallback, converter, JsonParser.alwaysValid(), logger, env, typeHelper);
    }

    @NonNull
    public static <T> Field<Expression<T>> readFieldWithExpression(@NonNull JSONObject jsonObject, @NonNull String key, boolean overridable, @Nullable Field<Expression<T>> fallback, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonTemplateParser.readFieldWithExpression(jsonObject, key, overridable, fallback, JsonParser.doNotConvert(), JsonParser.alwaysValid(), logger, env, typeHelper);
    }

    @NonNull
    public static <T> Field<Expression<T>> readFieldWithExpression(@NonNull JSONObject jsonObject, @NonNull String key, boolean overridable, @Nullable Field<Expression<T>> fallback, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        return JsonTemplateParser.readFieldWithExpression(jsonObject, key, overridable, fallback, JsonParser.doNotConvert(), validator, logger, env, typeHelper);
    }

    @NonNull
    public static Field<Expression<JSONArray>> readFieldWithExpression(@NonNull JSONObject jsonObject, @NonNull String key, boolean overridable, @Nullable Field<Expression<JSONArray>> fallback, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env) {
        return JsonTemplateParser.readFieldWithExpression(jsonObject, key, overridable, fallback, JsonParser.doNotConvert(), JsonParser.alwaysValid(), logger, env, TypeHelpersKt.TYPE_HELPER_JSON_ARRAY);
    }

    @NonNull
    public static <R, T> Field<Expression<T>> readFieldWithExpression(@NonNull JSONObject jsonObject, @NonNull String key, boolean overridable, @Nullable Field<Expression<T>> fallback, @NonNull Function1<R, T> converter, @NonNull ValueValidator<T> validator, @NonNull ParsingErrorLogger logger, @NonNull ParsingEnvironment env, @NonNull TypeHelper<T> typeHelper) {
        try {
            Expression<T> expression = JsonParser.readExpression(jsonObject, key, converter, validator, logger, env, typeHelper);
            return new Field.Value<Expression<T>>(overridable, expression);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            Field<Expression<T>> referenceOrFallback = JsonTemplateParser.referenceOrFallback(overridable, JsonTemplateParser.readReference(jsonObject, key, logger, env), fallback);
            if (referenceOrFallback != null) {
                return referenceOrFallback;
            }
            throw e;
        }
    }
}

