/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.json.expressions;

import com.yandex.div.core.Disposable;
import com.yandex.div.evaluable.Evaluable;
import com.yandex.div.evaluable.EvaluableException;
import com.yandex.div.internal.parser.TypeHelper;
import com.yandex.div.internal.parser.ValueValidator;
import com.yandex.div.json.ParsingErrorLogger;
import com.yandex.div.json.ParsingException;
import com.yandex.div.json.ParsingExceptionKt;
import com.yandex.div.json.expressions.ExpressionResolver;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u0016*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0003\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140\u0013H&J$\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u0012\u0010\u0004\u001a\u00020\u0002X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/yandex/div/json/expressions/Expression;", "T", "", "()V", "rawValue", "getRawValue", "()Ljava/lang/Object;", "equals", "", "other", "evaluate", "resolver", "Lcom/yandex/div/json/expressions/ExpressionResolver;", "(Lcom/yandex/div/json/expressions/ExpressionResolver;)Ljava/lang/Object;", "hashCode", "", "observe", "Lcom/yandex/div/core/Disposable;", "callback", "Lkotlin/Function1;", "", "observeAndGet", "Companion", "ConstantExpression", "MutableExpression", "div-json_release"})
public abstract class Expression<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<Object, Expression<?>> pool = new ConcurrentHashMap(1000);

    @NotNull
    public abstract T evaluate(@NotNull ExpressionResolver var1);

    @NotNull
    public abstract Disposable observe(@NotNull ExpressionResolver var1, @NotNull Function1<? super T, Unit> var2);

    @NotNull
    public Disposable observeAndGet(@NotNull ExpressionResolver resolver, @NotNull Function1<? super T, Unit> callback) {
        block2: {
            Object value;
            Object var4_3;
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            try {
                var4_3 = this.evaluate(resolver);
            }
            catch (ParsingException e) {
                var4_3 = null;
            }
            Object v0 = value = var4_3;
            if (v0 == null) break block2;
            Object it = v0;
            boolean bl = false;
            callback.invoke(it);
        }
        return this.observe(resolver, callback);
    }

    @NotNull
    public abstract Object getRawValue();

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Expression)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getRawValue(), (Object)((Expression)other).getRawValue());
    }

    public int hashCode() {
        return this.getRawValue().hashCode() * 16;
    }

    @JvmStatic
    @NotNull
    public static final <T> Expression<T> constant(@NotNull T value) {
        return Companion.constant(value);
    }

    @JvmStatic
    public static final boolean mayBeExpression(@Nullable Object value) {
        return Companion.mayBeExpression(value);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0005\"\b\b\u0001\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u0002H\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/yandex/div/json/expressions/Expression$Companion;", "", "()V", "pool", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/yandex/div/json/expressions/Expression;", "constant", "T", "value", "(Ljava/lang/Object;)Lcom/yandex/div/json/expressions/Expression;", "mayBeExpression", "", "div-json_release"})
    @SourceDebugExtension(value={"SMAP\nExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Expression.kt\ncom/yandex/div/json/expressions/Expression$Companion\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n73#2,2:213\n1#3:215\n*S KotlinDebug\n*F\n+ 1 Expression.kt\ncom/yandex/div/json/expressions/Expression$Companion\n*L\n202#1:213,2\n202#1:215\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> Expression<T> constant(@NotNull T value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            ConcurrentMap $this$getOrPut$iv = pool;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(value);
            if (object == null) {
                boolean bl = false;
                Expression default$iv = new ConstantExpression<T>(value);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(value, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Expression unTypedExpression = (Expression)object;
            Intrinsics.checkNotNull((Object)unTypedExpression, (String)"null cannot be cast to non-null type com.yandex.div.json.expressions.Expression<T of com.yandex.div.json.expressions.Expression.Companion.constant>");
            return unTypedExpression;
        }

        @JvmStatic
        public final boolean mayBeExpression(@Nullable Object value) {
            return value instanceof String && StringsKt.contains$default((CharSequence)((CharSequence)value), (CharSequence)"@{", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\n\u001a\u00028\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J$\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u0014\u0010\u0006\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/yandex/div/json/expressions/Expression$ConstantExpression;", "T", "", "Lcom/yandex/div/json/expressions/Expression;", "value", "(Ljava/lang/Object;)V", "rawValue", "getRawValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "evaluate", "resolver", "Lcom/yandex/div/json/expressions/ExpressionResolver;", "(Lcom/yandex/div/json/expressions/ExpressionResolver;)Ljava/lang/Object;", "observe", "Lcom/yandex/div/core/Disposable;", "callback", "Lkotlin/Function1;", "", "observeAndGet", "div-json_release"})
    public static final class ConstantExpression<T>
    extends Expression<T> {
        @NotNull
        private final T value;

        public ConstantExpression(@NotNull T value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.value = value;
        }

        @Override
        @NotNull
        public Object getRawValue() {
            T t = this.value;
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Any");
            return t;
        }

        @Override
        @NotNull
        public T evaluate(@NotNull ExpressionResolver resolver) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            return this.value;
        }

        @Override
        @NotNull
        public Disposable observe(@NotNull ExpressionResolver resolver, @NotNull Function1<? super T, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            return Disposable.NULL;
        }

        @Override
        @NotNull
        public Disposable observeAndGet(@NotNull ExpressionResolver resolver, @NotNull Function1<? super T, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            callback.invoke(this.value);
            return Disposable.NULL;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0001\u0010\u0001*\b\b\u0002\u0010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004Bw\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012*\u0010\b\u001a&\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u0002\u0018\u00010\tj\u0012\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u0002\u0018\u0001`\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00020\u0010\u0012\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u001a\u001a\u00028\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0014H\u0002J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\"0\tH\u0016J\u0015\u0010(\u001a\u00028\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010)\u001a\u00028\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dR2\u0010\b\u001a&\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u0002\u0018\u00010\tj\u0012\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u0002\u0018\u0001`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00018\u0002X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/yandex/div/json/expressions/Expression$MutableExpression;", "R", "T", "", "Lcom/yandex/div/json/expressions/Expression;", "expressionKey", "", "rawExpression", "converter", "Lkotlin/Function1;", "Lcom/yandex/div/internal/parser/Converter;", "validator", "Lcom/yandex/div/internal/parser/ValueValidator;", "logger", "Lcom/yandex/div/json/ParsingErrorLogger;", "typeHelper", "Lcom/yandex/div/internal/parser/TypeHelper;", "fieldDefaultValue", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lcom/yandex/div/internal/parser/ValueValidator;Lcom/yandex/div/json/ParsingErrorLogger;Lcom/yandex/div/internal/parser/TypeHelper;Lcom/yandex/div/json/expressions/Expression;)V", "evaluable", "Lcom/yandex/div/evaluable/Evaluable;", "lastValidValue", "Ljava/lang/Object;", "rawValue", "getRawValue", "()Ljava/lang/String;", "evaluate", "resolver", "Lcom/yandex/div/json/expressions/ExpressionResolver;", "(Lcom/yandex/div/json/expressions/ExpressionResolver;)Ljava/lang/Object;", "getEvaluable", "getVariablesName", "", "logError", "", "e", "Lcom/yandex/div/json/ParsingException;", "observe", "Lcom/yandex/div/core/Disposable;", "callback", "tryResolve", "tryResolveOrUseLast", "div-json_release"})
    public static final class MutableExpression<R, T>
    extends Expression<T> {
        @NotNull
        private final String expressionKey;
        @NotNull
        private final String rawExpression;
        @Nullable
        private final Function1<R, T> converter;
        @NotNull
        private final ValueValidator<T> validator;
        @NotNull
        private final ParsingErrorLogger logger;
        @NotNull
        private final TypeHelper<T> typeHelper;
        @Nullable
        private final Expression<T> fieldDefaultValue;
        @NotNull
        private final String rawValue;
        @Nullable
        private Evaluable evaluable;
        @Nullable
        private T lastValidValue;

        public MutableExpression(@NotNull String expressionKey, @NotNull String rawExpression, @Nullable Function1<? super R, ? extends T> converter, @NotNull ValueValidator<T> validator, @NotNull ParsingErrorLogger logger, @NotNull TypeHelper<T> typeHelper, @Nullable Expression<T> fieldDefaultValue) {
            Intrinsics.checkNotNullParameter((Object)expressionKey, (String)"expressionKey");
            Intrinsics.checkNotNullParameter((Object)rawExpression, (String)"rawExpression");
            Intrinsics.checkNotNullParameter(validator, (String)"validator");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter(typeHelper, (String)"typeHelper");
            this.expressionKey = expressionKey;
            this.rawExpression = rawExpression;
            this.converter = converter;
            this.validator = validator;
            this.logger = logger;
            this.typeHelper = typeHelper;
            this.fieldDefaultValue = fieldDefaultValue;
            this.rawValue = this.rawExpression;
        }

        public /* synthetic */ MutableExpression(String string, String string2, Function1 function1, ValueValidator valueValidator, ParsingErrorLogger parsingErrorLogger, TypeHelper typeHelper, Expression expression, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x40) != 0) {
                expression = null;
            }
            this(string, string2, function1, valueValidator, parsingErrorLogger, typeHelper, expression);
        }

        @Override
        @NotNull
        public String getRawValue() {
            return this.rawValue;
        }

        @Override
        @NotNull
        public T evaluate(@NotNull ExpressionResolver resolver) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            return this.tryResolveOrUseLast(resolver);
        }

        @Override
        @NotNull
        public Disposable observe(@NotNull ExpressionResolver resolver, @NotNull Function1<? super T, Unit> callback) {
            List<String> list;
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            try {
                list = this.getVariablesName();
            }
            catch (Exception e) {
                this.logError(ParsingExceptionKt.resolveFailed(this.expressionKey, this.rawExpression, e), resolver);
                return Disposable.NULL;
            }
            List<String> variablesName = list;
            if (variablesName.isEmpty()) {
                return Disposable.NULL;
            }
            return resolver.subscribeToExpression(this.rawExpression, variablesName, (Function0<Unit>)((Function0)new Function0<Unit>(callback, this, resolver){
                final /* synthetic */ Function1<T, Unit> $callback;
                final /* synthetic */ MutableExpression<R, T> this$0;
                final /* synthetic */ ExpressionResolver $resolver;
                {
                    this.$callback = $callback;
                    this.this$0 = $receiver;
                    this.$resolver = $resolver;
                    super(0);
                }

                public final void invoke() {
                    this.$callback.invoke(this.this$0.evaluate(this.$resolver));
                }
            }));
        }

        @NotNull
        public final List<String> getVariablesName() {
            return this.getEvaluable().getVariables();
        }

        private final T tryResolveOrUseLast(ExpressionResolver resolver) {
            try {
                T newValue = this.tryResolve(resolver);
                this.lastValidValue = newValue;
                return newValue;
            }
            catch (ParsingException e) {
                this.logError(e, resolver);
                T t = this.lastValidValue;
                if (t != null) {
                    T it = t;
                    boolean bl = false;
                    return it;
                }
                try {
                    Expression<T> expression = this.fieldDefaultValue;
                    if (expression != null && (expression = expression.evaluate(resolver)) != null) {
                        Expression<T> it = expression;
                        boolean bl = false;
                        this.lastValidValue = it;
                        return (T)it;
                    }
                }
                catch (ParsingException e2) {
                    this.logError(e2, resolver);
                    throw e2;
                }
                return this.typeHelper.getTypeDefault();
            }
        }

        private final void logError(ParsingException e, ExpressionResolver resolver) {
            this.logger.logError(e);
            resolver.notifyResolveFailed(e);
        }

        private final T tryResolve(ExpressionResolver resolver) {
            T t = resolver.get(this.expressionKey, this.rawExpression, this.getEvaluable(), this.converter, this.validator, this.typeHelper, this.logger);
            if (t == null) {
                throw ParsingExceptionKt.resolveFailed$default(this.expressionKey, this.rawExpression, null, 4, null);
            }
            T value = t;
            if (!this.typeHelper.isTypeValid(value)) {
                throw ParsingExceptionKt.typeMismatch$default(this.expressionKey, this.rawExpression, value, null, 8, null);
            }
            return value;
        }

        private final Evaluable getEvaluable() {
            Evaluable evaluable = this.evaluable;
            if (evaluable == null) {
                Evaluable evaluable2;
                try {
                    Evaluable it = evaluable2 = Evaluable.Companion.lazy(this.rawExpression);
                    boolean bl = false;
                    this.evaluable = it;
                }
                catch (EvaluableException e) {
                    throw ParsingExceptionKt.resolveFailed(this.expressionKey, this.rawExpression, e);
                }
                evaluable = evaluable2;
            }
            return evaluable;
        }
    }
}

