/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.state.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.yandex.div.internal.Assert;
import com.yandex.div.state.db.DivStateDao;
import com.yandex.div.state.db.DivStateEntity;
import com.yandex.div.state.db.PathToState;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\b*\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\n \u001c*\u0004\u0018\u00010\f0\f*\u00020\u001aH\u0002J\u0014\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\f0\f*\u00020\u001aH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\f*\u00020\u001aH\u0002J\u001a\u0010\u001f\u001a\u00020\b*\u00020\u00032\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/yandex/div/state/db/DivStateDaoImpl;", "Lcom/yandex/div/state/db/DivStateDao;", "writableDatabase", "Landroid/database/sqlite/SQLiteDatabase;", "(Landroid/database/sqlite/SQLiteDatabase;)V", "upsertStatement", "Landroid/database/sqlite/SQLiteStatement;", "deleteAll", "", "deleteAllExcept", "cardIds", "", "", "deleteByCardId", "cardId", "deleteCardRootState", "deleteModifiedBefore", "timestamp", "", "getRootStateId", "getStates", "Lcom/yandex/div/state/db/PathToState;", "updateState", "state", "Lcom/yandex/div/state/db/DivStateEntity;", "applyAndClose", "Landroid/database/Cursor;", "getPath", "kotlin.jvm.PlatformType", "getStateId", "getStateIdOrNull", "inTransaction", "block", "Lkotlin/Function0;", "div-states_release"})
@SourceDebugExtension(value={"SMAP\nDivStateDaoImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DivStateDaoImpl.kt\ncom/yandex/div/state/db/DivStateDaoImpl\n+ 2 Cursor.kt\nandroidx/core/database/CursorKt\n*L\n1#1,128:1\n112#2:129\n*S KotlinDebug\n*F\n+ 1 DivStateDaoImpl.kt\ncom/yandex/div/state/db/DivStateDaoImpl\n*L\n112#1:129\n*E\n"})
public final class DivStateDaoImpl
implements DivStateDao {
    @NotNull
    private final SQLiteDatabase writableDatabase;
    @NotNull
    private final SQLiteStatement upsertStatement;

    public DivStateDaoImpl(@NotNull SQLiteDatabase writableDatabase) {
        Intrinsics.checkNotNullParameter((Object)writableDatabase, (String)"writableDatabase");
        this.writableDatabase = writableDatabase;
        if (this.writableDatabase.isReadOnly()) {
            Assert.fail((String)(this.getClass().getName() + " require writable database!"));
        }
        SQLiteStatement sQLiteStatement = this.writableDatabase.compileStatement("INSERT OR REPLACE INTO `div_card_states` (`card_id`,`path`,`state_id`,`modification_time`) VALUES (?,?,?,?)");
        Intrinsics.checkNotNullExpressionValue((Object)sQLiteStatement, (String)"writableDatabase.compile\u2026QL_UPSERT_QUERY_TEMPLATE)");
        this.upsertStatement = sQLiteStatement;
    }

    @Override
    @NotNull
    public List<PathToState> getStates(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        List states = new ArrayList();
        this.inTransaction(this.writableDatabase, (Function0<Unit>)((Function0)new Function0<Unit>(this, cardId, (List<PathToState>)states){
            final /* synthetic */ DivStateDaoImpl this$0;
            final /* synthetic */ String $cardId;
            final /* synthetic */ List<PathToState> $states;
            {
                this.this$0 = $receiver;
                this.$cardId = $cardId;
                this.$states = $states;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object = new String[]{this.$cardId};
                Cursor cursor = DivStateDaoImpl.access$getWritableDatabase$p(this.this$0).rawQuery("SELECT path, state_id FROM div_card_states WHERE card_id=?", object);
                object = (Closeable)cursor;
                List<PathToState> list = this.$states;
                DivStateDaoImpl divStateDaoImpl = this.this$0;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl = false;
                    while (cursor.moveToNext()) {
                        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"cursor");
                        String string = DivStateDaoImpl.access$getPath(divStateDaoImpl, cursor);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getPath()");
                        String string2 = DivStateDaoImpl.access$getStateId(divStateDaoImpl, cursor);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cursor.getStateId()");
                        list.add(new PathToState(string, string2));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }));
        return states;
    }

    @Override
    public void updateState(@NotNull DivStateEntity state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.inTransaction(this.writableDatabase, (Function0<Unit>)((Function0)new Function0<Unit>(this, state){
            final /* synthetic */ DivStateDaoImpl this$0;
            final /* synthetic */ DivStateEntity $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(0);
            }

            public final void invoke() {
                DivStateDaoImpl.access$getUpsertStatement$p(this.this$0).bindString(1, this.$state.getCardId());
                DivStateDaoImpl.access$getUpsertStatement$p(this.this$0).bindString(2, this.$state.getPath());
                DivStateDaoImpl.access$getUpsertStatement$p(this.this$0).bindString(3, this.$state.getStateId());
                DivStateDaoImpl.access$getUpsertStatement$p(this.this$0).bindString(4, String.valueOf(this.$state.getModificationTime()));
                DivStateDaoImpl.access$getUpsertStatement$p(this.this$0).execute();
                DivStateDaoImpl.access$getUpsertStatement$p(this.this$0).clearBindings();
            }
        }));
    }

    @Override
    public void deleteAll() {
        this.inTransaction(this.writableDatabase, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DivStateDaoImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean $i$f$emptyArray = false;
                DivStateDaoImpl.access$getWritableDatabase$p(this.this$0).rawQuery("DELETE FROM div_card_states", new String[0]).close();
            }
        }));
    }

    @Override
    public void deleteByCardId(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        this.inTransaction(this.writableDatabase, (Function0<Unit>)((Function0)new Function0<Unit>(this, cardId){
            final /* synthetic */ DivStateDaoImpl this$0;
            final /* synthetic */ String $cardId;
            {
                this.this$0 = $receiver;
                this.$cardId = $cardId;
                super(0);
            }

            public final void invoke() {
                String[] stringArray = new String[]{this.$cardId};
                Cursor cursor = DivStateDaoImpl.access$getWritableDatabase$p(this.this$0).rawQuery("DELETE FROM div_card_states WHERE card_id=?", stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"writableDatabase.rawQuer\u2026yOf(cardId)\n            )");
                DivStateDaoImpl.access$applyAndClose(this.this$0, cursor);
            }
        }));
    }

    @Override
    public void deleteAllExcept(@NotNull List<String> cardIds) {
        Intrinsics.checkNotNullParameter(cardIds, (String)"cardIds");
        this.inTransaction(this.writableDatabase, (Function0<Unit>)((Function0)new Function0<Unit>(cardIds, this){
            final /* synthetic */ List<String> $cardIds;
            final /* synthetic */ DivStateDaoImpl this$0;
            {
                this.$cardIds = $cardIds;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                int n = 0;
                int n2 = this.$cardIds.size();
                Object[] objectArray = new String[n2];
                while (n < n2) {
                    int n3 = n++;
                    objectArray[n3] = "?";
                }
                String sqlInClauseTemplate = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                SQLiteDatabase sQLiteDatabase = DivStateDaoImpl.access$getWritableDatabase$p(this.this$0);
                String string = "DELETE FROM div_card_states WHERE card_id NOT IN (%s)";
                objectArray = new Object[]{sqlInClauseTemplate};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                Collection $this$toTypedArray$iv = this.$cardIds;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Cursor cursor = sQLiteDatabase.rawQuery(string2, thisCollection$iv.toArray(new String[0]));
                Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"writableDatabase.rawQuer\u2026  cardIds.toTypedArray())");
                DivStateDaoImpl.access$applyAndClose(this.this$0, cursor);
            }
        }));
    }

    @Override
    public void deleteModifiedBefore(long timestamp) {
        this.inTransaction(this.writableDatabase, (Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ DivStateDaoImpl this$0;
            final /* synthetic */ long $timestamp;
            {
                this.this$0 = $receiver;
                this.$timestamp = $timestamp;
                super(0);
            }

            public final void invoke() {
                String[] stringArray = new String[]{String.valueOf(this.$timestamp)};
                Cursor cursor = DivStateDaoImpl.access$getWritableDatabase$p(this.this$0).rawQuery("DELETE FROM div_card_states WHERE modification_time < ?", stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"writableDatabase.rawQuer\u2026toString())\n            )");
                DivStateDaoImpl.access$applyAndClose(this.this$0, cursor);
            }
        }));
    }

    @Override
    public void deleteCardRootState(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        this.inTransaction(this.writableDatabase, (Function0<Unit>)((Function0)new Function0<Unit>(this, cardId){
            final /* synthetic */ DivStateDaoImpl this$0;
            final /* synthetic */ String $cardId;
            {
                this.this$0 = $receiver;
                this.$cardId = $cardId;
                super(0);
            }

            public final void invoke() {
                String[] stringArray = new String[]{this.$cardId};
                Cursor cursor = DivStateDaoImpl.access$getWritableDatabase$p(this.this$0).rawQuery("DELETE FROM div_card_states WHERE card_id=? AND path='/'", stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"writableDatabase.rawQuer\u2026yOf(cardId)\n            )");
                DivStateDaoImpl.access$applyAndClose(this.this$0, cursor);
            }
        }));
    }

    @Override
    @Nullable
    public String getRootStateId(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Ref.ObjectRef stateId = new Ref.ObjectRef();
        this.inTransaction(this.writableDatabase, (Function0<Unit>)((Function0)new Function0<Unit>(this, cardId, (Ref.ObjectRef<String>)stateId){
            final /* synthetic */ DivStateDaoImpl this$0;
            final /* synthetic */ String $cardId;
            final /* synthetic */ Ref.ObjectRef<String> $stateId;
            {
                this.this$0 = $receiver;
                this.$cardId = $cardId;
                this.$stateId = $stateId;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object = new String[]{this.$cardId};
                Cursor cursor = DivStateDaoImpl.access$getWritableDatabase$p(this.this$0).rawQuery("SELECT state_id FROM div_card_states WHERE card_id=? AND path='/'", object);
                object = (Closeable)cursor;
                Ref.ObjectRef<String> objectRef = this.$stateId;
                DivStateDaoImpl divStateDaoImpl = this.this$0;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl = false;
                    if (cursor.moveToNext()) {
                        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"cursor");
                        objectRef.element = DivStateDaoImpl.access$getStateIdOrNull(divStateDaoImpl, cursor);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }));
        return (String)stateId.element;
    }

    private final String getPath(Cursor $this$getPath) {
        return $this$getPath.getString($this$getPath.getColumnIndexOrThrow("path"));
    }

    private final String getStateId(Cursor $this$getStateId) {
        return $this$getStateId.getString($this$getStateId.getColumnIndexOrThrow("state_id"));
    }

    /*
     * WARNING - void declaration
     */
    private final String getStateIdOrNull(Cursor $this$getStateIdOrNull) {
        void $this$getStringOrNull$iv;
        Cursor cursor = $this$getStateIdOrNull;
        int index$iv = $this$getStateIdOrNull.getColumnIndexOrThrow("state_id");
        boolean $i$f$getStringOrNull = false;
        return $this$getStringOrNull$iv.isNull(index$iv) ? null : $this$getStringOrNull$iv.getString(index$iv);
    }

    private final void applyAndClose(Cursor $this$applyAndClose) {
        $this$applyAndClose.moveToLast();
        $this$applyAndClose.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void inTransaction(SQLiteDatabase $this$inTransaction, Function0<Unit> block) {
        $this$inTransaction.beginTransaction();
        try {
            block.invoke();
            $this$inTransaction.setTransactionSuccessful();
        }
        finally {
            $this$inTransaction.endTransaction();
        }
    }

    public static final /* synthetic */ SQLiteDatabase access$getWritableDatabase$p(DivStateDaoImpl $this) {
        return $this.writableDatabase;
    }

    public static final /* synthetic */ String access$getPath(DivStateDaoImpl $this, Cursor $receiver) {
        return $this.getPath($receiver);
    }

    public static final /* synthetic */ String access$getStateId(DivStateDaoImpl $this, Cursor $receiver) {
        return $this.getStateId($receiver);
    }

    public static final /* synthetic */ SQLiteStatement access$getUpsertStatement$p(DivStateDaoImpl $this) {
        return $this.upsertStatement;
    }

    public static final /* synthetic */ void access$applyAndClose(DivStateDaoImpl $this, Cursor $receiver) {
        $this.applyAndClose($receiver);
    }

    public static final /* synthetic */ String access$getStateIdOrNull(DivStateDaoImpl $this, Cursor $receiver) {
        return $this.getStateIdOrNull($receiver);
    }
}

