/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import androidx.annotation.WorkerThread;
import com.yandex.div.core.annotations.PublicApi;
import com.yandex.div.storage.DivTemplateStorage;
import com.yandex.div.storage.db.DatabaseOpenHelper;
import com.yandex.div.storage.db.TemplateDao;
import com.yandex.div.storage.db.TemplateDaoImpl;
import com.yandex.div.storage.db.TemplateUsageDao;
import com.yandex.div.storage.db.TemplateUsageDaoImpl;
import com.yandex.div.storage.entity.Template;
import com.yandex.div.storage.entity.TemplateUsage;
import java.io.Closeable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0006H\u0017J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001f0\u001eH\u0007J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u001c\u001a\u00020\u0006H\u0017J-\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001f0\u001e2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060#\"\u00020\u0006H\u0017\u00a2\u0006\u0002\u0010$J$\u0010%\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00062\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001f0\u001eH\u0017J\u001b\u0010'\u001a\u00020\u0019*\u00020\t2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190)H\u0082\bR\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lcom/yandex/div/storage/DivDatabaseStorage;", "Lcom/yandex/div/storage/DivTemplateStorage;", "Ljava/io/Closeable;", "context", "Landroid/content/Context;", "databaseName", "", "(Landroid/content/Context;Ljava/lang/String;)V", "database", "Landroid/database/sqlite/SQLiteDatabase;", "getDatabase", "()Landroid/database/sqlite/SQLiteDatabase;", "database$delegate", "Lkotlin/Lazy;", "templateDao", "Lcom/yandex/div/storage/db/TemplateDao;", "getTemplateDao", "()Lcom/yandex/div/storage/db/TemplateDao;", "templateDao$delegate", "templateUsageDao", "Lcom/yandex/div/storage/db/TemplateUsageDao;", "getTemplateUsageDao", "()Lcom/yandex/div/storage/db/TemplateUsageDao;", "templateUsageDao$delegate", "clear", "", "close", "deleteTemplates", "cardId", "readAllTemplates", "", "", "readTemplates", "readTemplatesByIds", "templateId", "", "([Ljava/lang/String;)Ljava/util/Map;", "writeTemplates", "templates", "inTransaction", "block", "Lkotlin/Function0;", "div-storage_release"})
@PublicApi
@SourceDebugExtension(value={"SMAP\nDivDatabaseStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DivDatabaseStorage.kt\ncom/yandex/div/storage/DivDatabaseStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,95:1\n86#1,3:114\n89#1,5:119\n86#1,8:124\n86#1,8:132\n1179#2,2:96\n1253#2,4:98\n1179#2,2:102\n1253#2,4:104\n1179#2,2:108\n1253#2,4:110\n215#3,2:117\n*S KotlinDebug\n*F\n+ 1 DivDatabaseStorage.kt\ncom/yandex/div/storage/DivDatabaseStorage\n*L\n55#1:114,3\n55#1:119,5\n67#1:124,8\n75#1:132,8\n38#1:96,2\n38#1:98,4\n44#1:102,2\n44#1:104,4\n50#1:108,2\n50#1:110,4\n57#1:117,2\n*E\n"})
public final class DivDatabaseStorage
implements DivTemplateStorage,
Closeable {
    @NotNull
    private final Lazy database$delegate;
    @NotNull
    private final Lazy templateDao$delegate;
    @NotNull
    private final Lazy templateUsageDao$delegate;

    @JvmOverloads
    public DivDatabaseStorage(@NotNull Context context, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        this.database$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SQLiteDatabase>(context, databaseName){
            final /* synthetic */ Context $context;
            final /* synthetic */ String $databaseName;
            {
                this.$context = $context;
                this.$databaseName = $databaseName;
                super(0);
            }

            public final SQLiteDatabase invoke() {
                return new DatabaseOpenHelper(this.$context, this.$databaseName).getWritableDatabase();
            }
        }));
        this.templateDao$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TemplateDaoImpl>(this){
            final /* synthetic */ DivDatabaseStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TemplateDaoImpl invoke() {
                return new TemplateDaoImpl(DivDatabaseStorage.access$getDatabase(this.this$0));
            }
        }));
        this.templateUsageDao$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TemplateUsageDaoImpl>(this){
            final /* synthetic */ DivDatabaseStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TemplateUsageDaoImpl invoke() {
                return new TemplateUsageDaoImpl(DivDatabaseStorage.access$getDatabase(this.this$0));
            }
        }));
    }

    public /* synthetic */ DivDatabaseStorage(Context context, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "div.db";
        }
        this(context, string);
    }

    private final SQLiteDatabase getDatabase() {
        Lazy lazy = this.database$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-database>(...)");
        return (SQLiteDatabase)object;
    }

    private final TemplateDao getTemplateDao() {
        Lazy lazy = this.templateDao$delegate;
        return (TemplateDao)lazy.getValue();
    }

    private final TemplateUsageDao getTemplateUsageDao() {
        Lazy lazy = this.templateUsageDao$delegate;
        return (TemplateUsageDao)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public final Map<String, byte[]> readAllTemplates() {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = this.getTemplateDao().getAllTemplates();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Template template = (Template)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)template.getId(), (Object)template.getData());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    @NotNull
    public Map<String, byte[]> readTemplates(@NotNull String cardId) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Iterable $this$associate$iv = this.getTemplateDao().getTemplates(cardId);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Template template = (Template)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)template.getId(), (Object)template.getData());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    @NotNull
    public Map<String, byte[]> readTemplatesByIds(String ... templateId) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        Iterable $this$associate$iv = this.getTemplateDao().getTemplatesByIds(ArraysKt.toList((Object[])templateId));
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Template template = (Template)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)template.getId(), (Object)template.getData());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void writeTemplates(@NotNull String cardId, @NotNull Map<String, byte[]> templates) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter(templates, (String)"templates");
        DivDatabaseStorage divDatabaseStorage = this;
        SQLiteDatabase $this$inTransaction$iv = this.getDatabase();
        boolean $i$f$inTransaction = false;
        $this$inTransaction$iv.beginTransaction();
        try {
            boolean bl = false;
            this.getTemplateUsageDao().deleteTemplateUsages(cardId);
            Map<String, byte[]> $this$forEach$iv = templates;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, byte[]>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, byte[]> element$iv;
                Map.Entry<String, byte[]> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String templateId = entry.getKey();
                byte[] templateData = entry.getValue();
                this.getTemplateDao().insertTemplate(new Template(templateId, templateData));
                this.getTemplateUsageDao().insertTemplateUsage(new TemplateUsage(cardId, templateId));
            }
            this.getTemplateDao().deleteUnusedTemplates();
            $this$inTransaction$iv.setTransactionSuccessful();
        }
        finally {
            $this$inTransaction$iv.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void deleteTemplates(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        DivDatabaseStorage divDatabaseStorage = this;
        SQLiteDatabase $this$inTransaction$iv = this.getDatabase();
        boolean $i$f$inTransaction = false;
        $this$inTransaction$iv.beginTransaction();
        try {
            boolean bl = false;
            this.getTemplateUsageDao().deleteTemplateUsages(cardId);
            this.getTemplateDao().deleteUnusedTemplates();
            $this$inTransaction$iv.setTransactionSuccessful();
        }
        finally {
            $this$inTransaction$iv.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void clear() {
        DivDatabaseStorage divDatabaseStorage = this;
        SQLiteDatabase $this$inTransaction$iv = this.getDatabase();
        boolean $i$f$inTransaction = false;
        $this$inTransaction$iv.beginTransaction();
        try {
            boolean bl = false;
            this.getTemplateDao().deleteAllTemplates();
            this.getTemplateUsageDao().deleteAllTemplateUsages();
            $this$inTransaction$iv.setTransactionSuccessful();
        }
        finally {
            $this$inTransaction$iv.endTransaction();
        }
    }

    @Override
    public void close() {
        this.getDatabase().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void inTransaction(SQLiteDatabase $this$inTransaction, Function0<Unit> block) {
        boolean $i$f$inTransaction = false;
        $this$inTransaction.beginTransaction();
        try {
            block.invoke();
            $this$inTransaction.setTransactionSuccessful();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$inTransaction.endTransaction();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @JvmOverloads
    public DivDatabaseStorage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    public static final /* synthetic */ SQLiteDatabase access$getDatabase(DivDatabaseStorage $this) {
        return $this.getDatabase();
    }
}

