/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteStatement;
import androidx.annotation.AnyThread;
import androidx.annotation.VisibleForTesting;
import com.yandex.div.internal.Assert;
import com.yandex.div.internal.KAssert;
import com.yandex.div.storage.DivDataRepository;
import com.yandex.div.storage.DivStorage;
import com.yandex.div.storage.DivStorageErrorException;
import com.yandex.div.storage.DivStorageImpl;
import com.yandex.div.storage.RawDataAndMetadata;
import com.yandex.div.storage.database.DatabaseOpenHelper;
import com.yandex.div.storage.database.DatabaseOpenHelperProvider;
import com.yandex.div.storage.database.ExecutionResult;
import com.yandex.div.storage.database.Migration;
import com.yandex.div.storage.database.ReadState;
import com.yandex.div.storage.database.SingleTransactionDataSavePerformer;
import com.yandex.div.storage.database.StorageException;
import com.yandex.div.storage.database.StorageStatement;
import com.yandex.div.storage.database.StorageStatementExecutor;
import com.yandex.div.storage.database.StorageStatements;
import com.yandex.div.storage.rawjson.RawJson;
import com.yandex.div.storage.templates.RawTemplateData;
import com.yandex.div.storage.templates.Template;
import com.yandex.div.storage.util.SqlExtensionsKt;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000 h2\u00020\u0001:\u0003hijB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0013J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070 2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020$0#H\u0013J\"\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070 2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020$0#H\u0013J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0017J+\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u00072\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070/\"\u00020\u0007H\u0013\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0017J\u0018\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007H\u0016J\u0010\u00105\u001a\u00020$2\u0006\u00106\u001a\u00020\u0007H\u0016J*\u00107\u001a\b\u0012\u0004\u0012\u000209082\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0017J\u0010\u0010<\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0017J \u0010=\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010>\u001a\u00020\u00112\u0006\u0010?\u001a\u00020\u0011H\u0017J\u001c\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001e082\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0017J!\u0010A\u001a\u00020B2\u0017\u0010C\u001a\u0013\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020D0#\u00a2\u0006\u0002\bEH\u0013J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020G08H\u0016J\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020I082\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0017J\u001c\u0010K\u001a\u00020L2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020$0#H\u0017J\n\u0010M\u001a\u0004\u0018\u00010,H\u0017J\n\u0010N\u001a\u0004\u0018\u00010,H\u0017J\u001c\u0010O\u001a\u00020L2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020$0#H\u0017J4\u0010P\u001a\u00020Q2\u0006\u00104\u001a\u00020\u00072\f\u0010R\u001a\b\u0012\u0004\u0012\u00020&0\u001d2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u001d2\u0006\u0010U\u001a\u00020VH\u0017J\u001e\u0010W\u001a\u00020Q2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010U\u001a\u00020VH\u0017J\u001c\u0010Y\u001a\u0004\u0018\u000109*\u00020D2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0012J\u0012\u0010]\u001a\b\u0012\u0004\u0012\u00020G0\u001d*\u00020DH\u0012J\u0012\u0010^\u001a\b\u0012\u0004\u0012\u00020I0\u001d*\u00020DH\u0012J\u0014\u0010_\u001a\u00020\u0011*\u00020D2\u0006\u0010`\u001a\u00020\u0007H\u0012J\f\u0010a\u001a\u00020b*\u00020cH\u0012J$\u0010d\u001a\u00020,*\u00060ej\u0002`f2\u0006\u0010-\u001a\u00020\u00072\n\b\u0002\u0010g\u001a\u0004\u0018\u00010\u0007H\u0012R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0004\u0012\u00020\r0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u00020\u00178\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006k"}, d2={"Lcom/yandex/div/storage/DivStorageImpl;", "Lcom/yandex/div/storage/DivStorage;", "context", "Landroid/content/Context;", "openHelperProvider", "Lcom/yandex/div/storage/database/DatabaseOpenHelperProvider;", "databaseNamePrefix", "", "(Landroid/content/Context;Lcom/yandex/div/storage/database/DatabaseOpenHelperProvider;Ljava/lang/String;)V", "dataSaveUseCase", "Lcom/yandex/div/storage/database/SingleTransactionDataSavePerformer;", "dbName", "defaultDropAllMigration", "Lcom/yandex/div/storage/database/Migration;", "migrations", "", "Lkotlin/Pair;", "", "getMigrations", "()Ljava/util/Map;", "openHelper", "Lcom/yandex/div/storage/database/DatabaseOpenHelper;", "statementExecutor", "Lcom/yandex/div/storage/database/StorageStatementExecutor;", "getStatementExecutor$annotations", "()V", "getStatementExecutor", "()Lcom/yandex/div/storage/database/StorageStatementExecutor;", "collectsRawJsons", "", "Lcom/yandex/div/storage/rawjson/RawJson;", "rawJsonIds", "", "collectsRawJsonsIdsFor", "predicate", "Lkotlin/Function1;", "", "collectsRecordsFor", "Lcom/yandex/div/storage/RawDataAndMetadata;", "createTables", "", "db", "Lcom/yandex/div/storage/database/DatabaseOpenHelper$Database;", "deleteTablesTransaction", "Lcom/yandex/div/storage/DivStorageErrorException;", "actionDesc", "queries", "", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/yandex/div/storage/DivStorageErrorException;", "dropTables", "isCardExists", "id", "groupId", "isTemplateExists", "templateHash", "loadData", "Lcom/yandex/div/storage/DivStorage$LoadDataResult;", "Lcom/yandex/div/storage/DivStorage$RestoredRawData;", "ids", "idsToExclude", "onCreate", "onUpgrade", "oldVersion", "newVersion", "readRawJsons", "readStateFor", "Lcom/yandex/div/storage/database/ReadState;", "func", "Landroid/database/Cursor;", "Lkotlin/ExtensionFunctionType;", "readTemplateReferences", "Lcom/yandex/div/storage/DivStorage$TemplateReference;", "readTemplates", "Lcom/yandex/div/storage/templates/RawTemplateData;", "templateHashes", "remove", "Lcom/yandex/div/storage/DivStorage$RemoveResult;", "removeAllCards", "removeAllTemplates", "removeRawJsons", "saveData", "Lcom/yandex/div/storage/database/ExecutionResult;", "divs", "templatesByHash", "Lcom/yandex/div/storage/templates/Template;", "actionOnError", "Lcom/yandex/div/storage/DivDataRepository$ActionOnError;", "saveRawJsons", "rawJsons", "getRestoredRawData", "exceptions", "", "Lcom/yandex/div/storage/database/StorageException;", "getTemplateReferences", "getTemplates", "indexOf", "columnName", "toJSONObject", "Lorg/json/JSONObject;", "", "toStorageException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cardId", "Companion", "CursorDrivenRawDataAndMetadata", "CursorDrivenRawJson", "div-storage_release"})
@SourceDebugExtension(value={"SMAP\nDivStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DivStorageImpl.kt\ncom/yandex/div/storage/DivStorageImpl\n+ 2 KAssert.kt\ncom/yandex/div/internal/KAssert\n+ 3 KAssert.kt\ncom/yandex/div/internal/KAssert$assertEquals$1\n+ 4 Cursor.kt\nandroidx/core/database/CursorKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,577:1\n67#2,3:578\n71#2:582\n23#2,4:583\n67#3:581\n34#4:587\n34#4:588\n11335#5:589\n11670#5,3:590\n1855#6,2:593\n1855#6,2:595\n*S KotlinDebug\n*F\n+ 1 DivStorageImpl.kt\ncom/yandex/div/storage/DivStorageImpl\n*L\n101#1:578,3\n101#1:582\n108#1:583,4\n101#1:581\n325#1:587\n326#1:588\n469#1:589\n469#1:590,3\n473#1:593,2\n479#1:595,2\n*E\n"})
public class DivStorageImpl
implements DivStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String dbName;
    @NotNull
    private final DatabaseOpenHelper openHelper;
    @NotNull
    private final StorageStatementExecutor statementExecutor;
    @NotNull
    private final SingleTransactionDataSavePerformer dataSaveUseCase;
    @NotNull
    private final Map<Pair<Integer, Integer>, Migration> migrations;
    @NotNull
    private final Migration defaultDropAllMigration;

    public DivStorageImpl(@NotNull Context context, @NotNull DatabaseOpenHelperProvider openHelperProvider, @NotNull String databaseNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)openHelperProvider, (String)"openHelperProvider");
        Intrinsics.checkNotNullParameter((Object)databaseNamePrefix, (String)"databaseNamePrefix");
        this.dbName = ((CharSequence)databaseNamePrefix).length() == 0 ? "div-storage.db" : databaseNamePrefix + "-div-storage.db";
        this.openHelper = openHelperProvider.provide(context, this.dbName, 3, new DatabaseOpenHelper.CreateCallback(this){
            final /* synthetic */ DivStorageImpl $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void onCreate(@NotNull DatabaseOpenHelper.Database p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onCreate(p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, DivStorageImpl.class, "onCreate", "onCreate(Lcom/yandex/div/storage/database/DatabaseOpenHelper$Database;)V", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof DatabaseOpenHelper.CreateCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        }, new DatabaseOpenHelper.UpgradeCallback(this){
            final /* synthetic */ DivStorageImpl $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void onUpgrade(@NotNull DatabaseOpenHelper.Database p0, int p1, int p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUpgrade(p0, p1, p2);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(3, (Object)this.$tmp0, DivStorageImpl.class, "onUpgrade", "onUpgrade(Lcom/yandex/div/storage/database/DatabaseOpenHelper$Database;II)V", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof DatabaseOpenHelper.UpgradeCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        this.statementExecutor = new StorageStatementExecutor((Function0<? extends DatabaseOpenHelper.Database>)((Function0)new Function0<DatabaseOpenHelper.Database>(this){
            final /* synthetic */ DivStorageImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DatabaseOpenHelper.Database invoke() {
                return DivStorageImpl.access$getOpenHelper$p(this.this$0).getWritableDatabase();
            }
        }));
        this.dataSaveUseCase = new SingleTransactionDataSavePerformer(this.getStatementExecutor());
        this.migrations = MapsKt.mapOf((Pair)TuplesKt.to((Object)TuplesKt.to((Object)2, (Object)3), DivStorageImpl::migrations$lambda$0));
        this.defaultDropAllMigration = arg_0 -> DivStorageImpl.defaultDropAllMigration$lambda$1(this, arg_0);
    }

    public /* synthetic */ DivStorageImpl(Context context, DatabaseOpenHelperProvider databaseOpenHelperProvider, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "";
        }
        this(context, databaseOpenHelperProvider, string);
    }

    @NotNull
    public StorageStatementExecutor getStatementExecutor() {
        return this.statementExecutor;
    }

    @VisibleForTesting
    public static /* synthetic */ void getStatementExecutor$annotations() {
    }

    @Override
    @NotNull
    public Map<Pair<Integer, Integer>, Migration> getMigrations() {
        return this.migrations;
    }

    @VisibleForTesting
    public void onCreate(@NotNull DatabaseOpenHelper.Database db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.createTables(db);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public void onUpgrade(@NotNull DatabaseOpenHelper.Database db, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        KAssert kAssert = KAssert.INSTANCE;
        Integer n = newVersion;
        Integer actual$iv = 3;
        boolean $i$f$assertEquals = false;
        if (Assert.isEnabled()) {
            void expected$iv;
            boolean bl = false;
            Assert.assertEquals((String)"", (Object)expected$iv, (Object)actual$iv);
        }
        if (oldVersion == 3) {
            return;
        }
        Migration migration = this.getMigrations().get(TuplesKt.to((Object)oldVersion, (Object)newVersion));
        if (migration == null) {
            migration = this.defaultDropAllMigration;
        }
        Migration migration2 = migration;
        try {
            migration2.migrate(db);
        }
        catch (SQLException e) {
            KAssert this_$iv = KAssert.INSTANCE;
            boolean $i$f$fail = false;
            if (Assert.isEnabled()) {
                boolean bl = false;
                Assert.fail((String)("Migration from " + oldVersion + " to " + newVersion + " throws exception"), (Throwable)e);
            }
            this.defaultDropAllMigration.migrate(db);
        }
    }

    @VisibleForTesting
    public void createTables(@NotNull DatabaseOpenHelper.Database db) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        try {
            db.execSQL("\n    CREATE TABLE IF NOT EXISTS cards(\n    layout_id TEXT NOT NULL PRIMARY KEY,\n    card_data BLOB NULLABLE,\n    metadata BLOB NULLABLE,\n    group_id TEXT NOT NULL)");
            db.execSQL("\n    CREATE TABLE IF NOT EXISTS template_references(\n    group_id TEXT NOT NULL,\n    template_id TEXT NOT NULL,\n    template_hash TEXT NOT NULL,\n    PRIMARY KEY(group_id, template_id))");
            db.execSQL("\n    CREATE TABLE IF NOT EXISTS templates(\n    template_hash TEXT NOT NULL PRIMARY KEY,\n    template_data BLOB NULLABLE)");
            db.execSQL("\n    CREATE TABLE IF NOT EXISTS raw_json(\n    raw_json_id TEXT NOT NULL PRIMARY KEY,\n    raw_json_data BLOB NULLABLE)");
        }
        catch (SQLException e) {
            throw new SQLException("Create tables", (Throwable)e);
        }
    }

    @VisibleForTesting
    public void dropTables(@NotNull DatabaseOpenHelper.Database db) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        StorageStatement[] storageStatementArray = new StorageStatement[]{StorageStatements.INSTANCE.dropAllTables()};
        new StorageStatementExecutor((Function0<? extends DatabaseOpenHelper.Database>)((Function0)new Function0<DatabaseOpenHelper.Database>(db){
            final /* synthetic */ DatabaseOpenHelper.Database $db;
            {
                this.$db = $db;
                super(0);
            }

            @NotNull
            public final DatabaseOpenHelper.Database invoke() {
                return this.$db;
            }
        })).execute(storageStatementArray);
    }

    @Override
    @AnyThread
    @NotNull
    public ExecutionResult saveData(@NotNull String groupId, @NotNull List<? extends RawDataAndMetadata> divs, @NotNull List<Template> templatesByHash, @NotNull DivDataRepository.ActionOnError actionOnError) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter(divs, (String)"divs");
        Intrinsics.checkNotNullParameter(templatesByHash, (String)"templatesByHash");
        Intrinsics.checkNotNullParameter((Object)((Object)actionOnError), (String)"actionOnError");
        return this.dataSaveUseCase.saveDivData(groupId, divs, templatesByHash, actionOnError);
    }

    @Override
    @AnyThread
    @NotNull
    public ExecutionResult saveRawJsons(@NotNull List<? extends RawJson> rawJsons, @NotNull DivDataRepository.ActionOnError actionOnError) {
        Intrinsics.checkNotNullParameter(rawJsons, (String)"rawJsons");
        Intrinsics.checkNotNullParameter((Object)((Object)actionOnError), (String)"actionOnError");
        return this.dataSaveUseCase.saveRawJsons(rawJsons, actionOnError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    @NotNull
    public DivStorage.LoadDataResult<DivStorage.RestoredRawData> loadData(@NotNull List<String> ids, @NotNull List<String> idsToExclude) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter(idsToExclude, (String)"idsToExclude");
        Set usedGroups = new LinkedHashSet();
        ArrayList<DivStorage.RestoredRawData> cards = new ArrayList<DivStorage.RestoredRawData>(ids.size());
        List exceptions = new ArrayList();
        String selection = ids.isEmpty() && idsToExclude.isEmpty() ? null : (ids.isEmpty() ? "layout_id NOT IN " + DivStorageImpl.Companion.asSqlList(idsToExclude) : (idsToExclude.isEmpty() ? "layout_id IN " + DivStorageImpl.Companion.asSqlList(ids) : "layout_id NOT IN " + DivStorageImpl.Companion.asSqlList(idsToExclude) + " AND layout_id IN " + DivStorageImpl.Companion.asSqlList(ids)));
        try {
            ReadState cardsReadState2 = this.readStateFor((Function1<? super DatabaseOpenHelper.Database, ? extends Cursor>)((Function1)new Function1<DatabaseOpenHelper.Database, Cursor>(selection){
                final /* synthetic */ String $selection;
                {
                    this.$selection = $selection;
                    super(1);
                }

                @NotNull
                public final Cursor invoke(@NotNull DatabaseOpenHelper.Database $this$readStateFor) {
                    Intrinsics.checkNotNullParameter((Object)$this$readStateFor, (String)"$this$readStateFor");
                    return $this$readStateFor.query("cards", null, this.$selection, null, null, null, null, null);
                }
            }));
            Closeable closeable = cardsReadState2;
            Throwable throwable = null;
            try {
                ReadState it = (ReadState)closeable;
                boolean bl = false;
                Cursor cursor = it.getCursor();
                if (cursor.getCount() == 0 || !cursor.moveToFirst()) {
                    DivStorage.LoadDataResult<DivStorage.RestoredRawData> loadDataResult = new DivStorage.LoadDataResult<DivStorage.RestoredRawData>(CollectionsKt.emptyList(), exceptions);
                    return loadDataResult;
                }
                do {
                    DivStorage.RestoredRawData rawData;
                    if ((rawData = this.getRestoredRawData(cursor, exceptions)) == null) continue;
                    cards.add(rawData);
                    usedGroups.add(rawData.getGroupId$div_storage_release());
                } while (cursor.moveToNext());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (SQLiteDatabaseLockedException e) {
            exceptions.add(DivStorageImpl.toStorageException$default(this, (Exception)((Object)e), "Exception on load data from storage", null, 2, null));
        }
        catch (IllegalStateException e) {
            exceptions.add(DivStorageImpl.toStorageException$default(this, e, "Exception on load data from storage", null, 2, null));
        }
        return new DivStorage.LoadDataResult<DivStorage.RestoredRawData>((List)cards, exceptions);
    }

    @Override
    @AnyThread
    @NotNull
    public DivStorage.RemoveResult remove(@NotNull Function1<? super RawDataAndMetadata, Boolean> predicate) throws SQLException {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Set<String> ids = this.collectsRecordsFor(predicate);
        StorageStatement[] storageStatementArray = new StorageStatement[]{StorageStatements.INSTANCE.deleteCardsAndTemplates(ids), StorageStatements.INSTANCE.deleteTemplatesWithoutLinksToCards()};
        List<StorageException> exceptions = this.getStatementExecutor().execute(DivDataRepository.ActionOnError.SKIP_ELEMENT, storageStatementArray).getErrors();
        return new DivStorage.RemoveResult(ids, exceptions);
    }

    @Override
    @AnyThread
    @Nullable
    public DivStorageErrorException removeAllCards() {
        String[] stringArray = new String[]{"DELETE FROM cards"};
        return this.deleteTablesTransaction("delete all cards", stringArray);
    }

    @Override
    @AnyThread
    @NotNull
    public DivStorage.LoadDataResult<RawJson> readRawJsons(@NotNull Set<String> rawJsonIds) {
        Intrinsics.checkNotNullParameter(rawJsonIds, (String)"rawJsonIds");
        String actionDesc = "Read raw jsons with ids: " + rawJsonIds;
        List exceptions = new ArrayList();
        List<RawJson> rawJsons = CollectionsKt.emptyList();
        try {
            rawJsons = this.collectsRawJsons(rawJsonIds);
        }
        catch (SQLException e) {
            exceptions.add(DivStorageImpl.toStorageException$default(this, (Exception)((Object)e), actionDesc, null, 2, null));
        }
        catch (SQLiteDatabaseLockedException e) {
            exceptions.add(DivStorageImpl.toStorageException$default(this, (Exception)((Object)e), actionDesc, null, 2, null));
        }
        catch (IllegalStateException e) {
            exceptions.add(DivStorageImpl.toStorageException$default(this, e, actionDesc, null, 2, null));
        }
        return new DivStorage.LoadDataResult<RawJson>(rawJsons, exceptions);
    }

    @Override
    @AnyThread
    @NotNull
    public DivStorage.RemoveResult removeRawJsons(@NotNull Function1<? super RawJson, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Set<String> ids = this.collectsRawJsonsIdsFor(predicate);
        StorageStatement[] storageStatementArray = new StorageStatement[]{StorageStatements.INSTANCE.deleteRawJsons(ids)};
        List<StorageException> exceptions = this.getStatementExecutor().execute(DivDataRepository.ActionOnError.SKIP_ELEMENT, storageStatementArray).getErrors();
        return new DivStorage.RemoveResult(ids, exceptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    @NotNull
    public DivStorage.LoadDataResult<RawTemplateData> readTemplates(@NotNull Set<String> templateHashes) {
        Intrinsics.checkNotNullParameter(templateHashes, (String)"templateHashes");
        String actionDesc = "Read templates with hashes: " + templateHashes;
        List exceptions = new ArrayList();
        List<RawTemplateData> templates = CollectionsKt.emptyList();
        try {
            List<RawTemplateData> list;
            ReadState readState2 = this.readStateFor((Function1<? super DatabaseOpenHelper.Database, ? extends Cursor>)((Function1)new Function1<DatabaseOpenHelper.Database, Cursor>(templateHashes){
                final /* synthetic */ Set<String> $templateHashes;
                {
                    this.$templateHashes = $templateHashes;
                    super(1);
                }

                @NotNull
                public final Cursor invoke(@NotNull DatabaseOpenHelper.Database $this$readStateFor) {
                    Intrinsics.checkNotNullParameter((Object)$this$readStateFor, (String)"$this$readStateFor");
                    boolean $i$f$emptyArray = false;
                    return $this$readStateFor.rawQuery("\n    SELECT t.template_hash, t.template_data\n    FROM templates AS t\n    WHERE t.template_hash in\n  " + com.yandex.div.storage.DivStorageImpl$Companion.access$asSqlList(DivStorageImpl.Companion, this.$templateHashes), new String[0]);
                }
            }));
            Closeable closeable = readState2;
            Throwable throwable = null;
            try {
                ReadState it = (ReadState)closeable;
                boolean bl = false;
                list = this.getTemplates(it.getCursor());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            templates = list;
        }
        catch (SQLException e) {
            exceptions.add(DivStorageImpl.toStorageException$default(this, (Exception)((Object)e), actionDesc, null, 2, null));
        }
        catch (SQLiteDatabaseLockedException e) {
            exceptions.add(DivStorageImpl.toStorageException$default(this, (Exception)((Object)e), actionDesc, null, 2, null));
        }
        catch (IllegalStateException e) {
            exceptions.add(DivStorageImpl.toStorageException$default(this, e, actionDesc, null, 2, null));
        }
        return new DivStorage.LoadDataResult<RawTemplateData>(templates, exceptions);
    }

    @Override
    @AnyThread
    @Nullable
    public DivStorageErrorException removeAllTemplates() {
        String[] stringArray = new String[]{"DELETE FROM template_references", "DELETE FROM templates"};
        return this.deleteTablesTransaction("Delete all templates", stringArray);
    }

    @Override
    public boolean isCardExists(@NotNull String id, @NotNull String groupId) throws DivStorageErrorException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Ref.BooleanRef result = new Ref.BooleanRef();
        StorageStatement[] storageStatementArray = new StorageStatement[]{StorageStatements.INSTANCE.isCardExists(id, groupId, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(result){
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$result.element = it;
            }
        }))};
        ExecutionResult executionResult2 = this.getStatementExecutor().execute(storageStatementArray);
        if (!executionResult2.isSuccessful() && !((Collection)executionResult2.getErrors()).isEmpty()) {
            throw this.toStorageException((Exception)CollectionsKt.first(executionResult2.getErrors()), "Check card exists", id);
        }
        return result.element;
    }

    @Override
    public boolean isTemplateExists(@NotNull String templateHash) throws DivStorageErrorException {
        Intrinsics.checkNotNullParameter((Object)templateHash, (String)"templateHash");
        Ref.BooleanRef result = new Ref.BooleanRef();
        StorageStatement[] storageStatementArray = new StorageStatement[]{StorageStatements.INSTANCE.isTemplateExists(templateHash, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(result){
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$result.element = it;
            }
        }))};
        ExecutionResult executionResult2 = this.getStatementExecutor().execute(storageStatementArray);
        if (!executionResult2.isSuccessful() && !((Collection)executionResult2.getErrors()).isEmpty()) {
            throw DivStorageImpl.toStorageException$default(this, (Exception)CollectionsKt.first(executionResult2.getErrors()), "Check template " + templateHash + " exists", null, 2, null);
        }
        return result.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DivStorage.LoadDataResult<DivStorage.TemplateReference> readTemplateReferences() {
        DivStorage.LoadDataResult<DivStorage.TemplateReference> loadDataResult;
        String actionDesc = "Template references";
        try {
            List<DivStorage.TemplateReference> list;
            ReadState readState2 = this.readStateFor((Function1<? super DatabaseOpenHelper.Database, ? extends Cursor>)((Function1)readTemplateReferences.readState.1.INSTANCE));
            Closeable closeable = readState2;
            Throwable throwable = null;
            try {
                ReadState it = (ReadState)closeable;
                boolean bl = false;
                list = this.getTemplateReferences(it.getCursor());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            List<DivStorage.TemplateReference> results = list;
            loadDataResult = new DivStorage.LoadDataResult(results, null, 2, null);
        }
        catch (SQLException e) {
            loadDataResult = new DivStorage.LoadDataResult<DivStorage.TemplateReference>(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)DivStorageImpl.toStorageException$default(this, (Exception)((Object)e), actionDesc, null, 2, null)));
        }
        catch (SQLiteDatabaseLockedException e) {
            loadDataResult = new DivStorage.LoadDataResult(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)DivStorageImpl.toStorageException$default(this, (Exception)((Object)e), actionDesc, null, 2, null)));
        }
        catch (IllegalStateException e) {
            loadDataResult = new DivStorage.LoadDataResult(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)DivStorageImpl.toStorageException$default(this, e, actionDesc, null, 2, null)));
        }
        return loadDataResult;
    }

    /*
     * WARNING - void declaration
     */
    private DivStorage.RestoredRawData getRestoredRawData(Cursor $this$getRestoredRawData, List<StorageException> exceptions) {
        JSONObject jSONObject;
        JSONObject index$iv3;
        void $this$getBlobOrNull$iv;
        byte[] metadataBlob;
        void $this$getBlobOrNull$iv2;
        String id = $this$getRestoredRawData.getString(this.indexOf($this$getRestoredRawData, "layout_id"));
        String groupId = $this$getRestoredRawData.getString(this.indexOf($this$getRestoredRawData, "group_id"));
        Cursor cursor = $this$getRestoredRawData;
        int index$iv22 = this.indexOf($this$getRestoredRawData, "card_data");
        boolean $i$f$getBlobOrNull = false;
        byte[] cardBlob = $this$getBlobOrNull$iv2.isNull(index$iv22) ? null : $this$getBlobOrNull$iv2.getBlob(index$iv22);
        Cursor index$iv22 = $this$getRestoredRawData;
        int index$iv3 = this.indexOf($this$getRestoredRawData, "metadata");
        boolean $i$f$getBlobOrNull2 = false;
        byte[] byArray = metadataBlob = $this$getBlobOrNull$iv.isNull(index$iv3) ? null : $this$getBlobOrNull$iv.getBlob(index$iv3);
        if (cardBlob == null) {
            DivStorageErrorException exception = new DivStorageErrorException("DivData is null for card with id " + id + '.', null, id, 2, null);
            exceptions.add(exception);
            return null;
        }
        try {
            index$iv3 = this.toJSONObject(cardBlob);
        }
        catch (JSONException e) {
            exceptions.add(new DivStorageErrorException("DivData is invalid for card with id " + id, e, id));
            index$iv3 = null;
        }
        JSONObject divData2 = index$iv3;
        try {
            jSONObject = metadataBlob != null ? this.toJSONObject(metadataBlob) : null;
        }
        catch (JSONException e) {
            exceptions.add(new DivStorageErrorException("Metadata is invalid for card with id " + id, e, id));
            jSONObject = null;
        }
        JSONObject metadata2 = jSONObject;
        if (divData2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
        Intrinsics.checkNotNullExpressionValue((Object)groupId, (String)"groupId");
        return new DivStorage.RestoredRawData(id, divData2, metadata2, groupId);
    }

    private List<RawTemplateData> getTemplates(Cursor $this$getTemplates) throws SQLException {
        if ($this$getTemplates.getCount() == 0 || !$this$getTemplates.moveToFirst()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<RawTemplateData> templates = new ArrayList<RawTemplateData>($this$getTemplates.getCount());
        do {
            String string = $this$getTemplates.getString(this.indexOf($this$getTemplates, "template_hash"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(indexOf(COLUMN_TEMPLATE_HASH))");
            byte[] byArray = $this$getTemplates.getBlob(this.indexOf($this$getTemplates, "template_data"));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBlob(indexOf(COLUMN_TEMPLATE_DATA))");
            RawTemplateData template = new RawTemplateData(string, byArray);
            templates.add(template);
        } while ($this$getTemplates.moveToNext());
        return templates;
    }

    @AnyThread
    private Set<String> collectsRecordsFor(Function1<? super RawDataAndMetadata, Boolean> predicate) throws SQLException {
        Set results = new LinkedHashSet();
        StorageStatement[] storageStatementArray = new StorageStatement[]{StorageStatements.INSTANCE.readData((Function1<? super ReadState, Unit>)((Function1)new Function1<ReadState, Unit>(this, predicate, (Set<String>)results){
            final /* synthetic */ DivStorageImpl this$0;
            final /* synthetic */ Function1<RawDataAndMetadata, Boolean> $predicate;
            final /* synthetic */ Set<String> $results;
            {
                this.this$0 = $receiver;
                this.$predicate = $predicate;
                this.$results = $results;
                super(1);
            }

            public final void invoke(@NotNull ReadState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Cursor cursor = it.getCursor();
                if (cursor.getCount() == 0 || !cursor.moveToFirst()) {
                    return;
                }
                do {
                    CursorDrivenRawDataAndMetadata rawDataAndMetadata;
                    if (((Boolean)this.$predicate.invoke((Object)(rawDataAndMetadata = this.this$0.new CursorDrivenRawDataAndMetadata(cursor)))).booleanValue()) {
                        this.$results.add(rawDataAndMetadata.getId());
                    }
                    rawDataAndMetadata.close();
                } while (cursor.moveToNext());
            }
        }))};
        this.getStatementExecutor().execute(storageStatementArray);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    private List<RawJson> collectsRawJsons(Set<String> rawJsonIds) throws SQLException {
        ArrayList<RawJson.Ready> results = new ArrayList<RawJson.Ready>(rawJsonIds.size());
        Closeable closeable = this.readStateFor((Function1<? super DatabaseOpenHelper.Database, ? extends Cursor>)((Function1)new Function1<DatabaseOpenHelper.Database, Cursor>(rawJsonIds){
            final /* synthetic */ Set<String> $rawJsonIds;
            {
                this.$rawJsonIds = $rawJsonIds;
                super(1);
            }

            @NotNull
            public final Cursor invoke(@NotNull DatabaseOpenHelper.Database $this$readStateFor) {
                Intrinsics.checkNotNullParameter((Object)$this$readStateFor, (String)"$this$readStateFor");
                boolean $i$f$emptyArray = false;
                return $this$readStateFor.rawQuery("\n    SELECT raw_json_id, raw_json_data\n    FROM raw_json\n    WHERE raw_json_id IN\n " + com.yandex.div.storage.DivStorageImpl$Companion.access$asSqlList(DivStorageImpl.Companion, this.$rawJsonIds), new String[0]);
            }
        }));
        Throwable throwable = null;
        try {
            ReadState it = (ReadState)closeable;
            boolean bl = false;
            Cursor cursor = it.getCursor();
            if (cursor.getCount() != 0 && cursor.moveToFirst()) {
                do {
                    CursorDrivenRawJson cursorRawJson;
                    CursorDrivenRawJson $this$collectsRawJsons_u24lambda_u247_u24lambda_u246 = cursorRawJson = new CursorDrivenRawJson(cursor);
                    boolean bl2 = false;
                    RawJson.Ready rawJson = new RawJson.Ready($this$collectsRawJsons_u24lambda_u247_u24lambda_u246.getId(), $this$collectsRawJsons_u24lambda_u247_u24lambda_u246.getData());
                    results.add(rawJson);
                    cursorRawJson.close();
                } while (cursor.moveToNext());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return results;
    }

    @AnyThread
    private Set<String> collectsRawJsonsIdsFor(Function1<? super RawJson, Boolean> predicate) throws SQLException {
        Set results = new LinkedHashSet();
        StorageStatement[] storageStatementArray = new StorageStatement[]{StorageStatements.INSTANCE.readRawJsons((Function1<? super ReadState, Unit>)((Function1)new Function1<ReadState, Unit>(this, predicate, (Set<String>)results){
            final /* synthetic */ DivStorageImpl this$0;
            final /* synthetic */ Function1<RawJson, Boolean> $predicate;
            final /* synthetic */ Set<String> $results;
            {
                this.this$0 = $receiver;
                this.$predicate = $predicate;
                this.$results = $results;
                super(1);
            }

            public final void invoke(@NotNull ReadState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Cursor cursor = it.getCursor();
                if (cursor.getCount() == 0 || !cursor.moveToFirst()) {
                    return;
                }
                do {
                    CursorDrivenRawJson rawJson;
                    if (((Boolean)this.$predicate.invoke((Object)(rawJson = this.this$0.new CursorDrivenRawJson(cursor)))).booleanValue()) {
                        this.$results.add(rawJson.getId());
                    }
                    rawJson.close();
                } while (cursor.moveToNext());
            }
        }))};
        this.getStatementExecutor().execute(storageStatementArray);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @AnyThread
    private DivStorageErrorException deleteTablesTransaction(String actionDesc, String ... queries) {
        boolean $i$f$forEach;
        Iterator $this$mapTo$iv$iv;
        DivStorageErrorException exception = null;
        DatabaseOpenHelper.Database $this$deleteTablesTransaction_u24lambda_u2411 = this.openHelper.getWritableDatabase();
        boolean bl = false;
        String[] $this$map$iv = queries;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_24 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add($this$deleteTablesTransaction_u24lambda_u2411.compileStatement((String)it));
        }
        List statements = (List)destination$iv$iv;
        try {
            $this$deleteTablesTransaction_u24lambda_u2411.beginTransaction();
            Iterable $this$forEach$iv = statements;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SQLiteStatement it = (SQLiteStatement)element$iv;
                boolean bl3 = false;
                it.executeUpdateDelete();
            }
            $this$deleteTablesTransaction_u24lambda_u2411.setTransactionSuccessful();
        }
        catch (SQLException e) {
            exception = DivStorageImpl.toStorageException$default(this, (Exception)((Object)e), actionDesc, null, 2, null);
        }
        finally {
            SqlExtensionsKt.endTransactionSilently($this$deleteTablesTransaction_u24lambda_u2411);
            Iterable $this$forEach$iv = statements;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SQLiteStatement it = (SQLiteStatement)element$iv;
                boolean bl4 = false;
                SqlExtensionsKt.closeSilently((Closeable)it);
            }
            SqlExtensionsKt.closeSilently($this$deleteTablesTransaction_u24lambda_u2411);
        }
        return exception;
    }

    private List<DivStorage.TemplateReference> getTemplateReferences(Cursor $this$getTemplateReferences) throws SQLException {
        if ($this$getTemplateReferences.getCount() == 0 || !$this$getTemplateReferences.moveToFirst()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<DivStorage.TemplateReference> templates = new ArrayList<DivStorage.TemplateReference>($this$getTemplateReferences.getCount());
        do {
            String string = $this$getTemplateReferences.getString(this.indexOf($this$getTemplateReferences, "group_id"));
            String string2 = $this$getTemplateReferences.getString(this.indexOf($this$getTemplateReferences, "template_hash"));
            String string3 = $this$getTemplateReferences.getString(this.indexOf($this$getTemplateReferences, "template_id"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(indexOf(COLUMN_GROUP_ID))");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(indexOf(COLUMN_TEMPLATE_ID))");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(indexOf(COLUMN_TEMPLATE_HASH))");
            DivStorage.TemplateReference template = new DivStorage.TemplateReference(string, string3, string2);
            templates.add(template);
        } while ($this$getTemplateReferences.moveToNext());
        return templates;
    }

    private DivStorageErrorException toStorageException(Exception $this$toStorageException, String actionDesc, String cardId) {
        String msg = "Unexpected exception on database access: " + actionDesc;
        return new DivStorageErrorException(msg, $this$toStorageException, cardId);
    }

    static /* synthetic */ DivStorageErrorException toStorageException$default(DivStorageImpl divStorageImpl, Exception exception, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toStorageException");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return divStorageImpl.toStorageException(exception, string, string2);
    }

    @AnyThread
    private ReadState readStateFor(Function1<? super DatabaseOpenHelper.Database, ? extends Cursor> func) {
        DatabaseOpenHelper.Database db = this.openHelper.getReadableDatabase();
        return new ReadState((Function0<Unit>)((Function0)new Function0<Unit>(db){
            final /* synthetic */ DatabaseOpenHelper.Database $db;
            {
                this.$db = $db;
                super(0);
            }

            public final void invoke() {
                SqlExtensionsKt.closeSilently(this.$db);
            }
        }), (Provider<Cursor>)((Provider)() -> DivStorageImpl.readStateFor$lambda$12(db, func)));
    }

    private int indexOf(Cursor $this$indexOf, String columnName) {
        int index = $this$indexOf.getColumnIndex(columnName);
        if (index < 0) {
            throw new IllegalStateException("Column '" + columnName + "' not found in cursor");
        }
        return index;
    }

    private JSONObject toJSONObject(byte[] $this$toJSONObject) {
        byte[] byArray = $this$toJSONObject;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new JSONObject(new String(byArray, charset2));
    }

    private static final void migrations$lambda$0(DatabaseOpenHelper.Database db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        try {
            db.execSQL("\n    CREATE TABLE IF NOT EXISTS raw_json(\n    raw_json_id TEXT NOT NULL PRIMARY KEY,\n    raw_json_data BLOB NULLABLE)");
        }
        catch (SQLException e) {
            throw new SQLException("Create \"raw_json\" table", (Throwable)e);
        }
    }

    private static final void defaultDropAllMigration$lambda$1(DivStorageImpl this$0, DatabaseOpenHelper.Database db) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this$0.dropTables(db);
        this$0.createTables(db);
    }

    private static final Cursor readStateFor$lambda$12(DatabaseOpenHelper.Database $db, Function1 $func) {
        Intrinsics.checkNotNullParameter((Object)$db, (String)"$db");
        Intrinsics.checkNotNullParameter((Object)$func, (String)"$func");
        return (Cursor)$func.invoke((Object)$db);
    }

    public static final /* synthetic */ JSONObject access$toJSONObject(DivStorageImpl $this, byte[] $receiver) {
        return $this.toJSONObject($receiver);
    }

    public static final /* synthetic */ DatabaseOpenHelper access$getOpenHelper$p(DivStorageImpl $this) {
        return $this.openHelper;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/yandex/div/storage/DivStorageImpl$Companion;", "", "()V", "asSqlList", "", "T", "", "div-storage_release"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> String asSqlList(Collection<? extends T> $this$asSqlList) {
            return CollectionsKt.joinToString$default((Iterable)$this$asSqlList, (CharSequence)"', '", (CharSequence)"('", (CharSequence)"')", (int)0, null, null, (int)56, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0015\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/yandex/div/storage/DivStorageImpl$CursorDrivenRawDataAndMetadata;", "Lcom/yandex/div/storage/RawDataAndMetadata;", "Ljava/io/Closeable;", "cursor", "Landroid/database/Cursor;", "(Lcom/yandex/div/storage/DivStorageImpl;Landroid/database/Cursor;)V", "getCursor", "()Landroid/database/Cursor;", "cursorInvalid", "", "divData", "Lorg/json/JSONObject;", "getDivData", "()Lorg/json/JSONObject;", "divData$delegate", "Lkotlin/Lazy;", "id", "", "getId", "()Ljava/lang/String;", "metadata", "getMetadata", "metadata$delegate", "close", "", "div-storage_release"})
    private final class CursorDrivenRawDataAndMetadata
    implements RawDataAndMetadata,
    Closeable {
        @NotNull
        private final Cursor cursor;
        private boolean cursorInvalid;
        @NotNull
        private final String id;
        @NotNull
        private final Lazy divData$delegate;
        @NotNull
        private final Lazy metadata$delegate;

        public CursorDrivenRawDataAndMetadata(Cursor cursor) {
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            this.cursor = cursor;
            String string = this.cursor.getString(DivStorageImpl.this.indexOf(this.cursor, "layout_id"));
            Intrinsics.checkNotNull((Object)string);
            this.id = string;
            this.divData$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JSONObject>(this, DivStorageImpl.this){
                final /* synthetic */ CursorDrivenRawDataAndMetadata this$0;
                final /* synthetic */ DivStorageImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final JSONObject invoke() {
                    if (CursorDrivenRawDataAndMetadata.access$getCursorInvalid$p(this.this$0)) {
                        throw new IllegalStateException("Data no longer valid!");
                    }
                    byte[] byArray = this.this$0.getCursor().getBlob(DivStorageImpl.access$indexOf(this.this$1, this.this$0.getCursor(), "card_data"));
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cursor.getBlob(cursor.indexOf(COLUMN_CARD_DATA))");
                    return DivStorageImpl.access$toJSONObject(this.this$1, byArray);
                }
            }));
            this.metadata$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JSONObject>(this, DivStorageImpl.this){
                final /* synthetic */ CursorDrivenRawDataAndMetadata this$0;
                final /* synthetic */ DivStorageImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final JSONObject invoke() {
                    void $this$getBlobOrNull$iv;
                    if (CursorDrivenRawDataAndMetadata.access$getCursorInvalid$p(this.this$0)) {
                        throw new IllegalStateException("Data no longer valid!");
                    }
                    Cursor cursor = this.this$0.getCursor();
                    int index$iv = DivStorageImpl.access$indexOf(this.this$1, this.this$0.getCursor(), "metadata");
                    boolean $i$f$getBlobOrNull = false;
                    byte[] byArray = $this$getBlobOrNull$iv.isNull(index$iv) ? null : $this$getBlobOrNull$iv.getBlob(index$iv);
                    return byArray != null ? DivStorageImpl.access$toJSONObject(this.this$1, byArray) : null;
                }
            }));
        }

        @NotNull
        public final Cursor getCursor() {
            return this.cursor;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public JSONObject getDivData() {
            Lazy lazy = this.divData$delegate;
            return (JSONObject)lazy.getValue();
        }

        @Override
        @Nullable
        public JSONObject getMetadata() {
            Lazy lazy = this.metadata$delegate;
            return (JSONObject)lazy.getValue();
        }

        @Override
        public void close() {
            this.cursorInvalid = true;
        }

        public static final /* synthetic */ boolean access$getCursorInvalid$p(CursorDrivenRawDataAndMetadata $this) {
            return $this.cursorInvalid;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/yandex/div/storage/DivStorageImpl$CursorDrivenRawJson;", "Lcom/yandex/div/storage/rawjson/RawJson;", "Ljava/io/Closeable;", "cursor", "Landroid/database/Cursor;", "(Lcom/yandex/div/storage/DivStorageImpl;Landroid/database/Cursor;)V", "getCursor", "()Landroid/database/Cursor;", "cursorInvalid", "", "data", "Lorg/json/JSONObject;", "getData", "()Lorg/json/JSONObject;", "data$delegate", "Lkotlin/Lazy;", "id", "", "getId", "()Ljava/lang/String;", "close", "", "div-storage_release"})
    private final class CursorDrivenRawJson
    implements RawJson,
    Closeable {
        @NotNull
        private final Cursor cursor;
        private boolean cursorInvalid;
        @NotNull
        private final String id;
        @NotNull
        private final Lazy data$delegate;

        public CursorDrivenRawJson(Cursor cursor) {
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            this.cursor = cursor;
            String string = this.cursor.getString(DivStorageImpl.this.indexOf(this.cursor, "raw_json_id"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(cursor.\u2026exOf(COLUMN_RAW_JSON_ID))");
            this.id = string;
            this.data$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JSONObject>(this, DivStorageImpl.this){
                final /* synthetic */ CursorDrivenRawJson this$0;
                final /* synthetic */ DivStorageImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final JSONObject invoke() {
                    if (CursorDrivenRawJson.access$getCursorInvalid$p(this.this$0)) {
                        throw new IllegalStateException("Data no longer valid!");
                    }
                    byte[] byArray = this.this$0.getCursor().getBlob(DivStorageImpl.access$indexOf(this.this$1, this.this$0.getCursor(), "raw_json_data"));
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cursor.getBlob(cursor.in\u2026Of(COLUMN_RAW_JSON_DATA))");
                    return DivStorageImpl.access$toJSONObject(this.this$1, byArray);
                }
            }));
        }

        @NotNull
        public final Cursor getCursor() {
            return this.cursor;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public JSONObject getData() {
            Lazy lazy = this.data$delegate;
            return (JSONObject)lazy.getValue();
        }

        @Override
        public void close() {
            this.cursorInvalid = true;
        }

        public static final /* synthetic */ boolean access$getCursorInvalid$p(CursorDrivenRawJson $this) {
            return $this.cursorInvalid;
        }
    }
}

