/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage;

import androidx.annotation.UiThread;
import com.yandex.div.internal.Assert;
import com.yandex.div.internal.KAssert;
import com.yandex.div.storage.DivStorage;
import com.yandex.div.storage.RawJsonRepository;
import com.yandex.div.storage.RawJsonRepositoryException;
import com.yandex.div.storage.RawJsonRepositoryRemoveResult;
import com.yandex.div.storage.RawJsonRepositoryResult;
import com.yandex.div.storage.database.StorageException;
import com.yandex.div.storage.rawjson.RawJson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u000fH\u0017J\u001a\u0010\u0013\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u001c\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u001aH\u0017J\u001a\u0010\u001b\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\rH\u0002J,\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001f0\r\"\u0004\b\u0000\u0010\u001f\"\u0004\b\u0001\u0010 *\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u001f\u0012\u0004\u0012\u0002H 0!H\u0002J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0011*\b\u0012\u0004\u0012\u00020$0\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/yandex/div/storage/RawJsonRepositoryImpl;", "Lcom/yandex/div/storage/RawJsonRepository;", "divStorage", "Lcom/yandex/div/storage/DivStorage;", "(Lcom/yandex/div/storage/DivStorage;)V", "areJsonsSynchronizedWithInMemory", "", "inMemoryData", "", "", "Lcom/yandex/div/storage/JsonId;", "Lcom/yandex/div/storage/rawjson/RawJson;", "jsonIdsWithErrors", "", "get", "Lcom/yandex/div/storage/RawJsonRepositoryResult;", "ids", "", "getAll", "loadFromStorage", "put", "payload", "Lcom/yandex/div/storage/RawJsonRepository$Payload;", "remove", "Lcom/yandex/div/storage/RawJsonRepositoryRemoveResult;", "predicate", "Lkotlin/Function1;", "removeFromInMemory", "", "deletedRecords", "getKeysNotNull", "K", "V", "", "toRawJsonRepositoryExceptions", "Lcom/yandex/div/storage/RawJsonRepositoryException;", "Lcom/yandex/div/storage/database/StorageException;", "div-storage_release"})
@SourceDebugExtension(value={"SMAP\nRawJsonRepositoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawJsonRepositoryImpl.kt\ncom/yandex/div/storage/RawJsonRepositoryImpl\n+ 2 KAssert.kt\ncom/yandex/div/internal/KAssert\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,113:1\n113#2,4:114\n113#2,4:120\n113#2,4:128\n113#2,4:148\n1855#3,2:118\n1855#3,2:124\n1855#3,2:126\n1855#3,2:132\n1477#3:134\n1502#3,3:135\n1505#3,3:145\n1855#3,2:152\n1549#3:154\n1620#3,3:155\n361#4,7:138\n*S KotlinDebug\n*F\n+ 1 RawJsonRepositoryImpl.kt\ncom/yandex/div/storage/RawJsonRepositoryImpl\n*L\n20#1:114,4\n33#1:120,4\n57#1:128,4\n80#1:148,4\n22#1:118,2\n40#1:124,2\n49#1:126,2\n70#1:132,2\n73#1:134\n73#1:135,3\n73#1:145,3\n95#1:152,2\n111#1:154\n111#1:155,3\n73#1:138,7\n*E\n"})
public final class RawJsonRepositoryImpl
implements RawJsonRepository {
    @NotNull
    private final DivStorage divStorage;
    @NotNull
    private final Map<String, RawJson> inMemoryData;
    private boolean areJsonsSynchronizedWithInMemory;
    @NotNull
    private Set<String> jsonIdsWithErrors;

    public RawJsonRepositoryImpl(@NotNull DivStorage divStorage) {
        Intrinsics.checkNotNullParameter((Object)divStorage, (String)"divStorage");
        this.divStorage = divStorage;
        this.inMemoryData = new LinkedHashMap();
        this.jsonIdsWithErrors = SetsKt.emptySet();
    }

    @Override
    @UiThread
    @NotNull
    public RawJsonRepositoryResult put(@NotNull RawJsonRepository.Payload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        KAssert this_$iv = KAssert.INSTANCE;
        boolean $i$f$assertMainThread = false;
        if (Assert.isEnabled()) {
            Assert.assertMainThread();
        }
        List<RawJson> rawJsons = payload.getJsons();
        Iterable $this$forEach$iv = rawJsons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RawJson it = (RawJson)element$iv;
            boolean bl = false;
            this.inMemoryData.put(it.getId(), it);
        }
        List<StorageException> divStorageErrors = this.divStorage.saveRawJsons(rawJsons, payload.getActionOnError()).getErrors();
        List exceptions = new ArrayList();
        exceptions.addAll((Collection)this.toRawJsonRepositoryExceptions(divStorageErrors));
        return new RawJsonRepositoryResult(rawJsons, exceptions);
    }

    @Override
    @UiThread
    @NotNull
    public RawJsonRepositoryResult get(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        KAssert this_$iv = KAssert.INSTANCE;
        boolean $i$f$assertMainThread = false;
        if (Assert.isEnabled()) {
            Assert.assertMainThread();
        }
        if (ids.isEmpty()) {
            return RawJsonRepositoryResult.Companion.getEMPTY();
        }
        Set idsToLoad = CollectionsKt.toMutableSet((Iterable)ids);
        ArrayList<RawJson> inMemoryResults = new ArrayList<RawJson>(ids.size());
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RawJson it;
            String id = (String)element$iv;
            boolean bl = false;
            if (this.inMemoryData.get(id) == null) continue;
            boolean bl2 = false;
            inMemoryResults.add(it);
            idsToLoad.remove(id);
        }
        if (!((Collection)idsToLoad).isEmpty()) {
            RawJsonRepositoryResult storageResults = this.loadFromStorage(idsToLoad);
            Iterable $this$forEach$iv2 = storageResults.getResultData();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                RawJson it = (RawJson)element$iv;
                boolean bl = false;
                this.inMemoryData.put(it.getId(), it);
            }
            return storageResults.addData((Collection<? extends RawJson>)inMemoryResults);
        }
        return new RawJsonRepositoryResult((List<? extends RawJson>)inMemoryResults, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @UiThread
    @NotNull
    public RawJsonRepositoryResult getAll() {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        KAssert this_$iv = KAssert.INSTANCE;
        boolean $i$f$assertMainThread = false;
        if (Assert.isEnabled()) {
            Assert.assertMainThread();
        }
        if (this.areJsonsSynchronizedWithInMemory && this.jsonIdsWithErrors.isEmpty()) {
            return new RawJsonRepositoryResult(CollectionsKt.toList((Iterable)this.inMemoryData.values()), CollectionsKt.emptyList());
        }
        Set<String> jsonsToRequest = this.areJsonsSynchronizedWithInMemory ? this.jsonIdsWithErrors : SetsKt.emptySet();
        RawJsonRepositoryResult storageResults = this.loadFromStorage(jsonsToRequest);
        RawJsonRepositoryResult resultsWithInMemory = storageResults.addData(this.inMemoryData.values());
        Iterable $this$forEach$iv = storageResults.getResultData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RawJson it = (RawJson)element$iv;
            boolean bl = false;
            this.inMemoryData.put(it.getId(), it);
        }
        this.areJsonsSynchronizedWithInMemory = true;
        $this$forEach$iv = storageResults.getErrors();
        RawJsonRepositoryImpl rawJsonRepositoryImpl = this;
        RawJsonRepositoryImpl rawJsonRepositoryImpl2 = this;
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            RawJsonRepositoryException it = (RawJsonRepositoryException)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getJsonId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map map = destination$iv$iv;
        rawJsonRepositoryImpl2.jsonIdsWithErrors = rawJsonRepositoryImpl.getKeysNotNull(map);
        return resultsWithInMemory;
    }

    @Override
    @UiThread
    @NotNull
    public RawJsonRepositoryRemoveResult remove(@NotNull Function1<? super RawJson, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        KAssert this_$iv = KAssert.INSTANCE;
        boolean $i$f$assertMainThread = false;
        if (Assert.isEnabled()) {
            Assert.assertMainThread();
        }
        DivStorage.RemoveResult removeResult = this.divStorage.removeRawJsons(predicate);
        Set<String> deletedIds = removeResult.component1();
        List<StorageException> storageExceptions = removeResult.component2();
        List<RawJsonRepositoryException> exceptions = this.toRawJsonRepositoryExceptions(storageExceptions);
        this.removeFromInMemory(deletedIds);
        return new RawJsonRepositoryRemoveResult(deletedIds, exceptions);
    }

    private final RawJsonRepositoryResult loadFromStorage(Set<String> ids) {
        List exceptions = new ArrayList();
        DivStorage.LoadDataResult<RawJson> loadDataResult = this.divStorage.readRawJsons(ids);
        List<RawJson> rawJsons = loadDataResult.component1();
        List<StorageException> storageExceptions = loadDataResult.component2();
        exceptions.addAll((Collection)this.toRawJsonRepositoryExceptions(storageExceptions));
        return new RawJsonRepositoryResult(rawJsons, exceptions);
    }

    private final void removeFromInMemory(Set<String> deletedRecords) {
        Iterable $this$forEach$iv = deletedRecords;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.inMemoryData.remove(it);
        }
    }

    private final <K, V> Set<K> getKeysNotNull(Map<K, ? extends V> $this$getKeysNotNull) {
        Set filteredKeys = new LinkedHashSet();
        Iterator<Map.Entry<K, V>> iterator = $this$getKeysNotNull.entrySet().iterator();
        while (iterator.hasNext()) {
            K key = iterator.next().getKey();
            if (key == null) continue;
            filteredKeys.add(key);
        }
        return filteredKeys;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RawJsonRepositoryException> toRawJsonRepositoryExceptions(List<? extends StorageException> $this$toRawJsonRepositoryExceptions) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toRawJsonRepositoryExceptions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StorageException storageException = (StorageException)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new RawJsonRepositoryException((StorageException)it));
        }
        return (List)destination$iv$iv;
    }
}

