/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage.analytics;

import androidx.annotation.VisibleForTesting;
import com.yandex.div.internal.Assert;
import com.yandex.div.internal.KAssert;
import com.yandex.div.json.ParsingErrorLogger;
import com.yandex.div.json.ParsingException;
import com.yandex.div.json.ParsingExceptionReason;
import com.yandex.div.storage.analytics.ErrorExplanation;
import com.yandex.div.storage.analytics.TemplateCardErrorTransformerKt;
import com.yandex.div.storage.templates.TemplatesContainer;
import com.yandex.div.storage.util.CardErrorTransformer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/yandex/div/storage/analytics/TemplateCardErrorTransformer;", "Lcom/yandex/div/storage/util/CardErrorTransformer;", "templateContainer", "Lcom/yandex/div/storage/templates/TemplatesContainer;", "internalLogger", "Lcom/yandex/div/json/ParsingErrorLogger;", "(Lcom/yandex/div/storage/templates/TemplatesContainer;Lcom/yandex/div/json/ParsingErrorLogger;)V", "tryTransformAndLog", "", "cardError", "Lcom/yandex/div/storage/util/CardErrorTransformer$CardDetailedErrorException;", "Companion", "div-storage_release"})
@SourceDebugExtension(value={"SMAP\nTemplateCardErrorTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplateCardErrorTransformer.kt\ncom/yandex/div/storage/analytics/TemplateCardErrorTransformer\n+ 2 KAssert.kt\ncom/yandex/div/internal/KAssert\n*L\n1#1,76:1\n14#2,4:77\n*S KotlinDebug\n*F\n+ 1 TemplateCardErrorTransformer.kt\ncom/yandex/div/storage/analytics/TemplateCardErrorTransformer\n*L\n25#1:77,4\n*E\n"})
public class TemplateCardErrorTransformer
implements CardErrorTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TemplatesContainer templateContainer;
    @NotNull
    private final ParsingErrorLogger internalLogger;

    public TemplateCardErrorTransformer(@NotNull TemplatesContainer templateContainer, @NotNull ParsingErrorLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)templateContainer, (String)"templateContainer");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.templateContainer = templateContainer;
        this.internalLogger = internalLogger;
    }

    @Override
    public boolean tryTransformAndLog(@NotNull CardErrorTransformer.CardDetailedErrorException cardError) {
        Intrinsics.checkNotNullParameter((Object)cardError, (String)"cardError");
        ParsingException parsingException = Companion.extractMissingTemplateException$div_storage_release(cardError);
        if (parsingException == null) {
            return false;
        }
        ParsingException missingTemplate = parsingException;
        String string = TemplateCardErrorTransformerKt.access$getTemplateName(missingTemplate);
        if (string == null) {
            TemplateCardErrorTransformer $this$tryTransformAndLog_u24lambda_u241 = this;
            boolean bl = false;
            KAssert this_$iv = KAssert.INSTANCE;
            boolean $i$f$fail = false;
            if (Assert.isEnabled()) {
                boolean bl2 = false;
                Assert.fail((String)("Failed to parse template name from '" + missingTemplate.getMessage() + '\''));
            }
            return false;
        }
        String templateName = string;
        String cardId = cardError.getCardId();
        String groupId = cardError.getGroupId$div_storage_release();
        ErrorExplanation explanation = this.templateContainer.explainMissingTemplate(cardId, groupId, templateName);
        Map<String, String> details = explanation.getAllDetails();
        String errorMessage = "missing template = " + templateName + ", reason = " + explanation.getShortReason();
        this.internalLogger.logError((Exception)new CardErrorTransformer.CardDetailedErrorException(cardId, errorMessage, cardError, cardId, details, cardError.getGroupId$div_storage_release(), cardError.getMetadata()));
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/yandex/div/storage/analytics/TemplateCardErrorTransformer$Companion;", "", "()V", "extractMissingTemplateException", "Lcom/yandex/div/json/ParsingException;", "cardError", "", "extractMissingTemplateException$div_storage_release", "div-storage_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final ParsingException extractMissingTemplateException$div_storage_release(@NotNull Throwable cardError) {
            Intrinsics.checkNotNullParameter((Object)cardError, (String)"cardError");
            if (!(cardError instanceof ParsingException)) {
                Throwable throwable = cardError.getCause();
                if (throwable == null) {
                    return null;
                }
                Throwable cause = throwable;
                return this.extractMissingTemplateException$div_storage_release(cause);
            }
            ParsingExceptionReason reason = ((ParsingException)cardError).getReason();
            if (reason == ParsingExceptionReason.MISSING_TEMPLATE) {
                return (ParsingException)cardError;
            }
            Throwable throwable = cardError.getCause();
            if (throwable == null) {
                return null;
            }
            Throwable cause = throwable;
            return this.extractMissingTemplateException$div_storage_release(cause);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

