/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage.templates;

import androidx.annotation.WorkerThread;
import com.yandex.div.data.DivParsingEnvironment;
import com.yandex.div.json.ParsingErrorLogger;
import com.yandex.div.json.TemplateParsingEnvironment;
import com.yandex.div.json.templates.CachingTemplateProvider;
import com.yandex.div.storage.DivStorage;
import com.yandex.div.storage.DivStorageErrorException;
import com.yandex.div.storage.analytics.ErrorExplanation;
import com.yandex.div.storage.database.StorageException;
import com.yandex.div.storage.histogram.HistogramNameProvider;
import com.yandex.div.storage.histogram.HistogramRecorder;
import com.yandex.div.storage.templates.CommonTemplatesPool;
import com.yandex.div.storage.templates.DivParsingHistogramProxy;
import com.yandex.div.storage.templates.Template;
import com.yandex.div.storage.templates.TemplateHashIds;
import com.yandex.div.storage.templates.TemplateReferenceResolver;
import com.yandex.div.storage.templates.TemplatesContainerKt;
import com.yandex.div2.DivTemplate;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ(\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00102\u0006\u0010$\u001a\u00020%H\u0012J$\u0010(\u001a\u0016\u0012\b\u0012\u00060\u0010j\u0002`)\u0012\b\u0012\u00060\u0010j\u0002`*0\u000f2\u0006\u0010$\u001a\u00020%H\u0012J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0010H\u0012J\"\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u0010H\u0017J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0010H\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020\u0010H\u0012J\b\u00102\u001a\u000203H\u0012J\"\u00104\u001a\b\u0012\u0004\u0012\u00020\u0010052\b\u00106\u001a\u0004\u0018\u00010\u00102\b\u0010&\u001a\u0004\u0018\u00010\u0010H\u0012J\u0012\u00107\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020908H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00120\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00158RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u001b0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/yandex/div/storage/templates/TemplatesContainer;", "", "divStorage", "Lcom/yandex/div/storage/DivStorage;", "errorLogger", "Lcom/yandex/div/json/ParsingErrorLogger;", "histogramRecorder", "Lcom/yandex/div/storage/histogram/HistogramRecorder;", "parsingHistogramProxy", "Ljavax/inject/Provider;", "Lcom/yandex/div/storage/templates/DivParsingHistogramProxy;", "histogramNameProvider", "Lcom/yandex/div/storage/histogram/HistogramNameProvider;", "(Lcom/yandex/div/storage/DivStorage;Lcom/yandex/div/json/ParsingErrorLogger;Lcom/yandex/div/storage/histogram/HistogramRecorder;Ljavax/inject/Provider;Lcom/yandex/div/storage/histogram/HistogramNameProvider;)V", "groupTemplateReferences", "", "", "Lcom/yandex/div/storage/templates/GroupId;", "Lcom/yandex/div/storage/templates/TemplateReferenceResolver;", "histogramComponentName", "messageDigest", "Ljava/security/MessageDigest;", "getMessageDigest", "()Ljava/security/MessageDigest;", "messageDigest$delegate", "Lkotlin/Lazy;", "templateEnvironments", "Lcom/yandex/div/data/DivParsingEnvironment;", "templateReferencesLoaded", "", "templatesPool", "Lcom/yandex/div/storage/templates/CommonTemplatesPool;", "addTemplates", "", "Lcom/yandex/div/storage/templates/Template;", "groupId", "json", "Lorg/json/JSONObject;", "sourceType", "calculateJsonChecksum", "calculateTemplateHashes", "Lcom/yandex/div/storage/templates/TemplateId;", "Lcom/yandex/div/storage/templates/TemplateHash;", "createEnvBy", "explainMissingTemplate", "Lcom/yandex/div/storage/analytics/ErrorExplanation;", "cardId", "templateId", "getEnvironment", "getTemplates", "loadIfNeeded", "", "parsingHistograms", "", "baseName", "loadedTemplatesDetails", "Lcom/yandex/div/json/templates/CachingTemplateProvider;", "Lcom/yandex/div2/DivTemplate;", "div-storage_release"})
@SourceDebugExtension(value={"SMAP\nTemplatesContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplatesContainer.kt\ncom/yandex/div/storage/templates/TemplatesContainer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Timing.kt\nkotlin/system/TimingKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 TemplatesContainer.kt\ncom/yandex/div/storage/templates/TemplateReferenceResolver\n+ 8 JsonUtils.kt\ncom/yandex/div/internal/util/JsonUtilsKt\n*L\n1#1,382:1\n361#2,7:383\n361#2,7:404\n1855#3,2:390\n1855#3,2:401\n1855#3:403\n1856#3:411\n1855#3,2:415\n1#4:392\n17#5,6:393\n215#6,2:399\n215#6:412\n216#6:421\n356#7,2:413\n358#7,4:417\n7#8,6:422\n*S KotlinDebug\n*F\n+ 1 TemplatesContainer.kt\ncom/yandex/div/storage/templates/TemplatesContainer\n*L\n62#1:383,7\n211#1:404,7\n127#1:390,2\n206#1:401,2\n210#1:403\n210#1:411\n226#1:415,2\n146#1:393,6\n161#1:399,2\n225#1:412\n225#1:421\n226#1:413,2\n226#1:417,4\n242#1:422,6\n*E\n"})
public class TemplatesContainer {
    @NotNull
    private final DivStorage divStorage;
    @NotNull
    private final ParsingErrorLogger errorLogger;
    @NotNull
    private final HistogramRecorder histogramRecorder;
    @NotNull
    private final Provider<DivParsingHistogramProxy> parsingHistogramProxy;
    @Nullable
    private final HistogramNameProvider histogramNameProvider;
    private boolean templateReferencesLoaded;
    @Nullable
    private final String histogramComponentName;
    @NotNull
    private final CommonTemplatesPool templatesPool;
    @NotNull
    private final Map<String, TemplateReferenceResolver> groupTemplateReferences;
    @NotNull
    private final Map<String, DivParsingEnvironment> templateEnvironments;
    @NotNull
    private final Lazy messageDigest$delegate;

    public TemplatesContainer(@NotNull DivStorage divStorage, @NotNull ParsingErrorLogger errorLogger, @NotNull HistogramRecorder histogramRecorder, @NotNull Provider<DivParsingHistogramProxy> parsingHistogramProxy2, @Nullable HistogramNameProvider histogramNameProvider) {
        Intrinsics.checkNotNullParameter((Object)divStorage, (String)"divStorage");
        Intrinsics.checkNotNullParameter((Object)errorLogger, (String)"errorLogger");
        Intrinsics.checkNotNullParameter((Object)histogramRecorder, (String)"histogramRecorder");
        Intrinsics.checkNotNullParameter(parsingHistogramProxy2, (String)"parsingHistogramProxy");
        this.divStorage = divStorage;
        this.errorLogger = errorLogger;
        this.histogramRecorder = histogramRecorder;
        this.parsingHistogramProxy = parsingHistogramProxy2;
        HistogramNameProvider histogramNameProvider2 = this.histogramNameProvider = histogramNameProvider;
        this.histogramComponentName = histogramNameProvider2 != null ? histogramNameProvider2.getComponentName() : null;
        this.templatesPool = new CommonTemplatesPool(this.divStorage, this.errorLogger, this.histogramComponentName, this.histogramRecorder, this.parsingHistogramProxy);
        this.groupTemplateReferences = new LinkedHashMap();
        this.templateEnvironments = new LinkedHashMap();
        this.messageDigest$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MessageDigest>(this){
            final /* synthetic */ TemplatesContainer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final MessageDigest invoke() {
                MessageDigest messageDigest2;
                try {
                    messageDigest2 = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    TemplatesContainer.access$getErrorLogger$p(this.this$0).logError((Exception)new IllegalStateException("Storage cannot work with templates!", e));
                    messageDigest2 = null;
                }
                return messageDigest2;
            }
        }));
    }

    public /* synthetic */ TemplatesContainer(DivStorage divStorage, ParsingErrorLogger parsingErrorLogger, HistogramRecorder histogramRecorder, Provider provider, HistogramNameProvider histogramNameProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            histogramNameProvider = null;
        }
        this(divStorage, parsingErrorLogger, histogramRecorder, (Provider<DivParsingHistogramProxy>)provider, histogramNameProvider);
    }

    private MessageDigest getMessageDigest() {
        Lazy lazy = this.messageDigest$delegate;
        return (MessageDigest)lazy.getValue();
    }

    @NotNull
    public DivParsingEnvironment getEnvironment(@NotNull String groupId) {
        DivParsingEnvironment divParsingEnvironment;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        this.loadIfNeeded();
        Map<String, DivParsingEnvironment> $this$getOrPut$iv = this.templateEnvironments;
        boolean $i$f$getOrPut = false;
        DivParsingEnvironment value$iv = $this$getOrPut$iv.get(groupId);
        if (value$iv == null) {
            boolean bl = false;
            DivParsingEnvironment answer$iv = this.createEnvBy(groupId);
            $this$getOrPut$iv.put(groupId, answer$iv);
            divParsingEnvironment = answer$iv;
        } else {
            divParsingEnvironment = value$iv;
        }
        return divParsingEnvironment;
    }

    @WorkerThread
    @NotNull
    public ErrorExplanation explainMissingTemplate(@Nullable String cardId, @NotNull String groupId, @NotNull String templateId) {
        StringBuilder details;
        String shortReason;
        block6: {
            Object object;
            String string;
            List exceptions;
            CachingTemplateProvider templateProvider;
            block8: {
                block7: {
                    String templateHash;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
                        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
                        TemplateReferenceResolver templateReferenceResolver = this.groupTemplateReferences.get(groupId);
                        templateHash = templateReferenceResolver != null ? templateReferenceResolver.resolveTemplateHash(templateId) : null;
                        DivParsingEnvironment divParsingEnvironment = this.templateEnvironments.get(groupId);
                        templateProvider = divParsingEnvironment != null ? divParsingEnvironment.getTemplates() : null;
                        shortReason = null;
                        details = new StringBuilder();
                        exceptions = new ArrayList();
                        CachingTemplateProvider cachingTemplateProvider = templateProvider;
                        if ((cachingTemplateProvider != null ? (DivTemplate)cachingTemplateProvider.get(templateId) : null) == null) break block5;
                        shortReason = "unknown, template is loaded";
                        break block6;
                    }
                    if (TemplatesContainer.explainMissingTemplate$templateStored(templateHash, this, exceptions)) break block7;
                    details.append("supported responses: " + CollectionsKt.joinToString$default((Iterable)this.groupTemplateReferences.keySet(), null, null, null, (int)0, null, null, (int)63, null));
                    if (!this.groupTemplateReferences.keySet().contains(groupId)) {
                        shortReason = "cached, but not loaded into memory";
                    } else {
                        shortReason = "cached, but loaded partially";
                        CachingTemplateProvider cachingTemplateProvider = templateProvider;
                        details.append(' ' + (cachingTemplateProvider != null ? this.loadedTemplatesDetails((CachingTemplateProvider<DivTemplate>)cachingTemplateProvider) : null));
                    }
                    break block6;
                }
                if (TemplatesContainer.explainMissingTemplate$cardStored(cardId, this, groupId, exceptions)) break block8;
                shortReason = "access templates ahead of time";
                break block6;
            }
            if (!((Collection)exceptions).isEmpty()) {
                Iterable $this$forEach$iv = exceptions;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DivStorageErrorException it = (DivStorageErrorException)element$iv;
                    boolean bl = false;
                    details.append(it.getMessage() + ";\n");
                }
                string = "fatal exception when explaining reason";
            } else {
                string = shortReason = "not present in original response";
            }
            if ((object = templateProvider) == null || (object = this.loadedTemplatesDetails((CachingTemplateProvider<DivTemplate>)object)) == null) break block6;
            Object it = object;
            boolean bl = false;
            details.append((String)it);
        }
        return new ErrorExplanation(shortReason, details.toString());
    }

    @NotNull
    public List<Template> addTemplates(@NotNull String groupId, @NotNull JSONObject json, @Nullable String sourceType) {
        TemplateParsingEnvironment.TemplateParsingResult<DivTemplate> templateParsingResult;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        HistogramNameProvider histogramNameProvider = this.histogramNameProvider;
        String parseHistogramBaseName = histogramNameProvider != null ? histogramNameProvider.getDivParsingHistogramName() : null;
        Map<String, String> templateHashes = this.calculateTemplateHashes(json);
        DivParsingEnvironment env = this.getEnvironment(groupId);
        if (parseHistogramBaseName != null) {
            Set<String> parsingHistogramNames = this.parsingHistograms(parseHistogramBaseName, sourceType);
            TemplateParsingEnvironment.TemplateParsingResult<DivTemplate> results = null;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            results = ((DivParsingHistogramProxy)this.parsingHistogramProxy.get()).parseTemplatesWithResultsAndDependencies(env, json, this.histogramComponentName);
            long duration = System.currentTimeMillis() - start$iv;
            this.histogramRecorder.reportTemplatesParseTime(parsingHistogramNames, duration);
            templateParsingResult = results;
        } else {
            templateParsingResult = ((DivParsingHistogramProxy)this.parsingHistogramProxy.get()).parseTemplatesWithResultsAndDependencies(env, json, this.histogramComponentName);
        }
        TemplateParsingEnvironment.TemplateParsingResult<DivTemplate> templateParsingResult2 = templateParsingResult;
        env.getTemplates().putAll(templateParsingResult2.getParsedTemplates());
        ArrayList<Template> results = new ArrayList<Template>(templateParsingResult2.getParsedTemplates().size());
        Map $this$forEach$iv = templateParsingResult2.getParsedTemplates();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            JSONObject jSONObject;
            String templateHash;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String id = (String)entry.getKey();
            DivTemplate template = (DivTemplate)entry.getValue();
            if (templateHashes.get(id) == null) {
                TemplatesContainer $this$addTemplates_u24lambda_u247_u24lambda_u244 = this;
                boolean bl2 = false;
                $this$addTemplates_u24lambda_u247_u24lambda_u244.errorLogger.logError((Exception)new IllegalStateException("No corresponding template was found for templateId = " + id));
                continue;
            }
            this.templatesPool.put(templateHash, template);
            JSONObject jSONObject2 = jSONObject = json.optJSONObject(id);
            if (jSONObject2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"optJSONObject(id)");
                JSONObject rawTemplate = jSONObject;
                boolean bl3 = false;
                results.add(new Template(id, templateHash, rawTemplate));
                continue;
            }
            TemplatesContainer $this$addTemplates_u24lambda_u247_u24lambda_u246 = this;
            boolean bl4 = false;
            $this$addTemplates_u24lambda_u247_u24lambda_u246.errorLogger.logError((Exception)new IllegalStateException("No raw template found for templateId = " + id));
        }
        this.templateEnvironments.put(groupId, env);
        this.groupTemplateReferences.put(groupId, new TemplateReferenceResolver(this.errorLogger));
        return results;
    }

    private String loadedTemplatesDetails(CachingTemplateProvider<DivTemplate> $this$loadedTemplatesDetails) {
        Map snapshot = new LinkedHashMap();
        $this$loadedTemplatesDetails.takeSnapshot(snapshot);
        return "in-memory templates count: " + snapshot.size();
    }

    private Set<String> parsingHistograms(String baseName, String sourceType) {
        Set set;
        if (baseName != null) {
            Object object = new String[]{baseName};
            Object $this$parsingHistograms_u24lambda_u248 = object = SetsKt.linkedSetOf((Object[])object);
            boolean bl = false;
            if (sourceType != null) {
                ((HashSet)$this$parsingHistograms_u24lambda_u248).add(baseName + '.' + sourceType);
            }
            set = (Set)object;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private void loadIfNeeded() {
        Object it;
        if (this.templateReferencesLoaded) {
            return;
        }
        this.templateReferencesLoaded = true;
        DivStorage.LoadDataResult<DivStorage.TemplateReference> loadResult = this.divStorage.readTemplateReferences();
        Iterable $this$forEach$iv = loadResult.getErrors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StorageException)element$iv;
            boolean bl = false;
            this.errorLogger.logError((Exception)it);
        }
        $this$forEach$iv = loadResult.getRestoredData();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            it = (DivStorage.TemplateReference)element$iv;
            boolean bl = false;
            Map<String, TemplateReferenceResolver> map = this.groupTemplateReferences;
            String key$iv = ((DivStorage.TemplateReference)it).getGroupId();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                TemplateReferenceResolver answer$iv = new TemplateReferenceResolver(this.errorLogger);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            TemplateReferenceResolver references = (TemplateReferenceResolver)object;
            references.add((DivStorage.TemplateReference)it);
        }
    }

    private DivParsingEnvironment createEnvBy(String groupId) {
        TemplateReferenceResolver templateReferenceResolver = this.getTemplates(groupId);
        if (templateReferenceResolver == null) {
            return TemplatesContainerKt.access$createEmptyEnv(this.errorLogger);
        }
        TemplateReferenceResolver referenceResolver = templateReferenceResolver;
        Map<String, DivTemplate> templatesByHash = this.templatesPool.load(referenceResolver);
        DivParsingEnvironment env = TemplatesContainerKt.access$createEmptyEnv(this.errorLogger);
        HashMap templatesById = new HashMap(templatesByHash.size());
        Map<String, DivTemplate> $this$forEach$iv = templatesByHash;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DivTemplate>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            String templateId;
            Map.Entry<String, DivTemplate> element$iv;
            Map.Entry<String, DivTemplate> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String hash = entry.getKey();
            DivTemplate json = entry.getValue();
            TemplateReferenceResolver this_$iv = referenceResolver;
            boolean $i$f$doOnEachResolvedId = false;
            TemplateHashIds ids$iv = (TemplateHashIds)TemplateReferenceResolver.access$getTemplateIdRefs(this_$iv).get(hash);
            if (ids$iv instanceof TemplateHashIds.Collection) {
                Iterable $this$forEach$iv$iv = ((TemplateHashIds.Collection)ids$iv).unbox-impl();
                boolean $i$f$forEach2 = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    String it$iv = (String)element$iv$iv;
                    boolean bl3 = false;
                    templateId = it$iv;
                    bl = false;
                    ((Map)templatesById).put(templateId, json);
                }
                continue;
            }
            if (ids$iv instanceof TemplateHashIds.Single) {
                templateId = ((TemplateHashIds.Single)ids$iv).unbox-impl();
                bl = false;
                ((Map)templatesById).put(templateId, json);
                continue;
            }
            if (ids$iv != null) continue;
            TemplateReferenceResolver.access$getLogger$p(this_$iv).logError((Exception)new IllegalStateException("No template id was found for hash!"));
        }
        env.getTemplates().putAll((Map)templatesById);
        return env;
    }

    private TemplateReferenceResolver getTemplates(String groupId) {
        this.loadIfNeeded();
        return this.groupTemplateReferences.get(groupId);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> calculateTemplateHashes(JSONObject json) {
        Map results = new LinkedHashMap();
        JSONObject $this$forEach$iv = json;
        boolean $i$f$forEach = false;
        Iterator keys$iv = $this$forEach$iv.keys();
        Intrinsics.checkNotNullExpressionValue((Object)keys$iv, (String)"keys");
        Iterator iterator = keys$iv;
        while (iterator.hasNext()) {
            String checksum;
            void templateJson;
            String key$iv = (String)iterator.next();
            Object value$iv = $this$forEach$iv.get(key$iv);
            if (!(value$iv instanceof JSONObject)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)key$iv, (String)"key");
            JSONObject jSONObject = (JSONObject)value$iv;
            String templateId = key$iv;
            boolean bl = false;
            if (this.calculateJsonChecksum((JSONObject)templateJson) == null) continue;
            results.put(templateId, checksum);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateJsonChecksum(JSONObject json) {
        byte[] byArray;
        String string = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
        String string2 = string;
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        byte[] input = byArray2;
        TemplatesContainer templatesContainer = this;
        synchronized (templatesContainer) {
            boolean bl = false;
            MessageDigest messageDigest2 = this.getMessageDigest();
            byArray = (byte[])(messageDigest2 != null ? messageDigest2.digest(input) : null);
        }
        if (byArray == null) {
            return null;
        }
        byte[] md5bytes = byArray;
        String string3 = new BigInteger(1, md5bytes).toString(16);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"BigInteger(1, md5bytes).toString(16)");
        return StringsKt.padStart((String)string3, (int)32, (char)'0');
    }

    private static final boolean explainMissingTemplate$cardStored(String $cardId, TemplatesContainer this$0, String $groupId, List<DivStorageErrorException> exceptions) {
        boolean bl;
        if ($cardId != null) {
            boolean bl2;
            try {
                bl2 = this$0.divStorage.isCardExists($cardId, $groupId);
            }
            catch (DivStorageErrorException e) {
                exceptions.add(e);
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean explainMissingTemplate$templateStored(String templateHash, TemplatesContainer this$0, List<DivStorageErrorException> exceptions) {
        boolean bl;
        if (templateHash == null) {
            return false;
        }
        try {
            bl = this$0.divStorage.isTemplateExists(templateHash);
        }
        catch (DivStorageErrorException e) {
            exceptions.add(e);
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ ParsingErrorLogger access$getErrorLogger$p(TemplatesContainer $this) {
        return $this.errorLogger;
    }
}

